/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.compatibility;

import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowExternalProcessProxy;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkflowExternalProcess;
import com.day.cq.workflow.impl.CQWorkflowSessionWrapper;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import com.day.cq.workflow.impl.metadata.CQMetaDataMap;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="%cq.workflow.compat.extproxy.name", description="%cq.workflow.compat.extproxy.description")
@Property(name="service.description", value={"%cq.workflow.compat.extproxy.description"})
@Reference(name="WorkflowExternalProcess", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=WorkflowExternalProcess.class, policy=ReferencePolicy.DYNAMIC)
@Service
public class CQWorkflowExtProcessProxy
implements WorkflowExternalProcessProxy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private WorkflowService cqWorkflowService;
    protected List<WorkflowExternalProcess> externalProcesses = new CopyOnWriteArrayList<WorkflowExternalProcess>();

    public void bindWorkflowExternalProcess(WorkflowExternalProcess process) {
        this.externalProcesses.add(process);
    }

    public void unbindWorkflowExternalProcess(WorkflowExternalProcess process) {
        this.externalProcesses.remove(process);
    }

    @Override
    public Serializable execute(String externalProcessName, WorkItem workItem, com.adobe.granite.workflow.WorkflowSession workflowSession, MetaDataMap metaDataMap) throws com.adobe.granite.workflow.WorkflowException {
        WorkflowExternalProcess extProc = this.getExternalProcess(externalProcessName);
        if (extProc != null) {
            CQWorkflowSessionWrapper sessionWrapper = new CQWorkflowSessionWrapper(this.cqWorkflowService, workflowSession);
            CQWorkItemWrapper workItemWrapper = new CQWorkItemWrapper(workItem);
            CQMetaDataMap cqMetaDataMap = new CQMetaDataMap(metaDataMap);
            try {
                return extProc.execute((com.day.cq.workflow.exec.WorkItem)workItemWrapper, (WorkflowSession)sessionWrapper, (com.day.cq.workflow.metadata.MetaDataMap)cqMetaDataMap);
            }
            catch (WorkflowException e) {
                throw new com.adobe.granite.workflow.WorkflowException(e.getMessage(), e.getCause());
            }
        }
        this.log.info("no process found in proxy for external process {}", (Object)externalProcessName);
        return null;
    }

    @Override
    public boolean hasFinished(String externalProcessName, Serializable serializable, WorkItem workItem, com.adobe.granite.workflow.WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        WorkflowExternalProcess extProc = this.getExternalProcess(externalProcessName);
        if (extProc != null) {
            CQWorkflowSessionWrapper sessionWrapper = new CQWorkflowSessionWrapper(this.cqWorkflowService, workflowSession);
            CQWorkItemWrapper workItemWrapper = new CQWorkItemWrapper(workItem);
            CQMetaDataMap cqMetaDataMap = new CQMetaDataMap(metaDataMap);
            return extProc.hasFinished(serializable, (com.day.cq.workflow.exec.WorkItem)workItemWrapper, (WorkflowSession)sessionWrapper, (com.day.cq.workflow.metadata.MetaDataMap)cqMetaDataMap);
        }
        this.log.info("no process found in proxy for external process {}", (Object)externalProcessName);
        return true;
    }

    @Override
    public void handleResult(String externalProcessName, Serializable serializable, WorkItem workItem, com.adobe.granite.workflow.WorkflowSession workflowSession, MetaDataMap metaDataMap) throws com.adobe.granite.workflow.WorkflowException {
        WorkflowExternalProcess extProc = this.getExternalProcess(externalProcessName);
        if (extProc != null) {
            CQWorkflowSessionWrapper sessionWrapper = new CQWorkflowSessionWrapper(this.cqWorkflowService, workflowSession);
            CQWorkItemWrapper workItemWrapper = new CQWorkItemWrapper(workItem);
            CQMetaDataMap cqMetaDataMap = new CQMetaDataMap(metaDataMap);
            try {
                extProc.handleResult(serializable, (com.day.cq.workflow.exec.WorkItem)workItemWrapper, (WorkflowSession)sessionWrapper, (com.day.cq.workflow.metadata.MetaDataMap)cqMetaDataMap);
            }
            catch (WorkflowException e) {
                throw new com.adobe.granite.workflow.WorkflowException(e.getMessage(), e.getCause());
            }
        } else {
            this.log.info("no process found in proxy for external process {}", (Object)externalProcessName);
        }
    }

    @Override
    public boolean canHandle(String externalProcessName) {
        return this.getExternalProcess(externalProcessName) != null;
    }

    private WorkflowExternalProcess getExternalProcess(String externalProcessName) {
        if (externalProcessName != null) {
            for (WorkflowExternalProcess workflowProcess : this.externalProcesses) {
                if (!externalProcessName.equals(workflowProcess.getClass().getName())) continue;
                return workflowProcess;
            }
        }
        return null;
    }

    protected void bindCqWorkflowService(WorkflowService workflowService) {
        this.cqWorkflowService = workflowService;
    }

    protected void unbindCqWorkflowService(WorkflowService workflowService) {
        if (this.cqWorkflowService == workflowService) {
            this.cqWorkflowService = null;
        }
    }
}

