/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.util;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.HistoryItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkflowUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUtil.class);

    public static Collection<Job> getWorkflowJobs(JobManager jobManager, WorkflowSession wfSession) {
        WorkflowModel[] models;
        ArrayList<Job> wfJobs = new ArrayList<Job>();
        try {
            models = wfSession.getModels();
        }
        catch (WorkflowException we) {
            log.error("Cannot retrieve workflow model list", we);
            return Collections.EMPTY_LIST;
        }
        for (WorkflowModel model : models) {
            String topicName = "com/adobe/granite/workflow/job" + model.getId().replace("jcr:content", "jcr_content");
            wfJobs.addAll(jobManager.findJobs(JobManager.QueryType.ALL, topicName, -1L, new Map[0]));
        }
        Collection<Job> toJobs = jobManager.findJobs(JobManager.QueryType.ALL, "com/adobe/granite/workflow/timeout/job", -1L, new Map[0]);
        wfJobs.addAll(toJobs);
        Collection<Job> extJobs = jobManager.findJobs(JobManager.QueryType.ALL, "com/adobe/granite/workflow/external/job", -1L, new Map[0]);
        wfJobs.addAll(extJobs);
        log.debug("WORKFLOW JOBS: " + wfJobs.size());
        return wfJobs;
    }

    public static boolean isStaleWorkflow(Workflow workflow, Collection<Job> wfJobs) {
        return false;
    }

    public static String getAuthorizableFromLastStep(WorkflowSession session, Workflow workflow, String nodeId) throws WorkflowException {
        List<HistoryItem> historyList = session.getHistory(workflow);
        for (int i = historyList.size(); i > 0; --i) {
            HistoryItem item = historyList.get(i - 1);
            if (item.getWorkItem() == null || !item.getWorkItem().getNode().getId().equals(nodeId)) continue;
            return item.getUserId();
        }
        return null;
    }
}

