/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics;

import com.day.crx.statistics.PathBuilder;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.JcrUtils;

public abstract class Entry {
    private long timestamp = System.currentTimeMillis();
    private String pathPrefix;

    public Entry(String pathPrefix) {
        this.setPathPrefix(pathPrefix);
    }

    public final void write(Session session) throws RepositoryException {
        String path = this.getPath();
        Node node = JcrUtils.getOrCreateByPath(path, "nt:unstructured", "nt:unstructured", session, true);
        this.write(node);
    }

    public void write(Node node) throws RepositoryException {
        node.setProperty("timestamp", this.getTimestamp());
    }

    public final String getPath() {
        StringBuffer buffer = new StringBuffer();
        this.getPathBuilder().formatPath(this, buffer);
        return buffer.toString();
    }

    protected abstract PathBuilder getPathBuilder();

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        if (pathPrefix.equals("/")) {
            pathPrefix = "";
        }
        this.pathPrefix = pathPrefix;
    }
}

