/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.result;

import com.day.crx.statistics.Report;
import com.day.crx.statistics.result.ResultsByQueryReport;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;

public class RelatedQueriesReport
extends Report {
    private final String query;
    private int size = 5;
    private final boolean traversalOk;

    public RelatedQueriesReport(String dataPath, String query) {
        this(dataPath, query, false);
    }

    public RelatedQueriesReport(String dataPath, String query, boolean traversalOk) {
        super(dataPath);
        this.query = query.toLowerCase();
        this.traversalOk = traversalOk;
    }

    public Iterator getResult(Session session) throws RepositoryException {
        ResultsByQueryReport report = new ResultsByQueryReport(this.getDataPath(), this.query, this.traversalOk);
        List<String> related = new ArrayList();
        Iterator it = report.getResult(session);
        while (it.hasNext() && related.size() < this.getSize()) {
            Object[] data = (Object[])it.next();
            StringBuffer path = new StringBuffer(this.getDataPath());
            path.append(data[0]);
            path.append("/");
            path.append(".stats");
            Item item = session.getItem(path.toString());
            if (!item.isNode()) continue;
            Calendar cal = Calendar.getInstance();
            Node stats = (Node)item;
            for (int i = 0; i < 3 && related.size() < this.getSize(); ++i) {
                Node y;
                String year = String.valueOf(cal.get(1));
                cal.add(1, 1);
                if (!stats.hasNode(year) || !(y = stats.getNode(year)).hasProperty("queries")) continue;
                Value[] values = y.getProperty("queries").getValues();
                for (int v = 0; v < values.length; ++v) {
                    String query = values[v].getString().toLowerCase();
                    if (query.equals(this.query) || related.contains(query)) continue;
                    related.add(query);
                }
            }
        }
        if (related.size() > this.getSize()) {
            related = related.subList(0, this.getSize());
        }
        for (int i = 0; i < related.size(); ++i) {
            related.set(i, (String)new Object[]{related.get(i)});
        }
        return related.iterator();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

