/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.result;

import com.day.crx.statistics.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;

public class ResultsByQueryReport
extends Report {
    private final String query;
    private int size = 10;
    private final boolean traversalOk;

    public ResultsByQueryReport(String dataPath, String query) {
        this(dataPath, query, false);
    }

    public ResultsByQueryReport(String dataPath, String query, boolean traversalOk) {
        super(dataPath);
        this.query = query;
        this.traversalOk = traversalOk;
    }

    public Iterator getResult(Session session) throws RepositoryException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(this.getDataPath());
        stmt.append("//*[@queries = '");
        stmt.append(this.query.replaceAll("'", "''"));
        stmt.append("' and @").append("avgPosition");
        stmt.append("]");
        if (this.traversalOk) {
            stmt.append(" option(traversal ok)");
        }
        HashMap<String, Long> paths = new HashMap<String, Long>();
        NodeIterator nodes = qm.createQuery(stmt.toString(), "xpath").execute().getNodes();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            String path = n.getPath();
            int idx = path.indexOf(".stats");
            if (idx == -1) continue;
            path = path.substring(0, idx - 1);
            Long count = (Long)paths.get(path = path.substring(this.getDataPath().length()));
            if (count == null) {
                count = new Long(0L);
            }
            if (!n.hasProperty("count")) continue;
            count = new Long(n.getProperty("count").getLong() + count);
            paths.put(path, count);
        }
        List data = new ArrayList<Object[]>();
        for (Map.Entry entry : paths.entrySet()) {
            data.add(new Object[]{entry.getKey(), entry.getValue()});
        }
        Collections.sort(data, new Comparator(){

            public int compare(Object o1, Object o2) {
                Object[] e2 = (Object[])o2;
                Object[] e1 = (Object[])o1;
                int comp = ((Comparable)e2[1]).compareTo(e1[1]);
                if (comp != 0) {
                    return comp;
                }
                return ((String)e1[0]).toLowerCase().compareTo(((String)e2[0]).toLowerCase());
            }
        });
        data = data.subList(0, Math.min(this.getSize(), data.size()));
        return data.iterator();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

