/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Decorator;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.helper.BlockHelper;
import com.github.jknack.handlebars.helper.EachHelper;
import com.github.jknack.handlebars.helper.EmbeddedHelper;
import com.github.jknack.handlebars.helper.HelperFunction;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.helper.IfHelper;
import com.github.jknack.handlebars.helper.InlineDecorator;
import com.github.jknack.handlebars.helper.LogHelper;
import com.github.jknack.handlebars.helper.LookupHelper;
import com.github.jknack.handlebars.helper.MethodHelper;
import com.github.jknack.handlebars.helper.PartialHelper;
import com.github.jknack.handlebars.helper.PrecompileHelper;
import com.github.jknack.handlebars.helper.UnlessHelper;
import com.github.jknack.handlebars.helper.WithHelper;
import com.github.jknack.handlebars.internal.Files;
import com.github.jknack.handlebars.internal.Throwing;
import com.github.jknack.handlebars.internal.lang3.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHelperRegistry
implements HelperRegistry {
    private final Logger logger = LoggerFactory.getLogger(HelperRegistry.class);
    private static final String HELPERS_ENV;
    private final Map<String, Helper<?>> helpers = new HashMap();
    private final Map<String, Decorator> decorators = new HashMap<String, Decorator>();
    private Charset charset = StandardCharsets.UTF_8;
    private ScriptEngine engine;
    private Pattern es6VarPattern = Pattern.compile("(?:^|[\\s(;])(let|const)\\s+");

    public DefaultHelperRegistry() {
        DefaultHelperRegistry.registerBuiltinsHelpers(this);
    }

    @Override
    public <C> Helper<C> helper(String name) {
        Validate.notEmpty((CharSequence)name, (String)"A helper's name is required.", (Object[])new Object[0]);
        return this.helpers.get(name);
    }

    @Override
    public <H> HelperRegistry registerHelper(String name, Helper<H> helper) {
        Validate.notEmpty((CharSequence)name, (String)"A helper's name is required.", (Object[])new Object[0]);
        Validate.notNull(helper, (String)"A helper is required.", (Object[])new Object[0]);
        Helper<H> oldHelper = this.helpers.put(name, helper);
        if (oldHelper != null) {
            this.logger.debug("Helper '{}' has been replaced by '{}'", (Object)name, (Object)helper);
        }
        return this;
    }

    @Override
    public <H> HelperRegistry registerHelperMissing(Helper<H> helper) {
        return this.registerHelper("helperMissing", helper);
    }

    @Override
    public HelperRegistry registerHelpers(Object helperSource) {
        Validate.notNull((Object)helperSource, (String)"The helper source is required.", (Object[])new Object[0]);
        Validate.isTrue((!(helperSource instanceof String) ? 1 : 0) != 0, (String)"java.lang.String isn't a helper source.", (Object[])new Object[0]);
        try {
            if (helperSource instanceof File) {
                return this.registerHelpers((File)helperSource);
            }
            if (helperSource instanceof URI) {
                return this.registerHelpers((URI)helperSource);
            }
            if (helperSource instanceof Class) {
                return this.registerHelpers((Class)helperSource);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't register helpers", ex);
        }
        this.registerDynamicHelper(helperSource, helperSource.getClass());
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(Class<?> helperSource) {
        Validate.notNull(helperSource, (String)"The helper source is required.", (Object[])new Object[0]);
        if (Enum.class.isAssignableFrom(helperSource)) {
            Enum[] helpers;
            for (Enum helper : helpers = (Enum[])helperSource.getEnumConstants()) {
                Validate.isTrue((boolean)(helper instanceof Helper), (String)"'%s' isn't a helper.", (Object[])new Object[]{helper.name()});
                this.registerHelper(helper.name(), (Helper)((Object)helper));
            }
        } else {
            this.registerDynamicHelper(null, helperSource);
        }
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(URI location) throws Exception {
        return this.registerHelpers(location.getPath(), Files.read((String)location.toString(), (Charset)this.charset));
    }

    @Override
    public HelperRegistry registerHelpers(File input) throws Exception {
        return this.registerHelpers(input.getAbsolutePath(), Files.read((File)input, (Charset)this.charset));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, Reader source) throws Exception {
        return this.registerHelpers(filename, Files.read((Reader)source));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, InputStream source) throws Exception {
        return this.registerHelpers(filename, Files.read((InputStream)source, (Charset)this.charset));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, String source) throws IOException {
        Validate.notNull((Object)filename, (String)"The filename is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)source, (String)"The source is required.", (Object[])new Object[0]);
        ScriptEngine engine = this.engine();
        Throwing.run(() -> engine.eval(this.adaptES6Literals(source)));
        return this;
    }

    @Override
    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.helpers.entrySet();
    }

    private String adaptES6Literals(String source) {
        Matcher m = this.es6VarPattern.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            StringBuffer buf = new StringBuffer(m.group());
            buf.replace(m.start(1) - m.start(), m.end(1) - m.start(), "var");
            m.appendReplacement(sb, buf.toString());
        }
        return m.appendTail(sb).toString();
    }

    private void registerDynamicHelper(Object source, Class<?> clazz) {
        if (clazz != Object.class) {
            Method[] methods;
            HashSet<String> overloaded = new HashSet<String>();
            for (Method method : methods = clazz.getDeclaredMethods()) {
                boolean isPublic = Modifier.isPublic(method.getModifiers());
                if (!isPublic) continue;
                boolean isStatic = Modifier.isStatic(method.getModifiers());
                if (source == null && !isStatic) continue;
                HelperFunction annotation = method.getAnnotation(HelperFunction.class);
                String helperName = annotation != null ? annotation.value() : method.getName();
                Validate.isTrue((boolean)overloaded.add(helperName), (String)("name conflict found: " + helperName), (Object[])new Object[0]);
                this.registerHelper(helperName, new MethodHelper(method, source));
            }
        }
    }

    private static void registerBuiltinsHelpers(HelperRegistry registry) {
        registry.registerHelper("with", WithHelper.INSTANCE);
        registry.registerHelper("if", IfHelper.INSTANCE);
        registry.registerHelper("unless", UnlessHelper.INSTANCE);
        registry.registerHelper("each", EachHelper.INSTANCE);
        registry.registerHelper("embedded", EmbeddedHelper.INSTANCE);
        registry.registerHelper("block", BlockHelper.INSTANCE);
        registry.registerHelper("partial", PartialHelper.INSTANCE);
        registry.registerHelper("precompile", PrecompileHelper.INSTANCE);
        registry.registerHelper("i18n", I18nHelper.i18n);
        registry.registerHelper("i18nJs", I18nHelper.i18nJs);
        registry.registerHelper("lookup", LookupHelper.INSTANCE);
        registry.registerHelper("log", LogHelper.INSTANCE);
        registry.registerDecorator("inline", InlineDecorator.INSTANCE);
    }

    @Override
    public Decorator decorator(String name) {
        Validate.notEmpty((CharSequence)name, (String)"A decorator's name is required.", (Object[])new Object[0]);
        return this.decorators.get(name);
    }

    @Override
    public HelperRegistry registerDecorator(String name, Decorator decorator) {
        Validate.notEmpty((CharSequence)name, (String)"A decorator's name is required.", (Object[])new Object[0]);
        Validate.notNull((Object)decorator, (String)"A decorator is required.", (Object[])new Object[0]);
        Decorator old = this.decorators.put(name, decorator);
        if (old != null) {
            this.logger.warn("Decorator '{}' has been replaced by '{}'", (Object)name, (Object)decorator);
        }
        return this;
    }

    @Override
    public DefaultHelperRegistry setCharset(Charset charset) {
        this.charset = (Charset)Validate.notNull((Object)charset, (String)"Charset required.", (Object[])new Object[0]);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptEngine engine() {
        DefaultHelperRegistry defaultHelperRegistry = this;
        synchronized (defaultHelperRegistry) {
            if (this.engine == null) {
                this.engine = new ScriptEngineManager().getEngineByName("nashorn");
                this.engine.put("Handlebars_java", this);
                Throwing.run(() -> this.engine.eval(HELPERS_ENV));
            }
            return this.engine;
        }
    }

    static {
        String file = "/helpers.nashorn.js";
        try {
            HELPERS_ENV = Files.read((String)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException x) {
            throw new IllegalStateException("File not found: " + file, x);
        }
    }
}

