/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.internal.lang3.StringUtils;
import com.github.jknack.handlebars.internal.lang3.Validate;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class AbstractTemplateLoader
implements TemplateLoader {
    private String prefix = "/";
    private String suffix = ".hbs";
    private Charset charset;

    @Override
    public String resolve(String uri) {
        return this.prefix + this.normalize(uri) + this.suffix;
    }

    protected String normalize(String location) {
        if (location.toString().startsWith("/")) {
            return location.substring(1);
        }
        return location;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = (String)Validate.notNull((Object)prefix, (String)"A view prefix is required.", (Object[])new Object[0]);
        if (!this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = StringUtils.defaultString((String)suffix, (String)"");
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = (Charset)Validate.notNull((Object)charset, (String)"Charset required.", (Object[])new Object[0]);
    }

    @Override
    public Charset getCharset() {
        return this.charset == null ? StandardCharsets.UTF_8 : this.charset;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }
}

