/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.soap.SOAPException;
import org.apache.servicemix.specs.locator.OsgiLocator;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String factoryClassName) throws SOAPException {
        ClassLoader classloader = null;
        try {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new SOAPException(exception.toString(), exception);
        }
        try {
            Class<?> factory = null;
            if (classloader == null) {
                factory = Class.forName(factoryClassName);
            } else {
                try {
                    factory = classloader.loadClass(factoryClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (factory == null) {
                classloader = FactoryFinder.class.getClassLoader();
                if (classloader == null) {
                    classloader = ClassLoader.getSystemClassLoader();
                }
                factory = classloader.loadClass(factoryClassName);
            }
            return factory.newInstance();
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new SOAPException("Provider " + factoryClassName + " not found", classnotfoundexception);
        }
        catch (Exception exception) {
            throw new SOAPException("Provider " + factoryClassName + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(Class factory, String defaultFactoryClassName) throws SOAPException {
        String factoryPropertyName = factory.getName();
        if ("javax.xml.soap.SAAJMetaFactory".equals(factoryPropertyName)) {
            factoryPropertyName = "javax.xml.soap.MetaFactory";
        }
        return FactoryFinder.find(factoryPropertyName, factory, defaultFactoryClassName);
    }

    static Object find(String factoryPropertyName, String defaultFactoryClassName) throws SOAPException {
        return FactoryFinder.find(factoryPropertyName, null, defaultFactoryClassName);
    }

    static Object find(String factoryPropertyName, Class factoryClass, String defaultFactoryClassName) throws SOAPException {
        String factoryClassName;
        try {
            Class spiClass;
            if (factoryClass == null) {
                ClassLoader cl;
                factoryClassName = factoryPropertyName;
                if (factoryPropertyName.equals("javax.xml.soap.MetaFactory")) {
                    factoryClassName = "javax.xml.soap.SAAJMetaFactory";
                }
                if ((cl = FactoryFinder.class.getClassLoader()) == null) {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                factoryClass = cl.loadClass(factoryClassName);
            }
            if ((spiClass = OsgiLocator.locate((Class)factoryClass, (String)factoryPropertyName)) != null) {
                return spiClass.newInstance();
            }
        }
        catch (Throwable spiClass) {
            // empty catch block
        }
        try {
            factoryClassName = System.getProperty(factoryPropertyName);
            if (factoryClassName != null) {
                return FactoryFinder.newInstance(factoryClassName);
            }
        }
        catch (SecurityException factoryClassName2) {
            // empty catch block
        }
        try {
            String propertiesFileName = System.getProperty("java.home") + File.separator + "lib" + File.separator + "jaxm.properties";
            File file = new File(propertiesFileName);
            if (file.exists()) {
                FileInputStream fileInput = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInput);
                fileInput.close();
                String factoryClassName3 = properties.getProperty(factoryPropertyName);
                return FactoryFinder.newInstance(factoryClassName3);
            }
        }
        catch (Exception propertiesFileName) {
            // empty catch block
        }
        String factoryResource = "META-INF/services/" + factoryPropertyName;
        try {
            InputStream inputstream = FactoryFinder.getResource(factoryResource);
            if (inputstream != null) {
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                String factoryClassName4 = bufferedreader.readLine();
                bufferedreader.close();
                if (factoryClassName4 != null && !"".equals(factoryClassName4)) {
                    try {
                        return FactoryFinder.newInstance(factoryClassName4);
                    }
                    catch (Exception e) {
                        throw new SOAPException("Provider for " + factoryPropertyName + " cannot be found", null);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultFactoryClassName == null) {
            throw new SOAPException("Provider for " + factoryPropertyName + " cannot be found", null);
        }
        return FactoryFinder.newInstance(defaultFactoryClassName);
    }

    private static InputStream getResource(String factoryResource) {
        ClassLoader classloader = null;
        try {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        InputStream inputstream = classloader == null ? ClassLoader.getSystemResourceAsStream(factoryResource) : classloader.getResourceAsStream(factoryResource);
        if (inputstream == null && FactoryFinder.class.getClassLoader() != null) {
            inputstream = FactoryFinder.class.getClassLoader().getResourceAsStream(factoryResource);
        }
        return inputstream;
    }
}

