/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.sax;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Deprecated(since="2022-01-27")
public class NamespacesTable {
    private Entry lastEntry;
    private Entry lastDeclaredEntry;
    private boolean usesScopes = false;
    private static final Declaration[] NO_DECLS = new Declaration[0];

    public NamespacesTable() {
        this.clear();
    }

    public void clear() {
        this.lastEntry = Entry.create("", "");
        this.addDeclaration("xml", "http://www.w3.org/XML/1998/namespace");
        this.lastEntry.closedScopes = 1;
    }

    public Declaration addDeclaration(String prefix, String uri) {
        Entry dup = this.lastEntry;
        while (dup != null && !dup.prefix.equals(prefix)) {
            dup = dup.previous;
        }
        if (dup != null) {
            if (this.usesScopes && dup.uri.equals(uri)) {
                return dup;
            }
            dup.overriden = true;
        }
        Entry e = Entry.create(prefix, uri);
        e.previous = this.lastEntry;
        e.overrides = dup;
        this.lastEntry = e;
        this.lastDeclaredEntry = e;
        return e;
    }

    public Declaration removeDeclaration(String prefix) {
        if (this.usesScopes) {
            return null;
        }
        Entry current = this.lastEntry;
        Entry afterCurrent = null;
        while (current != null) {
            if (current.closedScopes > 0) {
                return null;
            }
            if (current.prefix.equals(prefix)) {
                if (afterCurrent != null) {
                    afterCurrent.previous = current.previous;
                }
                current.previous.closedScopes += current.closedScopes;
                Entry overrides = current.overrides;
                if (overrides != null) {
                    overrides.overriden = false;
                }
                if (this.lastDeclaredEntry == current) {
                    this.lastDeclaredEntry = current.previous.closedScopes == 0 ? current.previous : null;
                }
                if (this.lastEntry == current) {
                    this.lastEntry = current.previous;
                }
                return current;
            }
            afterCurrent = current;
            current = current.previous;
        }
        return null;
    }

    public void enterScope() {
        this.usesScopes = true;
        ++this.lastEntry.closedScopes;
        this.lastDeclaredEntry = null;
    }

    public void enterScope(ContentHandler handler) throws SAXException {
        this.usesScopes = true;
        Entry current = this.lastEntry;
        while (current != null && current.closedScopes == 0) {
            handler.startPrefixMapping(current.prefix, current.uri);
            current = current.previous;
        }
        ++this.lastEntry.closedScopes;
        this.lastDeclaredEntry = null;
    }

    public void leaveScope() {
        Entry current = this.lastEntry;
        while (current.closedScopes == 0) {
            current = current.previous;
        }
        --current.closedScopes;
        this.lastDeclaredEntry = current.closedScopes == 0 ? current : null;
        while (current != null && current.closedScopes == 0) {
            Entry overrides = current.overrides;
            if (overrides != null) {
                overrides.overriden = false;
            }
            current = current.previous;
        }
        this.lastEntry = current;
    }

    public void leaveScope(ContentHandler handler) throws SAXException {
        Entry current = this.lastEntry;
        while (current.closedScopes == 0) {
            current = current.previous;
        }
        --current.closedScopes;
        this.lastDeclaredEntry = current.closedScopes == 0 ? current : null;
        while (current != null && current.closedScopes == 0) {
            handler.endPrefixMapping(current.prefix);
            Entry overrides = current.overrides;
            if (overrides != null) {
                overrides.overriden = false;
            }
            current = current.previous;
        }
        this.lastEntry = current;
    }

    public Declaration[] getCurrentScopeDeclarations() {
        int count = 0;
        Entry current = this.lastDeclaredEntry;
        while (current != null && current.closedScopes == 0) {
            ++count;
            current = current.previous;
        }
        if (count == 0) {
            return NO_DECLS;
        }
        Declaration[] decls = new Declaration[count];
        count = 0;
        current = this.lastDeclaredEntry;
        while (current != null && current.closedScopes == 0) {
            decls[count++] = current;
            current = current.previous;
        }
        return decls;
    }

    public String getUri(String prefix) {
        Entry current = this.lastEntry;
        while (current != null) {
            if (current.prefix.equals(prefix)) {
                return current.uri;
            }
            current = current.previous;
        }
        return null;
    }

    public String[] getPrefixes(String uri) {
        Entry current = this.lastEntry;
        int count = 0;
        while (current != null) {
            if (!current.overriden && current.uri.equals(uri)) {
                ++count;
            }
            current = current.previous;
        }
        if (count == 0) {
            return new String[0];
        }
        String[] prefixes = new String[count];
        count = 0;
        current = this.lastEntry;
        while (current != null) {
            if (!current.overriden && current.uri.equals(uri)) {
                prefixes[count++] = current.prefix;
            }
            current = current.previous;
        }
        return prefixes;
    }

    public String getPrefix(String uri) {
        Entry current = this.lastEntry;
        while (current != null) {
            if (!current.overriden && current.uri.equals(uri)) {
                return current.prefix;
            }
            current = current.previous;
        }
        return null;
    }

    public Name resolve(String uri, String raw, String prefix, String local) throws SAXException {
        String temp;
        if (uri == null) {
            uri = "";
        }
        if (raw == null) {
            raw = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (local == null) {
            local = "";
        }
        if (raw.length() > 0) {
            int pos = raw.indexOf(58);
            if (pos > 0) {
                String pre = raw.substring(0, pos);
                String loc = raw.substring(pos + 1);
                if (prefix.length() == 0) {
                    prefix = pre;
                } else if (!prefix.equals(pre)) {
                    throw new SAXException("Raw/Prefix mismatch");
                }
                if (local.length() == 0) {
                    local = loc;
                } else if (!local.equals(loc)) {
                    throw new SAXException("Raw/Local Name mismatch");
                }
            } else {
                if (prefix.length() > 0) {
                    throw new SAXException("Raw Name/Prefix mismatch");
                }
                if (local.length() == 0) {
                    local = raw;
                } else if (!local.equals(raw)) {
                    throw new SAXException("Raw Name/Local Name mismatch");
                }
            }
        } else {
            if (local.length() == 0) {
                throw new SAXException("No Raw/Local Name");
            }
            raw = prefix.length() == 0 ? local : prefix + ':' + local;
        }
        if (uri.length() > 0) {
            if (prefix.length() > 0 && !uri.equals(this.getUri(prefix))) {
                throw new SAXException("URI/Prefix mismatch [" + prefix + "," + uri + "]");
            }
            temp = this.getPrefix(uri);
            if (temp == null) {
                throw new SAXException("URI not declared");
            }
            if (temp.length() > 0) {
                prefix = temp;
                raw = prefix + ':' + local;
            }
        } else {
            temp = this.getUri(prefix);
            if (temp == null) {
                throw new SAXException("Prefix not declared");
            }
            uri = temp;
        }
        NameImpl name = new NameImpl();
        name.uri = uri.length() > 0 ? uri : null;
        name.raw = raw;
        name.prefix = prefix;
        name.local = local;
        return name;
    }

    @Deprecated(since="2022-01-27")
    public static interface Declaration {
        public String getUri();

        public String getPrefix();
    }

    @Deprecated(since="2022-01-27")
    public static interface Name {
        public String getUri();

        public String getPrefix();

        public String getLocalName();

        public String getQName();
    }

    @Deprecated(since="2022-01-27")
    private static class NameImpl
    implements Name {
        protected String uri;
        protected String prefix;
        protected String local;
        protected String raw;

        private NameImpl() {
        }

        public String getUri() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getLocalName() {
            return this.local;
        }

        public String getQName() {
            return this.raw;
        }
    }

    @Deprecated(since="2022-01-27")
    private static class Entry
    implements Declaration {
        protected String uri = "";
        protected String prefix = "";
        protected Entry previous;
        protected Entry overrides;
        protected int closedScopes = 0;
        protected boolean overriden = false;

        private Entry() {
        }

        protected static Entry create(String prefix, String uri) {
            Entry e = new Entry();
            if (prefix != null) {
                e.prefix = prefix;
            }
            if (uri != null) {
                e.uri = uri;
            }
            return e;
        }

        public String getUri() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

