/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.ArrayListMultimap;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Multimap;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossMountReferenceValidator
extends DefaultValidator {
    private final Logger LOG = LoggerFactory.getLogger(CrossMountReferenceValidator.class);
    private final CrossMountReferenceValidator parent;
    private final String name;
    private String path;
    private final Map<String, String> newReferencableNodes;
    private final Multimap<String, String> newReferences;
    private final MountInfoProvider mip;
    private final NodeState uuidDefinition;
    private final Set<IndexStoreStrategy> uuidStores;
    private final boolean failOnDetection;

    private CrossMountReferenceValidator(CrossMountReferenceValidator parent, String name) {
        this.name = name;
        this.parent = parent;
        this.path = null;
        this.mip = parent.mip;
        this.newReferencableNodes = parent.newReferencableNodes;
        this.newReferences = parent.newReferences;
        this.uuidDefinition = parent.uuidDefinition;
        this.uuidStores = parent.uuidStores;
        this.failOnDetection = parent.failOnDetection;
    }

    public CrossMountReferenceValidator(NodeState root, MountInfoProvider mip, boolean failOnDetection) {
        this.name = null;
        this.parent = null;
        this.path = "/";
        this.mip = mip;
        this.newReferencableNodes = Maps.newHashMap();
        this.newReferences = ArrayListMultimap.create();
        this.uuidDefinition = root.getChildNode("oak:index").getChildNode("uuid");
        this.uuidStores = Multiplexers.getStrategies(true, mip, this.uuidDefinition, ":index");
        this.failOnDetection = failOnDetection;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.parent != null) {
            return;
        }
        for (Map.Entry e : this.newReferences.asMap().entrySet()) {
            String uuid = (String)e.getKey();
            String passivePath = this.getPathByUuid(uuid);
            if (passivePath == null) {
                this.LOG.warn("Can't find path for the UUID {}", (Object)uuid);
            }
            Mount m1 = this.mip.getMountByPath(passivePath);
            for (String activePath : (Collection)e.getValue()) {
                Mount m2 = this.mip.getMountByPath(activePath);
                if (m1.equals(m2)) continue;
                if (this.failOnDetection) {
                    throw new CommitFailedException("Integrity", 1, "Unable to reference the node [" + passivePath + "] from node [" + activePath + "]. Referencing across the mounts is not allowed.");
                }
                this.LOG.warn("Detected a cross-mount reference: {} -> {}", (Object)activePath, (Object)passivePath);
            }
        }
    }

    private String getPathByUuid(String uuid) {
        if (this.newReferencableNodes.containsKey(uuid)) {
            return this.newReferencableNodes.get(uuid);
        }
        for (IndexStoreStrategy store : this.uuidStores) {
            Iterator<String> iterator = store.query(Filter.EMPTY_FILTER, null, this.uuidDefinition, (Iterable<String>)ImmutableSet.of((Object)uuid)).iterator();
            if (!iterator.hasNext()) continue;
            String path = iterator.next();
            return path;
        }
        return null;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.checkProperty(after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.checkProperty(after);
    }

    private void checkProperty(PropertyState property) {
        Type<?> type = property.getType();
        if (type == Type.REFERENCE) {
            this.newReferences.put((Object)property.getValue(Type.REFERENCE), (Object)this.getPath());
        } else if (type == Type.WEAKREFERENCE) {
            this.newReferences.put((Object)property.getValue(Type.WEAKREFERENCE), (Object)this.getPath());
        } else if (type == Type.REFERENCES) {
            for (String r : property.getValue(Type.REFERENCES)) {
                this.newReferences.put((Object)r, (Object)this.getPath());
            }
        } else if (type == Type.WEAKREFERENCES) {
            for (String r : property.getValue(Type.WEAKREFERENCES)) {
                this.newReferences.put((Object)r, (Object)this.getPath());
            }
        } else if (type == Type.STRING && "jcr:uuid".equals(property.getName())) {
            this.newReferencableNodes.put(property.getValue(Type.STRING), this.getPath());
        }
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return new CrossMountReferenceValidator(this, name);
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return new CrossMountReferenceValidator(this, name);
    }

    private String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }
}

