/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.plugins.blob.ExtendedBlobStatsCollector;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStoreStatsMBean;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.stats.TimeSeriesAverage;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreStats
extends AnnotatedStandardMBean
implements BlobStoreStatsMBean,
ExtendedBlobStatsCollector {
    private final Logger opsLogger = LoggerFactory.getLogger("org.apache.jackrabbit.oak.operations.blobs");
    private static final String BLOB_UPLOADS = "BLOB_UPLOADS";
    private static final String BLOB_UPLOAD_COUNT = "BLOB_UPLOAD_COUNT";
    private static final String BLOB_UPLOAD_SIZE = "BLOB_UPLOAD_SIZE";
    private static final String BLOB_UPLOAD_TIME = "BLOB_UPLOAD_TIME";
    private static final String BLOB_UPLOAD_ERROR_COUNT = "BLOB_UPLOAD_ERROR_COUNT";
    private static final String BLOB_DOWNLOADS = "BLOB_DOWNLOADS";
    private static final String BLOB_DOWNLOAD_COUNT = "BLOB_DOWNLOAD_COUNT";
    private static final String BLOB_DOWNLOAD_SIZE = "BLOB_DOWNLOAD_SIZE";
    private static final String BLOB_DOWNLOAD_TIME = "BLOB_DOWNLOAD_TIME";
    private static final String BLOB_DOWNLOAD_ERROR_COUNT = "BLOB_DOWNLOAD_ERROR_COUNT";
    private static final String BLOB_DELETE_COUNT = "BLOB_DELETE_COUNT";
    private static final String BLOB_DELETE_TIME = "BLOB_DELETE_TIME";
    private static final String BLOB_DELETE_ERROR_COUNT = "BLOB_DELETE_ERROR_COUNT";
    private static final String BLOB_DELETE_BY_DATE_COUNT = "BLOB_DELETE_BY_DATE_COUNT";
    private static final String BLOB_DELETE_BY_DATE_TIME = "BLOB_DELETE_BY_DATE_TIME";
    private static final String BLOB_DELETE_BY_DATE_ERROR_COUNT = "BLOB_DELETE_BY_DATE_ERROR_COUNT";
    private static final String BLOB_ADD_RECORD_COUNT = "BLOB_ADD_RECORD_COUNT";
    private static final String BLOB_ADD_RECORD_SIZE = "BLOB_ADD_RECORD_SIZE";
    private static final String BLOB_ADD_RECORD_TIME = "BLOB_ADD_RECORD_TIME";
    private static final String BLOB_ADD_RECORD_ERROR_COUNT = "BLOB_ADD_RECORD_ERROR_COUNT";
    private static final String BLOB_GETREC_COUNT = "BLOB_GETREC_COUNT";
    private static final String BLOB_GETREC_TIME = "BLOB_GETREC_TIME";
    private static final String BLOB_GETREC_SIZE = "BLOB_GETREC_SIZE";
    private static final String BLOB_GETREC_ERROR_COUNT = "BLOB_GETREC_ERROR_COUNT";
    private static final String BLOB_GETRECIFSTORED_COUNT = "BLOB_GETRECIFSTORED_COUNT";
    private static final String BLOB_GETRECIFSTORED_TIME = "BLOB_GETRECIFSTORED_TIME";
    private static final String BLOB_GETRECIFSTORED_SIZE = "BLOB_GETRECIFSTORED_SIZE";
    private static final String BLOB_GETRECIFSTORED_ERROR_COUNT = "BLOB_GETRECIFSTORED_ERROR_COUNT";
    private static final String BLOB_GETRECFROMREF_COUNT = "BLOB_GETRECFROMREF_COUNT";
    private static final String BLOB_GETRECFROMREF_TIME = "BLOB_GETRECFROMREF_TIME";
    private static final String BLOB_GETRECFROMREF_SIZE = "BLOB_GETRECFROMREF_SIZE";
    private static final String BLOB_GETRECFROMREF_ERROR_COUNT = "BLOB_GETRECFROMREF_ERROR_COUNT";
    private static final String BLOB_GETRECFORID_COUNT = "BLOB_GETRECFORID_COUNT";
    private static final String BLOB_GETRECFORID_TIME = "BLOB_GETRECFORID_TIME";
    private static final String BLOB_GETRECFORID_SIZE = "BLOB_GETRECFORID_SIZE";
    private static final String BLOB_GETRECFORID_ERROR_COUNT = "BLOB_GETRECFORID_ERROR_COUNT";
    private static final String BLOB_GETALLRECORDS_COUNT = "BLOB_GETALLRECORDS_COUNT";
    private static final String BLOB_GETALLRECORDS_TIME = "BLOB_GETALLRECORDS_TIME";
    private static final String BLOB_LISTIDS_COUNT = "BLOB_LISTIDS_COUNT";
    private static final String BLOB_LISTIDS_TIME = "BLOB_LISTIDS_TIME";
    private static final String BLOB_LISTIDS_ERROR_COUNT = "BLOB_LISTIDS_ERROR_COUNT";
    private static final String BLOB_ADD_METADATA_RECORD_COUNT = "BLOB_ADD_METADATA_RECORD_COUNT";
    private static final String BLOB_ADD_METADATA_RECORD_TIME = "BLOB_ADD_METADATA_RECORD_TIME";
    private static final String BLOB_ADD_METADATA_RECORD_ERROR_COUNT = "BLOB_ADD_METADATA_RECORD_ERROR_COUNT";
    private static final String BLOB_GET_METADATA_RECORD_COUNT = "BLOB_GET_METADATA_RECORD_COUNT";
    private static final String BLOB_GET_METADATA_RECORD_TIME = "BLOB_GET_METADATA_RECORD_TIME";
    private static final String BLOB_GET_METADATA_RECORD_ERROR_COUNT = "BLOB_GET_METADATA_RECORD_ERROR_COUNT";
    private static final String BLOB_GET_ALL_METADATA_RECORDS_COUNT = "BLOB_GET_ALL_METADATA_RECORDS_COUNT";
    private static final String BLOB_GET_ALL_METADATA_RECORDS_TIME = "BLOB_GET_ALL_METADATA_RECORDS_TIME";
    private static final String BLOB_GET_ALL_METADATA_RECORDS_ERROR_COUNT = "BLOB_GET_ALL_METADATA_RECORDS_ERROR_COUNT";
    private static final String BLOB_METADATA_RECORD_EXISTS_COUNT = "BLOB_METADATA_RECORD_EXISTS_COUNT";
    private static final String BLOB_METADATA_RECORD_EXISTS_TIME = "BLOB_METADATA_RECORD_EXISTS_TIME";
    private static final String BLOB_METADATA_RECORD_EXISTS_ERROR_COUNT = "BLOB_METADATA_RECORD_EXISTS_ERROR_COUNT";
    private static final String BLOB_DELETE_METADATA_RECORD_COUNT = "BLOB_DELETE_METADATA_RECORD_COUNT";
    private static final String BLOB_DELETE_METADATA_RECORD_TIME = "BLOB_DELETE_METADATA_RECORD_TIME";
    private static final String BLOB_DELETE_METADATA_RECORD_ERROR_COUNT = "BLOB_DELETE_METADATA_RECORD_ERROR_COUNT";
    private static final String BLOB_DELETE_ALL_METADATA_RECORDS_COUNT = "BLOB_DELETE_ALL_METADATA_RECORDS_COUNT";
    private static final String BLOB_DELETE_ALL_METADATA_RECORDS_TIME = "BLOB_DELETE_ALL_METADATA_RECORDS_TIME";
    private static final String BLOB_DELETE_ALL_METADATA_RECORDS_ERROR_COUNT = "BLOB_DELETE_ALL_METADATA_RECORDS_ERROR_COUNT";
    private static final String BLOB_INIT_DIRECT_UPLOAD_COUNT = "BLOB_INIT_DIRECT_UPLOAD_COUNT";
    private static final String BLOB_INIT_DIRECT_UPLOAD_TIME = "BLOB_INIT_DIRECT_UPLOAD_TIME";
    private static final String BLOB_INIT_DIRECT_UPLOAD_ERROR_COUNT = "BLOB_INIT_DIRECT_UPLOAD_ERROR_COUNT";
    private static final String BLOB_COMPLETE_DIRECT_UPLOAD_COUNT = "BLOB_COMPLETE_DIRECT_UPLOAD_COUNT";
    private static final String BLOB_COMPLETE_DIRECT_UPLOAD_TIME = "BLOB_COMPLETE_DIRECT_UPLOAD_TIME";
    private static final String BLOB_COMPLETE_DIRECT_UPLOAD_ERROR_COUNT = "BLOB_COMPLETE_DIRECT_UPLOAD_ERROR_COUNT";
    private static final String BLOB_GET_DIRECT_DOWNLOAD_URI_COUNT = "BLOB_GET_DIRECT_DOWNLOAD_URI_COUNT";
    private static final String BLOB_GET_DIRECT_DOWNLOAD_URI_TIME = "BLOB_GET_DIRECT_DOWNLOAD_URI_TIME";
    private static final String BLOB_GET_DIRECT_DOWNLOAD_URI_ERROR_COUNT = "BLOB_GET_DIRECT_DOWNLOAD_URI_ERROR_COUNT";
    private final StatisticsProvider statisticsProvider;
    private final HistogramStats uploadHisto;
    private final MeterStats uploadCount;
    private final MeterStats uploadErrorCount;
    private final MeterStats uploadSizeSeries;
    private final MeterStats uploadTimeSeries;
    private final TimeSeries uploadRateSeries;
    private final HistogramStats downloadHisto;
    private final MeterStats downloadCount;
    private final MeterStats downloadSizeSeries;
    private final MeterStats downloadTimeSeries;
    private final TimeSeries downloadRateSeries;
    private final MeterStats downloadErrorCount;
    private final MeterStats deleteCount;
    private final MeterStats deleteTimeSeries;
    private final MeterStats deleteErrorCount;
    private final MeterStats deleteByDateCount;
    private final MeterStats deleteByDateTimeSeries;
    private final MeterStats deleteByDateErrorCount;
    private final MeterStats addRecordCount;
    private final MeterStats addRecordSizeSeries;
    private final MeterStats addRecordTimeSeries;
    private final TimeSeries addRecordRateSeries;
    private final MeterStats addRecordErrorCount;
    private final MeterStats getRecordCount;
    private final MeterStats getRecordTimeSeries;
    private final MeterStats getRecordSizeSeries;
    private final TimeSeries getRecordRateSeries;
    private final MeterStats getRecordErrorCount;
    private final MeterStats getRecordIfStoredCount;
    private final MeterStats getRecordIfStoredTimeSeries;
    private final MeterStats getRecordIfStoredSizeSeries;
    private final TimeSeries getRecordIfStoredRateSeries;
    private final MeterStats getRecordIfStoredErrorCount;
    private final MeterStats getRecordFromRefCount;
    private final MeterStats getRecordFromRefTimeSeries;
    private final MeterStats getRecordFromRefSizeSeries;
    private final TimeSeries getRecordFromRefRateSeries;
    private final MeterStats getRecordFromRefErrorCount;
    private final MeterStats getRecordForIdCount;
    private final MeterStats getRecordForIdTimeSeries;
    private final MeterStats getRecordForIdSizeSeries;
    private final TimeSeries getRecordForIdRateSeries;
    private final MeterStats getRecordForIdErrorCount;
    private final MeterStats getAllRecordsCount;
    private final MeterStats getAllRecordsTimeSeries;
    private final MeterStats listIdsCount;
    private final MeterStats listIdsTimeSeries;
    private final MeterStats listIdsErrorCount;
    private final MeterStats addMetadataRecordCount;
    private final MeterStats addMetadataRecordTimeSeries;
    private final MeterStats addMetadataRecordErrorCount;
    private final MeterStats getMetadataRecordCount;
    private final MeterStats getMetadataRecordTimeSeries;
    private final MeterStats getMetadataRecordErrorCount;
    private final MeterStats getAllMetadataRecordsCount;
    private final MeterStats getAllMetadataRecordsTimeSeries;
    private final MeterStats getAllMetadataRecordsErrorCount;
    private final MeterStats metadataRecordExistsCount;
    private final MeterStats metadataRecordExistsTimeSeries;
    private final MeterStats metadataRecordExistsErrorCount;
    private final MeterStats deleteMetadataRecordCount;
    private final MeterStats deleteMetadataRecordTimeSeries;
    private final MeterStats deleteMetadataRecordErrorCount;
    private final MeterStats deleteAllMetadataRecordsCount;
    private final MeterStats deleteAllMetadataRecordsTimeSeries;
    private final MeterStats deleteAllMetadataRecordsErrorCount;
    private final MeterStats initBlobUploadCount;
    private final MeterStats initBlobUploadTimeSeries;
    private final MeterStats initBlobUploadErrorCount;
    private final MeterStats completeBlobUploadCount;
    private final MeterStats completeBlobUploadTimeSeries;
    private final MeterStats completeBlobUploadErrorCount;
    private final MeterStats getBlobDownloadURICount;
    private final MeterStats getBlobDownloadURITimeSeries;
    private final MeterStats getBlobDownloadURIErrorCount;
    private final TimeUnit recordedTimeUnit = TimeUnit.NANOSECONDS;

    public BlobStoreStats(@NotNull StatisticsProvider sp) {
        super(BlobStoreStatsMBean.class);
        this.statisticsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)sp);
        this.uploadHisto = sp.getHistogram(BLOB_UPLOADS, StatsOptions.DEFAULT);
        this.uploadCount = sp.getMeter(BLOB_UPLOAD_COUNT, StatsOptions.DEFAULT);
        this.uploadErrorCount = sp.getMeter(BLOB_UPLOAD_ERROR_COUNT, StatsOptions.DEFAULT);
        this.uploadSizeSeries = sp.getMeter(BLOB_UPLOAD_SIZE, StatsOptions.DEFAULT);
        this.uploadTimeSeries = sp.getMeter(BLOB_UPLOAD_TIME, StatsOptions.DEFAULT);
        this.uploadRateSeries = this.getAvgTimeSeries(BLOB_UPLOAD_SIZE, BLOB_UPLOAD_TIME);
        this.downloadHisto = sp.getHistogram(BLOB_DOWNLOADS, StatsOptions.DEFAULT);
        this.downloadCount = sp.getMeter(BLOB_DOWNLOAD_COUNT, StatsOptions.DEFAULT);
        this.downloadSizeSeries = sp.getMeter(BLOB_DOWNLOAD_SIZE, StatsOptions.DEFAULT);
        this.downloadTimeSeries = sp.getMeter(BLOB_DOWNLOAD_TIME, StatsOptions.DEFAULT);
        this.downloadRateSeries = this.getAvgTimeSeries(BLOB_DOWNLOAD_SIZE, BLOB_DOWNLOAD_TIME);
        this.downloadErrorCount = sp.getMeter(BLOB_DOWNLOAD_ERROR_COUNT, StatsOptions.DEFAULT);
        this.deleteCount = sp.getMeter(BLOB_DELETE_COUNT, StatsOptions.DEFAULT);
        this.deleteTimeSeries = sp.getMeter(BLOB_DELETE_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.deleteErrorCount = sp.getMeter(BLOB_DELETE_ERROR_COUNT, StatsOptions.DEFAULT);
        this.deleteByDateCount = sp.getMeter(BLOB_DELETE_BY_DATE_COUNT, StatsOptions.DEFAULT);
        this.deleteByDateTimeSeries = sp.getMeter(BLOB_DELETE_BY_DATE_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.deleteByDateErrorCount = sp.getMeter(BLOB_DELETE_BY_DATE_ERROR_COUNT, StatsOptions.DEFAULT);
        this.addRecordCount = sp.getMeter(BLOB_ADD_RECORD_COUNT, StatsOptions.DEFAULT);
        this.addRecordSizeSeries = sp.getMeter(BLOB_ADD_RECORD_SIZE, StatsOptions.TIME_SERIES_ONLY);
        this.addRecordTimeSeries = sp.getMeter(BLOB_ADD_RECORD_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.addRecordRateSeries = this.getAvgTimeSeries(BLOB_ADD_RECORD_SIZE, BLOB_ADD_RECORD_TIME);
        this.addRecordErrorCount = sp.getMeter(BLOB_ADD_RECORD_ERROR_COUNT, StatsOptions.DEFAULT);
        this.getRecordCount = sp.getMeter(BLOB_GETREC_COUNT, StatsOptions.DEFAULT);
        this.getRecordTimeSeries = sp.getMeter(BLOB_GETREC_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.getRecordSizeSeries = sp.getMeter(BLOB_GETREC_SIZE, StatsOptions.TIME_SERIES_ONLY);
        this.getRecordRateSeries = this.getAvgTimeSeries(BLOB_GETREC_SIZE, BLOB_GETREC_TIME);
        this.getRecordErrorCount = sp.getMeter(BLOB_GETREC_ERROR_COUNT, StatsOptions.DEFAULT);
        this.getRecordIfStoredCount = sp.getMeter(BLOB_GETRECIFSTORED_COUNT, StatsOptions.DEFAULT);
        this.getRecordIfStoredTimeSeries = sp.getMeter(BLOB_GETRECIFSTORED_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.getRecordIfStoredSizeSeries = sp.getMeter(BLOB_GETRECIFSTORED_SIZE, StatsOptions.TIME_SERIES_ONLY);
        this.getRecordIfStoredRateSeries = this.getAvgTimeSeries(BLOB_GETRECIFSTORED_SIZE, BLOB_GETRECIFSTORED_TIME);
        this.getRecordIfStoredErrorCount = sp.getMeter(BLOB_GETRECIFSTORED_ERROR_COUNT, StatsOptions.DEFAULT);
        this.getRecordFromRefCount = sp.getMeter(BLOB_GETRECFROMREF_COUNT, StatsOptions.DEFAULT);
        this.getRecordFromRefTimeSeries = sp.getMeter(BLOB_GETRECFROMREF_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.getRecordFromRefSizeSeries = sp.getMeter(BLOB_GETRECFROMREF_SIZE, StatsOptions.TIME_SERIES_ONLY);
        this.getRecordFromRefRateSeries = this.getAvgTimeSeries(BLOB_GETRECFROMREF_SIZE, BLOB_GETRECFROMREF_TIME);
        this.getRecordFromRefErrorCount = sp.getMeter(BLOB_GETRECFROMREF_ERROR_COUNT, StatsOptions.DEFAULT);
        this.getRecordForIdCount = sp.getMeter(BLOB_GETRECFORID_COUNT, StatsOptions.DEFAULT);
        this.getRecordForIdTimeSeries = sp.getMeter(BLOB_GETRECFORID_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.getRecordForIdSizeSeries = sp.getMeter(BLOB_GETRECFORID_SIZE, StatsOptions.TIME_SERIES_ONLY);
        this.getRecordForIdRateSeries = this.getAvgTimeSeries(BLOB_GETRECFORID_SIZE, BLOB_GETRECFORID_TIME);
        this.getRecordForIdErrorCount = sp.getMeter(BLOB_GETRECFORID_ERROR_COUNT, StatsOptions.DEFAULT);
        this.getAllRecordsCount = sp.getMeter(BLOB_GETALLRECORDS_COUNT, StatsOptions.DEFAULT);
        this.getAllRecordsTimeSeries = sp.getMeter(BLOB_GETALLRECORDS_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.listIdsCount = sp.getMeter(BLOB_LISTIDS_COUNT, StatsOptions.DEFAULT);
        this.listIdsTimeSeries = sp.getMeter(BLOB_LISTIDS_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.listIdsErrorCount = sp.getMeter(BLOB_LISTIDS_ERROR_COUNT, StatsOptions.DEFAULT);
        this.addMetadataRecordCount = sp.getMeter(BLOB_ADD_METADATA_RECORD_COUNT, StatsOptions.DEFAULT);
        this.addMetadataRecordTimeSeries = sp.getMeter(BLOB_ADD_METADATA_RECORD_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.addMetadataRecordErrorCount = sp.getMeter(BLOB_ADD_METADATA_RECORD_ERROR_COUNT, StatsOptions.DEFAULT);
        this.getMetadataRecordCount = sp.getMeter(BLOB_GET_METADATA_RECORD_COUNT, StatsOptions.DEFAULT);
        this.getMetadataRecordTimeSeries = sp.getMeter(BLOB_GET_METADATA_RECORD_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.getMetadataRecordErrorCount = sp.getMeter(BLOB_GET_METADATA_RECORD_ERROR_COUNT, StatsOptions.DEFAULT);
        this.getAllMetadataRecordsCount = sp.getMeter(BLOB_GET_ALL_METADATA_RECORDS_COUNT, StatsOptions.DEFAULT);
        this.getAllMetadataRecordsTimeSeries = sp.getMeter(BLOB_GET_ALL_METADATA_RECORDS_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.getAllMetadataRecordsErrorCount = sp.getMeter(BLOB_GET_ALL_METADATA_RECORDS_ERROR_COUNT, StatsOptions.DEFAULT);
        this.metadataRecordExistsCount = sp.getMeter(BLOB_METADATA_RECORD_EXISTS_COUNT, StatsOptions.DEFAULT);
        this.metadataRecordExistsTimeSeries = sp.getMeter(BLOB_METADATA_RECORD_EXISTS_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.metadataRecordExistsErrorCount = sp.getMeter(BLOB_METADATA_RECORD_EXISTS_ERROR_COUNT, StatsOptions.DEFAULT);
        this.deleteMetadataRecordCount = sp.getMeter(BLOB_DELETE_METADATA_RECORD_COUNT, StatsOptions.DEFAULT);
        this.deleteMetadataRecordTimeSeries = sp.getMeter(BLOB_DELETE_METADATA_RECORD_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.deleteMetadataRecordErrorCount = sp.getMeter(BLOB_DELETE_METADATA_RECORD_ERROR_COUNT, StatsOptions.DEFAULT);
        this.deleteAllMetadataRecordsCount = sp.getMeter(BLOB_DELETE_ALL_METADATA_RECORDS_COUNT, StatsOptions.DEFAULT);
        this.deleteAllMetadataRecordsTimeSeries = sp.getMeter(BLOB_DELETE_ALL_METADATA_RECORDS_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.deleteAllMetadataRecordsErrorCount = sp.getMeter(BLOB_DELETE_ALL_METADATA_RECORDS_ERROR_COUNT, StatsOptions.DEFAULT);
        this.initBlobUploadCount = sp.getMeter(BLOB_INIT_DIRECT_UPLOAD_COUNT, StatsOptions.DEFAULT);
        this.initBlobUploadTimeSeries = sp.getMeter(BLOB_INIT_DIRECT_UPLOAD_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.initBlobUploadErrorCount = sp.getMeter(BLOB_INIT_DIRECT_UPLOAD_ERROR_COUNT, StatsOptions.DEFAULT);
        this.completeBlobUploadCount = sp.getMeter(BLOB_COMPLETE_DIRECT_UPLOAD_COUNT, StatsOptions.DEFAULT);
        this.completeBlobUploadTimeSeries = sp.getMeter(BLOB_COMPLETE_DIRECT_UPLOAD_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.completeBlobUploadErrorCount = sp.getMeter(BLOB_COMPLETE_DIRECT_UPLOAD_ERROR_COUNT, StatsOptions.DEFAULT);
        this.getBlobDownloadURICount = sp.getMeter(BLOB_GET_DIRECT_DOWNLOAD_URI_COUNT, StatsOptions.DEFAULT);
        this.getBlobDownloadURITimeSeries = sp.getMeter(BLOB_GET_DIRECT_DOWNLOAD_URI_TIME, StatsOptions.TIME_SERIES_ONLY);
        this.getBlobDownloadURIErrorCount = sp.getMeter(BLOB_GET_DIRECT_DOWNLOAD_URI_ERROR_COUNT, StatsOptions.DEFAULT);
    }

    @Override
    public void uploaded(long timeTaken, TimeUnit unit, long size) {
        this.uploadHisto.update(size);
        this.uploadSizeSeries.mark(size);
        this.uploadTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Uploaded {} bytes in {} ms", (Object)size, (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void uploadCompleted(String blobId) {
        this.uploadCount.mark();
        this.opsLogger.debug("Upload completed - {}", (Object)blobId);
    }

    @Override
    public void uploadFailed() {
        this.uploadErrorCount.mark();
        this.opsLogger.debug("Upload failed");
    }

    @Override
    public void downloaded(String blobId, long timeTaken, TimeUnit unit, long size) {
        this.downloadHisto.update(size);
        this.downloadSizeSeries.mark(size);
        this.downloadTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Downloaded {} - {} bytes in {} ms", blobId, size, unit.toMillis(timeTaken));
    }

    @Override
    public void downloadCompleted(String blobId) {
        this.downloadCount.mark();
        this.opsLogger.debug("Download completed - {}", (Object)blobId);
    }

    @Override
    public void downloadFailed(String blobId) {
        this.downloadErrorCount.mark();
        this.opsLogger.debug("Download failed - {}", (Object)blobId);
    }

    @Override
    public void deleted(String blobId, long timeTaken, TimeUnit unit) {
        this.deleteTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Deleted {} in {} ms", (Object)blobId, (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void deleteCompleted(String blobId) {
        this.deleteCount.mark();
        this.opsLogger.debug("Delete completed - {}", (Object)blobId);
    }

    @Override
    public void deleteFailed() {
        this.deleteErrorCount.mark();
        this.opsLogger.debug("Delete failed");
    }

    @Override
    public void deletedAllOlderThan(long timeTaken, TimeUnit unit, long min) {
        this.deleteByDateTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Deleted all records older than {} in {}", (Object)min, (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void deleteAllOlderThanCompleted(int deleteCount) {
        this.deleteByDateCount.mark();
        this.opsLogger.debug("Delete all older than completed - {} records deleted", (Object)deleteCount);
    }

    @Override
    public void deleteAllOlderThanFailed(long min) {
        this.deleteByDateErrorCount.mark();
        this.opsLogger.debug("Delete all older than failed for time {}", (Object)min);
    }

    @Override
    public void recordAdded(long timeTaken, TimeUnit unit, long size) {
        this.addRecordSizeSeries.mark(size);
        this.addRecordTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Record added - {} bytes in {} ms", (Object)size, (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void addRecordCompleted(String blobId) {
        this.addRecordCount.mark();
        this.opsLogger.debug("Add record completed - {}", (Object)blobId);
    }

    @Override
    public void addRecordFailed() {
        this.addRecordErrorCount.mark();
        this.opsLogger.debug("Add record failed");
    }

    @Override
    public void getRecordCalled(long timeTaken, TimeUnit unit, long size) {
        this.getRecordSizeSeries.mark(size);
        this.getRecordTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get record called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getRecordCompleted(String blobId) {
        this.getRecordCount.mark();
        this.opsLogger.debug("Get record completed - {}", (Object)blobId);
    }

    @Override
    public void getRecordFailed(String blobId) {
        this.getRecordErrorCount.mark();
        this.opsLogger.debug("Get record failed - {}", (Object)blobId);
    }

    @Override
    public void getRecordIfStoredCalled(long timeTaken, TimeUnit unit, long size) {
        this.getRecordIfStoredSizeSeries.mark(size);
        this.getRecordIfStoredTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get record if stored called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getRecordIfStoredCompleted(String blobId) {
        this.getRecordIfStoredCount.mark();
        this.opsLogger.debug("Get record if stored completed - {}", (Object)blobId);
    }

    @Override
    public void getRecordIfStoredFailed(String blobId) {
        this.getRecordIfStoredErrorCount.mark();
        this.opsLogger.debug("Get record if stored failed - {}", (Object)blobId);
    }

    @Override
    public void getRecordFromReferenceCalled(long timeTaken, TimeUnit unit, long size) {
        this.getRecordFromRefSizeSeries.mark(size);
        this.getRecordFromRefTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get record from reference called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getRecordFromReferenceCompleted(String reference) {
        this.getRecordFromRefCount.mark();
        this.opsLogger.debug("Get record from reference completed - {}", (Object)reference);
    }

    @Override
    public void getRecordFromReferenceFailed(String reference) {
        this.getRecordFromRefErrorCount.mark();
        this.opsLogger.debug("Get record from reference failed - {}", (Object)reference);
    }

    @Override
    public void getRecordForIdCalled(long timeTaken, TimeUnit unit, long size) {
        this.getRecordForIdSizeSeries.mark(size);
        this.getRecordForIdTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get record for id called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getRecordForIdCompleted(String blobId) {
        this.getRecordForIdCount.mark();
        this.opsLogger.debug("Get record for id completed - {}", (Object)blobId);
    }

    @Override
    public void getRecordForIdFailed(String blobId) {
        this.getRecordForIdErrorCount.mark();
        this.opsLogger.debug("Get record for id failed - {}", (Object)blobId);
    }

    @Override
    public void getAllRecordsCalled(long timeTaken, TimeUnit unit) {
        this.getAllRecordsTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get all records called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getAllRecordsCompleted() {
        this.getAllRecordsCount.mark();
        this.opsLogger.debug("Get all records completed");
    }

    @Override
    public void getAllIdentifiersCalled(long timeTaken, TimeUnit unit) {
        this.listIdsTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get all identifiers called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getAllIdentifiersCompleted() {
        this.listIdsCount.mark();
        this.opsLogger.debug("Get all identifiers completed");
    }

    @Override
    public void getAllIdentifiersFailed() {
        this.listIdsErrorCount.mark();
        this.opsLogger.debug("Get all identifiers failed");
    }

    @Override
    public void metadataRecordAdded(long timeTaken, TimeUnit unit) {
        this.addMetadataRecordTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Metadata record added - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void addMetadataRecordCompleted(String name) {
        this.addMetadataRecordCount.mark();
        this.opsLogger.debug("Add metadata record named {} completed", (Object)name);
    }

    @Override
    public void addMetadataRecordFailed(String name) {
        this.addMetadataRecordErrorCount.mark();
        this.opsLogger.debug("Add metadata record named {} failed", (Object)name);
    }

    @Override
    public void getMetadataRecordCalled(long timeTaken, TimeUnit unit) {
        this.getMetadataRecordTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get metadata record called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getMetadataRecordCompleted(String name) {
        this.getMetadataRecordCount.mark();
        this.opsLogger.debug("Get metadata record completed");
    }

    @Override
    public void getMetadataRecordFailed(String name) {
        this.getMetadataRecordErrorCount.mark();
        this.opsLogger.debug("Get metadata record failed");
    }

    @Override
    public void getAllMetadataRecordsCalled(long timeTaken, TimeUnit unit) {
        this.getAllMetadataRecordsTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get all metadata records called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getAllMetadataRecordsCompleted(String prefix) {
        this.getAllMetadataRecordsCount.mark();
        this.opsLogger.debug("Get all metadata records for prefix {} completed", (Object)prefix);
    }

    @Override
    public void getAllMetadataRecordsFailed(String prefix) {
        this.getAllMetadataRecordsErrorCount.mark();
        this.opsLogger.debug("Get all metadata records for prefix {} failed", (Object)prefix);
    }

    @Override
    public void metadataRecordExistsCalled(long timeTaken, TimeUnit unit) {
        this.metadataRecordExistsTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Metadata record exists check - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void metadataRecordExistsCompleted(String name) {
        this.metadataRecordExistsCount.mark();
        this.opsLogger.debug("Metadata record exists check for {} completed", (Object)name);
    }

    @Override
    public void metadataRecordExistsFailed(String name) {
        this.metadataRecordExistsErrorCount.mark();
        this.opsLogger.debug("Metadata record exists check for {} failed", (Object)name);
    }

    @Override
    public void metadataRecordDeleted(long timeTaken, TimeUnit unit) {
        this.deleteMetadataRecordTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Metadata record deleted - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void deleteMetadataRecordCompleted(String name) {
        this.deleteMetadataRecordCount.mark();
        this.opsLogger.debug("Metadata record name {} deleted", (Object)name);
    }

    @Override
    public void deleteMetadataRecordFailed(String name) {
        this.deleteMetadataRecordErrorCount.mark();
        this.opsLogger.debug("Metadata record name {} delete failed", (Object)name);
    }

    @Override
    public void allMetadataRecordsDeleted(long timeTaken, TimeUnit unit) {
        this.deleteAllMetadataRecordsTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Bulk metadata record delete - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void deleteAllMetadataRecordsCompleted(String prefix) {
        this.deleteAllMetadataRecordsCount.mark();
        this.opsLogger.debug("Bulk metadata record delete with prefix {} completed", (Object)prefix);
    }

    @Override
    public void deleteAllMetadataRecordsFailed(String prefix) {
        this.deleteAllMetadataRecordsErrorCount.mark();
        this.opsLogger.debug("Bulk metadata record delete with prefix {} failed", (Object)prefix);
    }

    @Override
    public void initiateBlobUpload(long timeTaken, TimeUnit unit, long maxSize, int maxUris) {
        this.initBlobUploadTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Initiate blob upload called with size {} and # uris {} - {} ms", maxSize, maxSize, unit.toMillis(timeTaken));
    }

    @Override
    public void initiateBlobUploadCompleted() {
        this.initBlobUploadCount.mark();
        this.opsLogger.debug("Initiate blob upload completed");
    }

    @Override
    public void initiateBlobUploadFailed() {
        this.initBlobUploadErrorCount.mark();
        this.opsLogger.debug("Initiate blob upload failed");
    }

    @Override
    public void completeBlobUpload(long timeTaken, TimeUnit unit) {
        this.completeBlobUploadTimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Complete blob upload called - {} ms", (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void completeBlobUploadCompleted(String id) {
        this.completeBlobUploadCount.mark();
        this.opsLogger.debug("Complete blob upload completed - id {}", (Object)id);
    }

    @Override
    public void completeBlobUploadFailed() {
        this.completeBlobUploadErrorCount.mark();
        this.opsLogger.debug("Complete blob upload failed");
    }

    @Override
    public void getDownloadURICalled(long timeTaken, TimeUnit unit, String id) {
        this.getBlobDownloadURITimeSeries.mark(this.recordedTimeUnit.convert(timeTaken, unit));
        this.opsLogger.debug("Get download URI called for id {} - {} ms", (Object)id, (Object)unit.toMillis(timeTaken));
    }

    @Override
    public void getDownloadURICompleted(String uri) {
        this.getBlobDownloadURICount.mark();
        this.opsLogger.debug("Get download URI completed - uri {}", (Object)uri);
    }

    @Override
    public void getDownloadURIFailed() {
        this.getBlobDownloadURIErrorCount.mark();
        this.opsLogger.debug("Get download URI failed");
    }

    @Override
    public long getUploadTotalSize() {
        return this.uploadSizeSeries.getCount();
    }

    @Override
    public long getUploadCount() {
        return this.uploadCount.getCount();
    }

    @Override
    public long getUploadTotalSeconds() {
        return this.recordedTimeUnit.toSeconds(this.uploadTimeSeries.getCount());
    }

    @Override
    public long getUploadErrorCount() {
        return this.uploadErrorCount.getCount();
    }

    @Override
    public long getDownloadTotalSize() {
        return this.downloadSizeSeries.getCount();
    }

    @Override
    public long getDownloadCount() {
        return this.downloadCount.getCount();
    }

    @Override
    public long getDownloadTotalSeconds() {
        return this.recordedTimeUnit.toSeconds(this.downloadTimeSeries.getCount());
    }

    @Override
    public long getDownloadErrorCount() {
        return this.downloadErrorCount.getCount();
    }

    @Override
    public long getAddRecordTotalSize() {
        return this.addRecordSizeSeries.getCount();
    }

    @Override
    public long getAddRecordCount() {
        return this.addRecordCount.getCount();
    }

    @Override
    public long getDeleteCount() {
        return this.deleteCount.getCount();
    }

    @Override
    public long getDeleteErrorCount() {
        return this.deleteErrorCount.getCount();
    }

    @Override
    public long getDeleteByDateCount() {
        return this.deleteByDateCount.getCount();
    }

    @Override
    public long getDeleteByDateErrorCount() {
        return this.deleteByDateErrorCount.getCount();
    }

    @Override
    public long getGetRecordCount() {
        return this.getRecordCount.getCount();
    }

    @Override
    public long getGetRecordErrorCount() {
        return this.getRecordErrorCount.getCount();
    }

    @Override
    public long getGetRecordIfStoredCount() {
        return this.getRecordIfStoredCount.getCount();
    }

    @Override
    public long getGetRecordIfStoredErrorCount() {
        return this.getRecordIfStoredErrorCount.getCount();
    }

    @Override
    public long getGetRecordFromReferenceCount() {
        return this.getRecordFromRefCount.getCount();
    }

    @Override
    public long getGetRecordFromReferenceErrorCount() {
        return this.getRecordFromRefErrorCount.getCount();
    }

    @Override
    public long getGetRecordForIdCount() {
        return this.getRecordForIdCount.getCount();
    }

    @Override
    public long getGetRecordForIdErrorCount() {
        return this.getRecordForIdErrorCount.getCount();
    }

    @Override
    public long getGetAllRecordsCount() {
        return this.getAllRecordsCount.getCount();
    }

    @Override
    public long getListIdsCount() {
        return this.listIdsCount.getCount();
    }

    @Override
    public long getListIdsErrorCount() {
        return this.listIdsErrorCount.getCount();
    }

    @Override
    public long getAddMetadataRecordCount() {
        return this.addMetadataRecordCount.getCount();
    }

    @Override
    public long getAddMetadataRecordErrorCount() {
        return this.addMetadataRecordErrorCount.getCount();
    }

    @Override
    public long getGetMetadataRecordCount() {
        return this.getMetadataRecordCount.getCount();
    }

    @Override
    public long getGetMetadataRecordErrorCount() {
        return this.getMetadataRecordErrorCount.getCount();
    }

    @Override
    public long getGetAllMetadataRecordsCount() {
        return this.getAllMetadataRecordsCount.getCount();
    }

    @Override
    public long getGetAllMetadataRecordsErrorCount() {
        return this.getAllMetadataRecordsErrorCount.getCount();
    }

    @Override
    public long getMetadataRecordExistsCount() {
        return this.metadataRecordExistsCount.getCount();
    }

    @Override
    public long getMetadataRecordExistsErrorCount() {
        return this.metadataRecordExistsErrorCount.getCount();
    }

    @Override
    public long getDeleteMetadataRecordCount() {
        return this.deleteMetadataRecordCount.getCount();
    }

    @Override
    public long getDeleteMetadataRecordErrorCount() {
        return this.deleteMetadataRecordErrorCount.getCount();
    }

    @Override
    public long getDeleteAllMetadataRecordsCount() {
        return this.deleteAllMetadataRecordsCount.getCount();
    }

    @Override
    public long getDeleteAllMetadataRecordsErrorCount() {
        return this.deleteAllMetadataRecordsErrorCount.getCount();
    }

    @Override
    public long getInitBlobUploadCount() {
        return this.initBlobUploadCount.getCount();
    }

    @Override
    public long getInitBlobUploadErrorCount() {
        return this.initBlobUploadErrorCount.getCount();
    }

    @Override
    public long getCompleteBlobUploadCount() {
        return this.completeBlobUploadCount.getCount();
    }

    @Override
    public long getCompleteBlobUploadErrorCount() {
        return this.completeBlobUploadErrorCount.getCount();
    }

    @Override
    public long getGetBlobDownloadURICount() {
        return this.getBlobDownloadURICount.getCount();
    }

    @Override
    public long getGetBlobDownloadURIErrorCount() {
        return this.getBlobDownloadURIErrorCount.getCount();
    }

    @Override
    public String blobStoreInfoAsString() {
        return String.format("Uploads - size = %s, count = %d%nDownloads - size = %s, count = %d", IOUtils.humanReadableByteCount(this.getUploadTotalSize()), this.getUploadCount(), IOUtils.humanReadableByteCount(this.getDownloadTotalSize()), this.getDownloadCount());
    }

    @Override
    public CompositeData getUploadSizeHistory() {
        return this.getTimeSeriesData(BLOB_UPLOADS, "Blob Uploads (bytes)");
    }

    @Override
    public CompositeData getUploadRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.uploadRateSeries, "Blob uploads bytes/sec");
    }

    @Override
    public CompositeData getUploadCountHistory() {
        return this.getTimeSeriesData(BLOB_UPLOAD_COUNT, "Blob Upload Counts");
    }

    @Override
    public CompositeData getUploadErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_UPLOAD_ERROR_COUNT, "Blob Upload Error Counts");
    }

    @Override
    public CompositeData getDownloadSizeHistory() {
        return this.getTimeSeriesData(BLOB_DOWNLOADS, "Blob Downloads (bytes)");
    }

    @Override
    public CompositeData getDownloadRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.downloadRateSeries, "Blob downloads bytes/secs");
    }

    @Override
    public CompositeData getDownloadCountHistory() {
        return this.getTimeSeriesData(BLOB_DOWNLOAD_COUNT, "Blob Download Counts");
    }

    @Override
    public CompositeData getDownloadErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_DOWNLOAD_ERROR_COUNT, "Blob Download Error Counts");
    }

    @Override
    public CompositeData getDeleteCountHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_COUNT, "Blob Delete Counts");
    }

    @Override
    public CompositeData getDeleteTimeHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_TIME, "Blob Delete Times");
    }

    @Override
    public CompositeData getDeleteErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_ERROR_COUNT, "Blob Delete Error Counts");
    }

    @Override
    public CompositeData getDeleteByDateCountHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_BY_DATE_COUNT, "Blob Delete By Date Counts");
    }

    @Override
    public CompositeData getDeleteByDateTimeHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_BY_DATE_TIME, "Blob Delete By Date Times");
    }

    @Override
    public CompositeData getDeleteByDateErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_BY_DATE_ERROR_COUNT, "Blob Delete By Date Error Counts");
    }

    @Override
    public CompositeData getAddRecordCountHistory() {
        return this.getTimeSeriesData(BLOB_ADD_RECORD_COUNT, "Blob Add Record Counts");
    }

    @Override
    public CompositeData getAddRecordErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_ADD_RECORD_ERROR_COUNT, "Blob Add Record Error Counts");
    }

    @Override
    public CompositeData getAddRecordSizeHistory() {
        return this.getTimeSeriesData(BLOB_ADD_RECORD_SIZE, "Blob Add Record (bytes)");
    }

    @Override
    public CompositeData getAddRecordRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.addRecordRateSeries, "Blob Add Record Times");
    }

    @Override
    public long getAddRecordErrorCount() {
        return this.addRecordErrorCount.getCount();
    }

    @Override
    public CompositeData getGetRecordCountHistory() {
        return this.getTimeSeriesData(BLOB_GETREC_COUNT, "Blob Get Record Counts");
    }

    @Override
    public CompositeData getGetRecordErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_GETREC_ERROR_COUNT, "Blob Get Record Error Counts");
    }

    @Override
    public CompositeData getGetRecordTimeHistory() {
        return this.getTimeSeriesData(BLOB_GETREC_TIME, "Blob Get Record Times");
    }

    @Override
    public CompositeData getGetRecordSizeHistory() {
        return this.getTimeSeriesData(BLOB_GETREC_SIZE, "Blob Get Record Sizes");
    }

    @Override
    public CompositeData getGetRecordRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.getRecordRateSeries, "BlobGet Record bytes/sec");
    }

    @Override
    public CompositeData getGetRecordIfStoredCountHistory() {
        return this.getTimeSeriesData(BLOB_GETRECIFSTORED_COUNT, "Blob Get Record If Stored Counts");
    }

    @Override
    public CompositeData getGetRecordIfStoredErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_GETRECIFSTORED_ERROR_COUNT, "Blob Get Record If Stored Error Counts");
    }

    @Override
    public CompositeData getGetRecordIfStoredTimeHistory() {
        return this.getTimeSeriesData(BLOB_GETRECIFSTORED_TIME, "Blob Get Record If Stored Times");
    }

    @Override
    public CompositeData getGetRecordIfStoredSizeHistory() {
        return this.getTimeSeriesData(BLOB_GETRECIFSTORED_SIZE, "Blob Get Record If Stored Sizes");
    }

    @Override
    public CompositeData getGetRecordIfStoredRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.getRecordIfStoredRateSeries, "Blob Get Record If Stored bytes/sec");
    }

    @Override
    public CompositeData getGetRecordFromReferenceCountHistory() {
        return this.getTimeSeriesData(BLOB_GETRECFROMREF_COUNT, "Blob Get Record From Reference Counts");
    }

    @Override
    public CompositeData getGetRecordFromReferenceErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_GETRECFROMREF_ERROR_COUNT, "Blob Get Record From Reference Error Counts");
    }

    @Override
    public CompositeData getGetRecordFromReferenceTimeHistory() {
        return this.getTimeSeriesData(BLOB_GETRECFROMREF_TIME, "Blob Get Record From Reference Times");
    }

    @Override
    public CompositeData getGetRecordFromReferenceSizeHistory() {
        return this.getTimeSeriesData(BLOB_GETRECFROMREF_SIZE, "Blob Get Record From Reference Sizes");
    }

    @Override
    public CompositeData getGetRecordFromReferenceRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.getRecordFromRefRateSeries, "Blob Get Record From Reference bytes/sec");
    }

    @Override
    public CompositeData getGetRecordForIdCountHistory() {
        return this.getTimeSeriesData(BLOB_GETRECFORID_COUNT, "Blob Get Record for ID Counts");
    }

    @Override
    public CompositeData getGetRecordForIdErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_GETRECFORID_ERROR_COUNT, "Blob Get Record for ID Error Counts");
    }

    @Override
    public CompositeData getGetRecordForIdTimeHistory() {
        return this.getTimeSeriesData(BLOB_GETRECFORID_TIME, "Blob Get Record for ID Times");
    }

    @Override
    public CompositeData getGetRecordForIdSizeHistory() {
        return this.getTimeSeriesData(BLOB_GETRECFORID_SIZE, "Blob Get Record For ID Sizes");
    }

    @Override
    public CompositeData getGetRecordForIdRateHistory() {
        return TimeSeriesStatsUtil.asCompositeData(this.getRecordForIdRateSeries, "Blob Get Record For ID bytes/sec");
    }

    @Override
    public CompositeData getGetAllRecordsCountHistory() {
        return this.getTimeSeriesData(BLOB_GETALLRECORDS_COUNT, "Blob Get All Records Counts");
    }

    @Override
    public CompositeData getGetAllRecordsTimeHistory() {
        return this.getTimeSeriesData(BLOB_GETALLRECORDS_TIME, "Blob Get All Records Times");
    }

    @Override
    public CompositeData getListIdsCountHistory() {
        return this.getTimeSeriesData(BLOB_LISTIDS_COUNT, "Blob Get All Identifiers Counts");
    }

    @Override
    public CompositeData getListIdsTimeHistory() {
        return this.getTimeSeriesData(BLOB_LISTIDS_TIME, "Blob Get All Identifiers Times");
    }

    @Override
    public CompositeData getListIdsErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_LISTIDS_ERROR_COUNT, "Blob Get All Identifiers Error Counts");
    }

    @Override
    public CompositeData getAddMetadataRecordCountHistory() {
        return this.getTimeSeriesData(BLOB_ADD_METADATA_RECORD_COUNT, "Blob Add Metadata Record Counts");
    }

    @Override
    public CompositeData getAddMetadataRecordTimeHistory() {
        return this.getTimeSeriesData(BLOB_ADD_METADATA_RECORD_TIME, "Blob Add Metadata Record Times");
    }

    @Override
    public CompositeData getAddMetadataRecordErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_ADD_METADATA_RECORD_ERROR_COUNT, "Blob Add Metadata Record Error Counts");
    }

    @Override
    public CompositeData getGetMetadataRecordCountHistory() {
        return this.getTimeSeriesData(BLOB_GET_METADATA_RECORD_COUNT, "Blob Get Metadata Record Counts");
    }

    @Override
    public CompositeData getGetMetadataRecordTimeHistory() {
        return this.getTimeSeriesData(BLOB_GET_METADATA_RECORD_TIME, "Blob Get Metadata Record Times");
    }

    @Override
    public CompositeData getGetMetadataRecordErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_GET_METADATA_RECORD_ERROR_COUNT, "Blob Get Metadata Record Error Counts");
    }

    @Override
    public CompositeData getGetAllMetadataRecordsCountHistory() {
        return this.getTimeSeriesData(BLOB_GET_ALL_METADATA_RECORDS_COUNT, "Blob Get All Metadata Records Counts");
    }

    @Override
    public CompositeData getGetAllMetadataRecordsTimeHistory() {
        return this.getTimeSeriesData(BLOB_GET_ALL_METADATA_RECORDS_TIME, "Blob Get All Metadata Records Times");
    }

    @Override
    public CompositeData getGetAllMetadataRecordsErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_GET_ALL_METADATA_RECORDS_ERROR_COUNT, "Blob Get All Metadata Records Error Counts");
    }

    @Override
    public CompositeData getMetadataRecordExistsCountHistory() {
        return this.getTimeSeriesData(BLOB_METADATA_RECORD_EXISTS_COUNT, "Blob Metadata Record Exists Counts");
    }

    @Override
    public CompositeData getMetadataRecordExistsTimeHistory() {
        return this.getTimeSeriesData(BLOB_METADATA_RECORD_EXISTS_TIME, "Blob Metadata Record Exists Times");
    }

    @Override
    public CompositeData getMetadataRecordExistsErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_METADATA_RECORD_EXISTS_ERROR_COUNT, "Blob Metadata Record Exists Error Counts");
    }

    @Override
    public CompositeData getDeleteMetadataRecordCountHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_METADATA_RECORD_COUNT, "Blob Delete Metadata Record Counts");
    }

    @Override
    public CompositeData getDeleteMetadataRecordTimeHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_METADATA_RECORD_TIME, "Blob Delete Metadata Record Times");
    }

    @Override
    public CompositeData getDeleteMetadataRecordErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_METADATA_RECORD_ERROR_COUNT, "Blob Delete Metadata Record Error Counts");
    }

    @Override
    public CompositeData getDeleteAllMetadataRecordsCountHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_ALL_METADATA_RECORDS_COUNT, "Blob Delete All Metadata Records Counts");
    }

    @Override
    public CompositeData getDeleteAllMetadataRecordsTimeHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_ALL_METADATA_RECORDS_TIME, "Blob Delete All Metadata Records Times");
    }

    @Override
    public CompositeData getDeleteAllMetadataRecordsErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_DELETE_ALL_METADATA_RECORDS_ERROR_COUNT, "Blob Delete All Metadata Records Error Counts");
    }

    @Override
    public CompositeData getInitBlobUploadCountHistory() {
        return this.getTimeSeriesData(BLOB_INIT_DIRECT_UPLOAD_COUNT, "Blob Initiate Direct Upload Counts");
    }

    @Override
    public CompositeData getInitBlobUploadTimeHistory() {
        return this.getTimeSeriesData(BLOB_INIT_DIRECT_UPLOAD_TIME, "Blob Initiate Direct Upload Times");
    }

    @Override
    public CompositeData getInitBlobUploadErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_INIT_DIRECT_UPLOAD_ERROR_COUNT, "Blob Initiate Direct Upload Error Counts");
    }

    @Override
    public CompositeData getCompleteBlobUploadCountHistory() {
        return this.getTimeSeriesData(BLOB_COMPLETE_DIRECT_UPLOAD_COUNT, "Blob Complete Direct Upload Counts");
    }

    @Override
    public CompositeData getCompleteBlobUploadTimeHistory() {
        return this.getTimeSeriesData(BLOB_COMPLETE_DIRECT_UPLOAD_TIME, "Blob Complete Direct Upload Times");
    }

    @Override
    public CompositeData getCompleteBlobUploadErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_COMPLETE_DIRECT_UPLOAD_ERROR_COUNT, "Blob Complete Direct Upload Error Counts");
    }

    @Override
    public CompositeData getGetBlobDownloadURICountHistory() {
        return this.getTimeSeriesData(BLOB_GET_DIRECT_DOWNLOAD_URI_COUNT, "Blob Get Direct Download URI Counts");
    }

    @Override
    public CompositeData getGetBlobDownloadURITimeHistory() {
        return this.getTimeSeriesData(BLOB_GET_DIRECT_DOWNLOAD_URI_TIME, "Blob Get Direct Download URI Times");
    }

    @Override
    public CompositeData getGetBlobDownloadURIErrorCountHistory() {
        return this.getTimeSeriesData(BLOB_GET_DIRECT_DOWNLOAD_URI_ERROR_COUNT, "Blob Get Direct Download URI Error Counts");
    }

    private CompositeData getTimeSeriesData(String name, String desc) {
        return TimeSeriesStatsUtil.asCompositeData(this.getTimeSeries(name), desc);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }

    private TimeSeries getAvgTimeSeries(String nameValue, String nameCounter) {
        return new TimeSeriesAverage(this.getTimeSeries(nameValue), new UnitConvertingTimeSeries(this.getTimeSeries(nameCounter), this.recordedTimeUnit, TimeUnit.SECONDS));
    }

    private static class UnitConvertingTimeSeries
    implements TimeSeries {
        private final TimeSeries series;
        private final TimeUnit source;
        private final TimeUnit dest;

        public UnitConvertingTimeSeries(TimeSeries series, TimeUnit source, TimeUnit dest) {
            this.series = series;
            this.source = source;
            this.dest = dest;
        }

        @Override
        public long[] getValuePerSecond() {
            return this.convert(this.series.getValuePerSecond());
        }

        @Override
        public long[] getValuePerMinute() {
            return this.convert(this.series.getValuePerMinute());
        }

        @Override
        public long[] getValuePerHour() {
            return this.convert(this.series.getValuePerHour());
        }

        @Override
        public long[] getValuePerWeek() {
            return this.convert(this.series.getValuePerWeek());
        }

        @Override
        public long getMissingValue() {
            return 0L;
        }

        private long[] convert(long[] timings) {
            for (int i = 0; i < timings.length; ++i) {
                timings[i] = this.dest.convert(timings[i], this.source);
            }
            return timings;
        }
    }
}

