/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import org.apache.jackrabbit.guava.common.base.Joiner;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConflictValidator
extends DefaultValidator {
    private static Logger log = LoggerFactory.getLogger(ConflictValidator.class);
    private final String path;
    private NodeState after;

    @Deprecated
    public ConflictValidator(Tree parentAfter) {
        this();
    }

    ConflictValidator() {
        this.path = "/";
    }

    private ConflictValidator(String path, String name) {
        this.path = PathUtils.concat(path, name);
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.after = after;
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        this.after = null;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.failOnMergeConflict(after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.failOnMergeConflict(after);
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) {
        return new ConflictValidator(this.path, name);
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) {
        return new ConflictValidator(this.path, name);
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) {
        return null;
    }

    private void failOnMergeConflict(PropertyState property) throws CommitFailedException {
        if ("jcr:mixinTypes".equals(property.getName())) {
            assert (property.isArray());
            for (String v : property.getValue(Type.STRINGS)) {
                if (!"rep:MergeConflict".equals(v)) continue;
                CommitFailedException ex = new CommitFailedException("State", 1, "Unresolved conflicts in " + this.path);
                if (log.isDebugEnabled()) {
                    log.debug(this.getConflictMessage(), ex);
                }
                throw ex;
            }
        }
    }

    private String getConflictMessage() {
        StringBuilder sb = new StringBuilder("Commit failed due to unresolved conflicts in ");
        sb.append(this.path);
        sb.append(" = {");
        for (ChildNodeEntry childNodeEntry : this.after.getChildNode("rep:ours").getChildNodeEntries()) {
            ConflictType ct = ConflictType.fromName(childNodeEntry.getName());
            NodeState node = childNodeEntry.getNodeState();
            sb.append(ct.getName()).append(" = {");
            if (ct.effectsNode()) {
                sb.append(ConflictValidator.getChildNodeNamesAsString(node));
            } else {
                for (PropertyState propertyState : node.getProperties()) {
                    PropertyState ours = null;
                    PropertyState theirs = null;
                    switch (ct) {
                        case DELETE_CHANGED_PROPERTY: {
                            ours = null;
                            theirs = propertyState;
                            break;
                        }
                        case ADD_EXISTING_PROPERTY: 
                        case CHANGE_CHANGED_PROPERTY: {
                            ours = propertyState;
                            theirs = this.after.getProperty(propertyState.getName());
                            break;
                        }
                        case CHANGE_DELETED_PROPERTY: {
                            ours = propertyState;
                            theirs = null;
                        }
                    }
                    sb.append(propertyState.getName()).append(" = {").append(ConflictValidator.toString(ours)).append(',').append(ConflictValidator.toString(theirs)).append('}');
                    sb.append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("},");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append('}');
        return sb.toString();
    }

    private static String getChildNodeNamesAsString(NodeState ns) {
        return Joiner.on((char)',').join(ns.getChildNodeNames());
    }

    private static String toString(PropertyState ps) {
        if (ps == null) {
            return "<N/A>";
        }
        Type<?> type = ps.getType();
        if (type.isArray()) {
            return "<ARRAY>";
        }
        if (Type.BINARY == type) {
            return "<BINARY>";
        }
        Object value = ps.getValue(Type.STRING);
        if (Type.STRING == type && ((String)value).length() > 10) {
            value = ((String)value).substring(0, 10) + "...";
        }
        return value;
    }
}

