/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.Iterator;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.plugins.index.nodetype.NodeTypeIndexProvider;
import org.apache.jackrabbit.oak.query.NodeStateNodeTypeInfoProvider;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfo;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class IndexPathServiceImpl
implements IndexPathService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final QueryEngineSettings settings = new QueryEngineSettings();
    @Reference
    private NodeStore nodeStore;
    @Reference
    private MountInfoProvider mountInfoProvider;

    public IndexPathServiceImpl() {
        this.settings.setFailTraversal(true);
        this.settings.setLimitReads(Long.MAX_VALUE);
    }

    public IndexPathServiceImpl(NodeStore nodeStore) {
        this(nodeStore, Mounts.defaultMountInfoProvider());
    }

    public IndexPathServiceImpl(NodeStore nodeStore, MountInfoProvider mountInfoProvider) {
        this.nodeStore = nodeStore;
        this.mountInfoProvider = mountInfoProvider;
    }

    @Override
    public Iterable<String> getIndexPaths() {
        NodeState nodeType = NodeStateUtils.getNode(this.nodeStore.getRoot(), "/oak:index/nodetype");
        Preconditions.checkState((boolean)"property".equals(nodeType.getString("type")), (Object)"nodetype index at /oak:index/nodetype is found to be disabled. Cannot determine the paths of all indexes");
        boolean indxDefnTypeIndexed = Iterables.contains(nodeType.getNames("declaringNodeTypes"), (Object)"oak:QueryIndexDefinition");
        if (!indxDefnTypeIndexed) {
            this.log.warn("{} is not found to be indexed as part of nodetype index. Non root indexes would not be listed", (Object)"oak:QueryIndexDefinition");
            NodeState oakIndex = this.nodeStore.getRoot().getChildNode("oak:index");
            return Iterables.transform((Iterable)Iterables.filter(oakIndex.getChildNodeEntries(), cne -> "oak:QueryIndexDefinition".equals(cne.getNodeState().getName("jcr:primaryType"))), cne -> PathUtils.concat("/oak:index", cne.getName()));
        }
        return () -> {
            Cursor itr = this.getIndex().query((Filter)this.createFilter("oak:QueryIndexDefinition"), this.nodeStore.getRoot());
            return Iterators.transform((Iterator)itr, input -> input.getPath());
        };
    }

    private FilterImpl createFilter(String nodeTypeName) {
        NodeStateNodeTypeInfoProvider nodeTypes = new NodeStateNodeTypeInfoProvider(this.nodeStore.getRoot());
        NodeTypeInfo type = nodeTypes.getNodeTypeInfo(nodeTypeName);
        SelectorImpl selector = new SelectorImpl(type, nodeTypeName);
        return new FilterImpl(selector, "SELECT * FROM [" + nodeTypeName + "]", (QueryLimits)this.settings);
    }

    private QueryIndex getIndex() {
        NodeTypeIndexProvider idxProvider = new NodeTypeIndexProvider();
        idxProvider.with(this.mountInfoProvider);
        return (QueryIndex)idxProvider.getQueryIndexes(this.nodeStore.getRoot()).get(0);
    }

    @Override
    public MountInfoProvider getMountInfoProvider() {
        return this.mountInfoProvider;
    }
}

