/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.NodeStateAnalyzerFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakAnalyzer;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakCodec;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.CompressingCodec;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.TokenizerChain;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.CommitMitigatingTieredMergePolicy;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.util.ConfigUtil;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.path.PathHierarchyTokenizerFactory;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexDefinition
extends IndexDefinition {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexDefinition.class);
    private final boolean saveDirListing;
    private final Map<String, Analyzer> analyzers;
    private final Analyzer analyzer;
    private final Codec codec;
    private final int maxFieldLength;

    public LuceneIndexDefinition(NodeState root, NodeState defn, String indexPath) {
        this(root, LuceneIndexDefinition.getIndexDefinitionState((NodeState)defn), LuceneIndexDefinition.determineIndexFormatVersion((NodeState)defn), LuceneIndexDefinition.determineUniqueId((NodeState)defn), indexPath);
    }

    LuceneIndexDefinition(NodeState root, NodeState defn, IndexFormatVersion version, String uid, String indexPath) {
        super(root, defn, version, uid, indexPath);
        this.saveDirListing = ConfigUtil.getOptionalValue((NodeState)defn, (String)"saveDirectoryListing", (boolean)true);
        this.maxFieldLength = ConfigUtil.getOptionalValue((NodeState)defn, (String)"maxFieldLength", (int)10000);
        this.analyzers = LuceneIndexDefinition.collectAnalyzers(defn);
        this.analyzer = this.createAnalyzer();
        this.codec = this.createCodec();
    }

    public static Builder newBuilder(NodeState root, NodeState defn, String indexPath) {
        return (Builder)new Builder().root(root).defn(defn).indexPath(indexPath);
    }

    protected String getDefaultFunctionName() {
        return "lucene";
    }

    protected double getDefaultCostPerEntry(IndexFormatVersion version) {
        return version == IndexFormatVersion.V1 ? 1.5 : 1.0;
    }

    public boolean saveDirListing() {
        return this.saveDirListing;
    }

    @Nullable
    public Codec getCodec() {
        return this.codec;
    }

    @NotNull
    public MergePolicy getMergePolicy() {
        return this.createMergePolicy();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private Analyzer createAnalyzer() {
        Analyzer result;
        Analyzer defaultAnalyzer = LuceneIndexConstants.ANALYZER;
        if (this.analyzers.containsKey("default")) {
            defaultAnalyzer = this.analyzers.get("default");
        }
        if (!this.evaluatePathRestrictions()) {
            result = defaultAnalyzer;
        } else {
            ImmutableMap analyzerMap = ImmutableMap.builder().put((Object)":ancestors", (Object)new TokenizerChain(new PathHierarchyTokenizerFactory(Collections.emptyMap()))).build();
            result = new PerFieldAnalyzerWrapper(defaultAnalyzer, (Map<String, Analyzer>)analyzerMap);
        }
        if (this.maxFieldLength < 0) {
            return result;
        }
        return new LimitTokenCountAnalyzer(result, this.maxFieldLength);
    }

    private static Map<String, Analyzer> collectAnalyzers(NodeState defn) {
        HashMap analyzerMap = Maps.newHashMap();
        NodeStateAnalyzerFactory factory = new NodeStateAnalyzerFactory(LuceneIndexConstants.VERSION);
        NodeState analyzersTree = defn.getChildNode("analyzers");
        for (ChildNodeEntry childNodeEntry : analyzersTree.getChildNodeEntries()) {
            Analyzer a = factory.createInstance(childNodeEntry.getNodeState());
            analyzerMap.put(childNodeEntry.getName(), a);
        }
        if (ConfigUtil.getOptionalValue((NodeState)analyzersTree, (String)"indexOriginalTerm", (boolean)false) && !analyzerMap.containsKey("default")) {
            analyzerMap.put("default", new OakAnalyzer(LuceneIndexConstants.VERSION, true));
        }
        return ImmutableMap.copyOf((Map)analyzerMap);
    }

    private Codec createCodec() {
        String mmp = System.getProperty("oak.lucene.compressing-codec");
        if (mmp != null) {
            return new CompressingCodec();
        }
        String codecName = ConfigUtil.getOptionalValue((NodeState)this.definition, (String)"codec", null);
        Codec codec = null;
        if (codecName != null) {
            OakCodec ensureLucene46CodecLoaded = new OakCodec();
            log.debug("Lucene46Codec is loaded: {}", (Object)ensureLucene46CodecLoaded);
            codec = Codec.forName(codecName);
            log.debug("Codec is loaded: {}", (Object)codecName);
        } else if (this.fullTextEnabled) {
            codec = new OakCodec();
        }
        return codec;
    }

    private MergePolicy createMergePolicy() {
        String mmp = System.getProperty("oak.lucene.cmmp");
        if (mmp != null) {
            return new CommitMitigatingTieredMergePolicy();
        }
        String mergePolicyName = ConfigUtil.getOptionalValue((NodeState)this.definition, (String)"mergePolicy", null);
        MergePolicy mergePolicy = null;
        if (mergePolicyName != null) {
            if (mergePolicyName.equalsIgnoreCase("no")) {
                mergePolicy = NoMergePolicy.COMPOUND_FILES;
            } else if (mergePolicyName.equalsIgnoreCase("mitigated")) {
                mergePolicy = new CommitMitigatingTieredMergePolicy();
            } else if (mergePolicyName.equalsIgnoreCase("tiered") || mergePolicyName.equalsIgnoreCase("default")) {
                mergePolicy = new TieredMergePolicy();
            } else if (mergePolicyName.equalsIgnoreCase("logbyte")) {
                mergePolicy = new LogByteSizeMergePolicy();
            } else if (mergePolicyName.equalsIgnoreCase("logdoc")) {
                mergePolicy = new LogDocMergePolicy();
            }
        }
        if (mergePolicy == null) {
            mergePolicy = new TieredMergePolicy();
        }
        return mergePolicy;
    }

    public static class Builder
    extends IndexDefinition.Builder {
        public LuceneIndexDefinition build() {
            return (LuceneIndexDefinition)super.build();
        }

        public Builder reindex() {
            super.reindex();
            return this;
        }

        protected IndexDefinition createInstance(NodeState indexDefnStateToUse) {
            return new LuceneIndexDefinition(this.root, indexDefnStateToUse, this.version, this.uid, this.indexPath);
        }
    }
}

