/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.util.Collection;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.IndexLookup;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class LuceneIndexLookupUtil {
    static final Predicate<NodeState> LUCENE_INDEX_DEFINITION_PREDICATE = state -> "lucene".equals(state.getString("type"));

    private LuceneIndexLookupUtil() {
    }

    public static String getOldFullTextIndexPath(NodeState root, Filter filter, IndexTracker tracker) {
        Collection indexPaths = LuceneIndexLookupUtil.getLuceneIndexLookup(root).collectIndexNodePaths(filter, false);
        for (String path : indexPaths) {
            LuceneIndexDefinition indexDefinition = tracker.getIndexDefinition(path);
            if (indexDefinition == null || !indexDefinition.isFullTextEnabled() || indexDefinition.getVersion() != IndexFormatVersion.V1) continue;
            return path;
        }
        return null;
    }

    public static IndexLookup getLuceneIndexLookup(NodeState root) {
        return new IndexLookup(root, LUCENE_INDEX_DEFINITION_PREDICATE);
    }
}

