/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.permission;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Permissions {
    public static final long NO_PERMISSION = 0L;
    public static final long READ_NODE = 1L;
    public static final long READ_PROPERTY = 2L;
    public static final long ADD_PROPERTY = 4L;
    public static final long MODIFY_PROPERTY = 8L;
    public static final long REMOVE_PROPERTY = 16L;
    public static final long ADD_NODE = 32L;
    public static final long REMOVE_NODE = 64L;
    public static final long READ_ACCESS_CONTROL = 128L;
    public static final long MODIFY_ACCESS_CONTROL = 256L;
    public static final long NODE_TYPE_MANAGEMENT = 512L;
    public static final long VERSION_MANAGEMENT = 1024L;
    public static final long LOCK_MANAGEMENT = 2048L;
    public static final long LIFECYCLE_MANAGEMENT = 4096L;
    public static final long RETENTION_MANAGEMENT = 8192L;
    public static final long MODIFY_CHILD_NODE_COLLECTION = 16384L;
    public static final long NODE_TYPE_DEFINITION_MANAGEMENT = 32768L;
    public static final long NAMESPACE_MANAGEMENT = 65536L;
    public static final long WORKSPACE_MANAGEMENT = 131072L;
    public static final long PRIVILEGE_MANAGEMENT = 262144L;
    public static final long USER_MANAGEMENT = 524288L;
    public static final long INDEX_DEFINITION_MANAGEMENT = 0x100000L;
    public static final long READ = 3L;
    public static final long REMOVE = 80L;
    public static final long SET_PROPERTY = 28L;
    public static final long WRITE = 124L;
    public static final long ALL = 0x1FFFFFL;
    private static final Set<Long> NON_AGGREGATES = ImmutableSet.of((Object)1L, (Object)2L, (Object)4L, (Object)8L, (Object)16L, (Object)32L, (Object[])new Long[]{64L, 16384L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L});
    public static final Map<Long, String> PERMISSION_NAMES = new LinkedHashMap<Long, String>();
    private static final Map<String, Long> PERMISSION_LOOKUP;
    private static final Set<String> WRITE_ACTIONS;
    private static final Map<String, Long> ACTIONS_MAP;

    private Permissions() {
    }

    public static Set<String> getNames(long permissions) {
        if (PERMISSION_NAMES.containsKey(permissions)) {
            return ImmutableSet.of((Object)PERMISSION_NAMES.get(permissions));
        }
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<Long, String> entry : PERMISSION_NAMES.entrySet()) {
            long key = entry.getKey();
            if ((permissions & key) != key) continue;
            names.add(entry.getValue());
        }
        return names;
    }

    public static String getString(long permissions) {
        if (PERMISSION_NAMES.containsKey(permissions)) {
            return PERMISSION_NAMES.get(permissions);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, String> entry : PERMISSION_NAMES.entrySet()) {
            long key = entry.getKey();
            if ((permissions & key) != key) continue;
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public static boolean isRepositoryPermission(long permission) {
        return permission == 65536L || permission == 32768L || permission == 262144L || permission == 131072L;
    }

    public static boolean isAggregate(long permission) {
        return permission > 0L && !NON_AGGREGATES.contains(permission);
    }

    public static Iterable<Long> aggregates(long permissions) {
        if (0x1FFFFFL == permissions) {
            return NON_AGGREGATES;
        }
        return NON_AGGREGATES.stream().filter(permission -> Permissions.includes(permissions, permission)).collect(Collectors.toSet());
    }

    public static boolean includes(long permissions, long permissionsToTest) {
        return (permissions & permissionsToTest) == permissionsToTest;
    }

    public static boolean respectParentPermissions(long permissions) {
        return Permissions.includes(permissions, 32L) || Permissions.includes(permissions, 64L);
    }

    public static long diff(long permissions, long otherPermissions) {
        return permissions & (otherPermissions ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long getPermissions(@NotNull String jcrActions, @NotNull TreeLocation location, boolean isAccessControlContent) {
        HashSet actions = Sets.newHashSet((Object[])Text.explode(jcrActions, 44, false));
        long permissions = 0L;
        if (actions.remove("read")) {
            permissions |= Permissions.mapReadAction(location, isAccessControlContent);
        }
        if (!actions.isEmpty()) {
            if (isAccessControlContent) {
                if (actions.removeAll(WRITE_ACTIONS)) {
                    permissions |= 0x100L;
                }
            } else {
                permissions |= Permissions.mapWriteActions(actions, location);
            }
        }
        if (!actions.isEmpty()) {
            for (Map.Entry<String, Long> actionEntry : ACTIONS_MAP.entrySet()) {
                if (!actions.remove(actionEntry.getKey())) continue;
                permissions |= actionEntry.getValue().longValue();
            }
            permissions |= Permissions.getPermissions(actions);
        }
        if (!actions.isEmpty()) {
            throw new IllegalArgumentException("Unknown actions: " + actions);
        }
        return permissions;
    }

    private static long mapReadAction(@NotNull TreeLocation location, boolean isAccessControlContent) {
        if (isAccessControlContent) {
            return 128L;
        }
        if (!location.exists()) {
            return 3L;
        }
        if (location.getProperty() != null) {
            return 2L;
        }
        return 1L;
    }

    private static long mapWriteActions(@NotNull Set<String> actions, @NotNull TreeLocation location) {
        long permissions = 0L;
        if (actions.remove("set_property")) {
            permissions = location.getProperty() == null ? (permissions |= 4L) : (permissions |= 8L);
        }
        if (actions.remove("remove")) {
            permissions = !location.exists() ? (permissions |= 0x50L) : (location.getProperty() != null ? (permissions |= 0x10L) : (permissions |= 0x40L));
        }
        return permissions;
    }

    public static long getPermissions(@Nullable String permissionNames) {
        if (permissionNames == null || permissionNames.isEmpty()) {
            return 0L;
        }
        return Permissions.getPermissions(Sets.newHashSet(Arrays.asList(permissionNames.split(","))));
    }

    private static long getPermissions(@NotNull Set<String> permissionNames) {
        long permissions = 0L;
        Iterator<String> it = permissionNames.iterator();
        while (it.hasNext()) {
            String name = it.next();
            if (!PERMISSION_LOOKUP.containsKey(name)) continue;
            permissions |= PERMISSION_LOOKUP.get(name).longValue();
            it.remove();
        }
        return permissions;
    }

    public static long getPermission(@Nullable String path, long defaultPermission) {
        long permission = "/jcr:system/rep:namespaces".equals(path) ? 65536L : ("/jcr:system/jcr:nodeTypes".equals(path) ? 32768L : (VersionConstants.SYSTEM_PATHS.contains(path) ? 1024L : ("/jcr:system/rep:privileges".equals(path) ? 262144L : defaultPermission)));
        return permission;
    }

    static {
        PERMISSION_NAMES.put(0x1FFFFFL, "ALL");
        PERMISSION_NAMES.put(3L, "READ");
        PERMISSION_NAMES.put(1L, "READ_NODE");
        PERMISSION_NAMES.put(2L, "READ_PROPERTY");
        PERMISSION_NAMES.put(28L, "SET_PROPERTY");
        PERMISSION_NAMES.put(4L, "ADD_PROPERTY");
        PERMISSION_NAMES.put(8L, "MODIFY_PROPERTY");
        PERMISSION_NAMES.put(16L, "REMOVE_PROPERTY");
        PERMISSION_NAMES.put(32L, "ADD_NODE");
        PERMISSION_NAMES.put(64L, "REMOVE_NODE");
        PERMISSION_NAMES.put(80L, "REMOVE");
        PERMISSION_NAMES.put(124L, "WRITE");
        PERMISSION_NAMES.put(16384L, "MODIFY_CHILD_NODE_COLLECTION");
        PERMISSION_NAMES.put(128L, "READ_ACCESS_CONTROL");
        PERMISSION_NAMES.put(256L, "MODIFY_ACCESS_CONTROL");
        PERMISSION_NAMES.put(512L, "NODE_TYPE_MANAGEMENT");
        PERMISSION_NAMES.put(1024L, "VERSION_MANAGEMENT");
        PERMISSION_NAMES.put(2048L, "LOCK_MANAGEMENT");
        PERMISSION_NAMES.put(4096L, "LIFECYCLE_MANAGEMENT");
        PERMISSION_NAMES.put(8192L, "RETENTION_MANAGEMENT");
        PERMISSION_NAMES.put(32768L, "NODE_TYPE_DEFINITION_MANAGEMENT");
        PERMISSION_NAMES.put(65536L, "NAMESPACE_MANAGEMENT");
        PERMISSION_NAMES.put(131072L, "WORKSPACE_MANAGEMENT");
        PERMISSION_NAMES.put(262144L, "PRIVILEGE_MANAGEMENT");
        PERMISSION_NAMES.put(524288L, "USER_MANAGEMENT");
        PERMISSION_NAMES.put(0x100000L, "INDEX_DEFINITION_MANAGEMENT");
        PERMISSION_LOOKUP = new LinkedHashMap<String, Long>();
        PERMISSION_LOOKUP.put("ALL", 0x1FFFFFL);
        PERMISSION_LOOKUP.put("READ", 3L);
        PERMISSION_LOOKUP.put("READ_NODE", 1L);
        PERMISSION_LOOKUP.put("READ_PROPERTY", 2L);
        PERMISSION_LOOKUP.put("SET_PROPERTY", 28L);
        PERMISSION_LOOKUP.put("ADD_PROPERTY", 4L);
        PERMISSION_LOOKUP.put("MODIFY_PROPERTY", 8L);
        PERMISSION_LOOKUP.put("REMOVE_PROPERTY", 16L);
        PERMISSION_LOOKUP.put("ADD_NODE", 32L);
        PERMISSION_LOOKUP.put("REMOVE_NODE", 64L);
        PERMISSION_LOOKUP.put("REMOVE", 80L);
        PERMISSION_LOOKUP.put("WRITE", 124L);
        PERMISSION_LOOKUP.put("MODIFY_CHILD_NODE_COLLECTION", 16384L);
        PERMISSION_LOOKUP.put("READ_ACCESS_CONTROL", 128L);
        PERMISSION_LOOKUP.put("MODIFY_ACCESS_CONTROL", 256L);
        PERMISSION_LOOKUP.put("NODE_TYPE_MANAGEMENT", 512L);
        PERMISSION_LOOKUP.put("VERSION_MANAGEMENT", 1024L);
        PERMISSION_LOOKUP.put("LOCK_MANAGEMENT", 2048L);
        PERMISSION_LOOKUP.put("LIFECYCLE_MANAGEMENT", 4096L);
        PERMISSION_LOOKUP.put("RETENTION_MANAGEMENT", 8192L);
        PERMISSION_LOOKUP.put("NODE_TYPE_DEFINITION_MANAGEMENT", 32768L);
        PERMISSION_LOOKUP.put("NAMESPACE_MANAGEMENT", 65536L);
        PERMISSION_LOOKUP.put("WORKSPACE_MANAGEMENT", 131072L);
        PERMISSION_LOOKUP.put("PRIVILEGE_MANAGEMENT", 262144L);
        PERMISSION_LOOKUP.put("USER_MANAGEMENT", 524288L);
        PERMISSION_LOOKUP.put("INDEX_DEFINITION_MANAGEMENT", 0x100000L);
        WRITE_ACTIONS = ImmutableSet.of((Object)"remove", (Object)"add_node", (Object)"set_property", (Object)"remove_node", (Object)"add_property", (Object)"modify_property", (Object[])new String[]{"remove_property"});
        ACTIONS_MAP = new LinkedHashMap<String, Long>();
        ACTIONS_MAP.put("add_node", 32L);
        ACTIONS_MAP.put("add_property", 4L);
        ACTIONS_MAP.put("modify_property", 8L);
        ACTIONS_MAP.put("remove_property", 16L);
        ACTIONS_MAP.put("remove_node", 64L);
        ACTIONS_MAP.put("node_type_management", 512L);
        ACTIONS_MAP.put("locking", 2048L);
        ACTIONS_MAP.put("versioning", 1024L);
        ACTIONS_MAP.put("read_access_control", 128L);
        ACTIONS_MAP.put("modify_access_control", 256L);
        ACTIONS_MAP.put("user_management", 524288L);
    }
}

