/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropInfo {
    private final String name;
    private final int type;
    private final List<? extends TextValue> values;
    private final MultipleStatus multipleStatus;

    public PropInfo(@Nullable String name, int type, @NotNull TextValue value) {
        this(name, type, (List<? extends TextValue>)ImmutableList.of((Object)value), MultipleStatus.UNKNOWN);
    }

    public PropInfo(@Nullable String name, int type, @NotNull List<? extends TextValue> values) {
        this(name, type, values, values.size() == 1 ? MultipleStatus.UNKNOWN : MultipleStatus.MULTIPLE);
    }

    public PropInfo(@Nullable String name, int type, @NotNull List<? extends TextValue> values, @NotNull MultipleStatus multipleStatus) {
        this.name = name;
        this.type = type;
        this.values = ImmutableList.copyOf(values);
        this.multipleStatus = multipleStatus;
    }

    public void dispose() {
        for (TextValue textValue : this.values) {
            textValue.dispose();
        }
    }

    public int getTargetType(PropertyDefinition def) {
        int target = def.getRequiredType();
        if (target != 0) {
            return target;
        }
        if (this.type != 0) {
            return this.type;
        }
        return 1;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isUnknownMultiple() {
        return this.multipleStatus == MultipleStatus.UNKNOWN;
    }

    @NotNull
    public TextValue getTextValue() throws RepositoryException {
        if (this.multipleStatus == MultipleStatus.MULTIPLE) {
            throw new RepositoryException("Multiple import values with single-valued property definition");
        }
        return this.values.get(0);
    }

    @NotNull
    public List<? extends TextValue> getTextValues() {
        return this.values;
    }

    @NotNull
    public Value getValue(int targetType) throws RepositoryException {
        if (this.multipleStatus == MultipleStatus.MULTIPLE) {
            throw new RepositoryException("Multiple import values with single-valued property definition");
        }
        return this.values.get(0).getValue(targetType);
    }

    @NotNull
    public List<Value> getValues(int targetType) throws RepositoryException {
        if (this.values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList vs = Lists.newArrayListWithCapacity((int)this.values.size());
        for (TextValue textValue : this.values) {
            vs.add(textValue.getValue(targetType));
        }
        return vs;
    }

    public PropertyState asPropertyState(@NotNull PropertyDefinition propertyDefinition) throws RepositoryException {
        List<Value> vs = this.getValues(this.getTargetType(propertyDefinition));
        PropertyState propertyState = vs.size() == 1 && !propertyDefinition.isMultiple() ? PropertyStates.createProperty(this.name, vs.get(0)) : PropertyStates.createProperty(this.name, vs);
        return propertyState;
    }

    public static enum MultipleStatus {
        UNKNOWN,
        MULTIPLE;

    }
}

