/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthUtil {
    private static final String X_REQUESTED_WITH = "X-Requested-With";
    private static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private static final String USER_AGENT = "User-Agent";
    private static final String BROWSER_CLASS_MOZILLA = "Mozilla";
    private static final String BROWSER_CLASS_OPERA = "Opera";

    private AuthUtil() {
    }

    public static String getAttributeOrParameter(HttpServletRequest request, String name, String defaultValue) {
        String resourceAttr = AuthUtil.getAttributeString(request, name);
        if (resourceAttr != null) {
            return resourceAttr;
        }
        String resource = request.getParameter(name);
        if (resource != null && resource.length() > 0) {
            return resource;
        }
        return defaultValue;
    }

    public static String getLoginResource(HttpServletRequest request, String defaultLoginResource) {
        return AuthUtil.getAttributeOrParameter(request, "resource", defaultLoginResource);
    }

    public static String setLoginResourceAttribute(HttpServletRequest request, String defaultValue) {
        String resourceAttr = AuthUtil.getAttributeString(request, "resource");
        if (resourceAttr == null) {
            String resourcePar = request.getParameter("resource");
            resourceAttr = resourcePar != null && resourcePar.length() > 0 ? resourcePar : (defaultValue != null && defaultValue.length() > 0 ? defaultValue : "/");
            request.setAttribute("resource", resourceAttr);
        }
        return resourceAttr;
    }

    public static void sendRedirect(HttpServletRequest request, HttpServletResponse response, String target, Map<String, String> params) throws IOException {
        AuthUtil.checkAndReset(response);
        StringBuilder b = new StringBuilder();
        if (AuthUtil.isRedirectValid(request, target)) {
            b.append(target);
        } else if (request.getContextPath().length() == 0) {
            b.append("/");
        } else {
            b.append(request.getContextPath());
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        if (params.get("resource") == null) {
            String resource = request.getRequestURI();
            if (request.getQueryString() != null) {
                resource = resource + "?" + request.getQueryString();
            }
            params.put("resource", resource);
        }
        b.append('?');
        Iterator<Map.Entry<String, String>> ei = params.entrySet().iterator();
        while (ei.hasNext()) {
            Map.Entry<String, String> entry = ei.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            try {
                b.append(entry.getKey()).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new InternalError("Unexpected UnsupportedEncodingException for UTF-8");
            }
            if (!ei.hasNext()) continue;
            b.append('&');
        }
        response.sendRedirect(b.toString());
    }

    private static String getAttributeString(HttpServletRequest request, String name) {
        Object resObj = request.getAttribute(name);
        if (resObj instanceof String && ((String)resObj).length() > 0) {
            return (String)resObj;
        }
        return null;
    }

    public static boolean isValidateRequest(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("j_validate"));
    }

    public static void sendValid(HttpServletResponse response) {
        AuthUtil.checkAndReset(response);
        try {
            response.setStatus(200);
            response.setContentType("text/plain");
            response.setContentLength(0);
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
            response.flushBuffer();
        }
        catch (IOException ioe) {
            AuthUtil.getLog().error("Failed to send 200/OK response", ioe);
        }
    }

    public static void sendInvalid(HttpServletRequest request, HttpServletResponse response) {
        AuthUtil.checkAndReset(response);
        try {
            response.setStatus(403);
            Object reason = request.getAttribute("j_reason");
            Object reasonCode = request.getAttribute("j_reason_code");
            if (reason != null) {
                response.setHeader("X-Reason", reason.toString());
                if (reasonCode != null) {
                    response.setHeader("X-Reason-Code", reasonCode.toString());
                }
                response.setContentType("text/plain");
                response.setCharacterEncoding("UTF-8");
                response.getWriter().println(reason);
            }
            response.flushBuffer();
        }
        catch (IOException ioe) {
            AuthUtil.getLog().error("Failed to send 403/Forbidden response", ioe);
        }
    }

    public static boolean checkReferer(HttpServletRequest request, String loginForm) {
        String referer;
        if ("POST".equals(request.getMethod()) && (referer = request.getHeader("Referer")) != null) {
            String expectedPath = String.format("%s%s", request.getContextPath(), loginForm);
            try {
                URL uri = new URL(referer);
                if (!expectedPath.equals(uri.getPath())) {
                    return false;
                }
            }
            catch (MalformedURLException e) {
                AuthUtil.getLog().debug("Failed to parse the referer value for the login form " + loginForm, e);
            }
        }
        return true;
    }

    public static boolean isRedirectValid(HttpServletRequest request, String target) {
        if (target == null || target.length() == 0) {
            AuthUtil.getLog().warn("isRedirectValid: Redirect target must not be empty or null");
            return false;
        }
        try {
            new URI(target);
        }
        catch (URISyntaxException e) {
            AuthUtil.getLog().warn("isRedirectValid: Redirect target '{}' contains illegal characters", (Object)target);
            return false;
        }
        if (target.contains("://")) {
            AuthUtil.getLog().warn("isRedirectValid: Redirect target '{}' must not be an URL", (Object)target);
            return false;
        }
        if (target.contains("//") || target.contains("/../") || target.contains("/./") || target.endsWith("/.") || target.endsWith("/..")) {
            AuthUtil.getLog().warn("isRedirectValid: Redirect target '{}' is not normalized", (Object)target);
            return false;
        }
        String ctxPath = AuthUtil.getContextPath(request);
        if (ctxPath.length() > 0 && !target.startsWith(ctxPath)) {
            AuthUtil.getLog().warn("isRedirectValid: Redirect target '{}' does not start with servlet context path '{}'", (Object)target, (Object)ctxPath);
            return false;
        }
        if (ctxPath.length() == target.length()) {
            return true;
        }
        String localTarget = target.substring(ctxPath.length());
        if (!localTarget.startsWith("/")) {
            AuthUtil.getLog().warn("isRedirectValid: Redirect target '{}' without servlet context path '{}' must be an absolute path", (Object)target, (Object)ctxPath);
            return false;
        }
        int query = localTarget.indexOf(63);
        String path = query > 0 ? localTarget.substring(0, query) : localTarget;
        ResourceResolver resolver = AuthUtil.getResourceResolver(request);
        if (resolver != null && !ResourceUtil.isNonExistingResource(resolver.resolve(request, path))) {
            return true;
        }
        Pattern illegal = Pattern.compile("[<>'\"]");
        if (illegal.matcher(path).find()) {
            AuthUtil.getLog().warn("isRedirectValid: Redirect target '{}' must not contain any of <>'\"", (Object)target);
            return false;
        }
        return true;
    }

    private static String getContextPath(HttpServletRequest request) {
        if (request != null) {
            return request.getContextPath();
        }
        return "";
    }

    private static ResourceResolver getResourceResolver(HttpServletRequest request) {
        if (request != null) {
            return (ResourceResolver)request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
        }
        return null;
    }

    public static boolean isBrowserRequest(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT);
        return userAgent != null && (userAgent.contains(BROWSER_CLASS_MOZILLA) || userAgent.contains(BROWSER_CLASS_OPERA));
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return XML_HTTP_REQUEST.equals(request.getHeader(X_REQUESTED_WITH));
    }

    private static void checkAndReset(HttpServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
        response.resetBuffer();
    }

    private static Logger getLog() {
        return LoggerFactory.getLogger("org.apache.sling.auth.core.AuthUtil");
    }
}

