/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.event;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.event.Event;

public class DistributionEvent {
    private final String packageId;
    private final String componentName;
    private final String componentKind;
    private final String distType;
    private final String[] distPaths;
    private final String[] distDeepPaths;

    public DistributionEvent(String packageId, String componentName, String componentKind, String distType, String[] distPaths, String[] distDeepPaths) {
        this.packageId = packageId;
        this.componentName = componentName;
        this.componentKind = componentKind;
        this.distType = distType;
        this.distPaths = distPaths;
        this.distDeepPaths = distDeepPaths == null ? new String[]{} : distDeepPaths;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentKind() {
        return this.componentKind;
    }

    public String getDistType() {
        return this.distType;
    }

    public String[] getDistPaths() {
        return this.distPaths;
    }

    public String[] getDistDeepPaths() {
        return this.distDeepPaths;
    }

    public Event toEvent(String topic) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("distribution.package.id", this.packageId);
        ((Dictionary)props).put("distribution.component.name", this.componentName);
        ((Dictionary)props).put("distribution.component.kind", this.componentKind);
        ((Dictionary)props).put("distribution.type", this.distType);
        ((Dictionary)props).put("distribution.paths", this.distPaths);
        ((Dictionary)props).put("distribution.deep.paths", this.distDeepPaths);
        return new Event(topic, (Dictionary<String, ?>)props);
    }

    public static DistributionEvent fromEvent(Event event) {
        return new DistributionEvent(event.getProperty("distribution.package.id").toString(), event.getProperty("distribution.component.name").toString(), event.getProperty("distribution.component.kind").toString(), event.getProperty("distribution.type").toString(), (String[])event.getProperty("distribution.paths"), (String[])event.getProperty("distribution.deep.paths"));
    }
}

