/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue;

import java.util.Arrays;
import java.util.Map;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;

public final class DistributionQueueItem
extends ValueMapDecorator
implements ValueMap {
    private final String packageId;
    private final long size;

    public DistributionQueueItem(@NotNull String packageId, Map<String, Object> base) {
        this(packageId, -1L, base);
    }

    public DistributionQueueItem(String packageId, long size, Map<String, Object> base) {
        super(base);
        this.packageId = packageId;
        this.size = size;
    }

    @NotNull
    public String getPackageId() {
        return this.packageId;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public String toString() {
        return "DistributionQueueItem{id='" + this.packageId + '\'' + ", info={" + this.getQueueInfo() + '}' + '}';
    }

    private String getQueueInfo() {
        String queueItemStr = "";
        for (String key : super.keySet()) {
            Object value = super.get(key);
            String valueString = "";
            valueString = value.getClass().isArray() ? key + "=" + Arrays.toString((Object[])value) : key + "=" + value.toString();
            queueItemStr = String.join((CharSequence)",", queueItemStr, valueString);
        }
        return queueItemStr.isEmpty() ? queueItemStr : queueItemStr.substring(1);
    }
}

