/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPropertyTag
extends TagSupport {
    private static final Logger log = LoggerFactory.getLogger(GetPropertyTag.class);
    private static final long serialVersionUID = -1945089681840552408L;
    private transient ValueMap properties;
    private String key;
    private transient Object defaultValue;
    private String returnClass;
    private String var;

    @Override
    public int doEndTag() {
        log.trace("doEndTag");
        Class<?> value = null;
        if (this.properties != null) {
            if (this.defaultValue != null) {
                value = this.properties.get(this.key, this.defaultValue);
            } else if (this.returnClass != null && this.returnClass.trim().length() != 0) {
                ClassLoader classLoader = this.getClassLoader();
                log.debug("Returning value as type: {}", (Object)this.returnClass);
                try {
                    Class<?> clazz = classLoader.loadClass(this.returnClass);
                    value = this.properties.get(this.key, clazz);
                }
                catch (ClassNotFoundException cnfe) {
                    log.warn("Unable to find class: " + this.returnClass, cnfe);
                }
            } else {
                value = this.properties.get(this.key);
            }
        } else if (this.defaultValue != null) {
            value = this.defaultValue;
        }
        log.debug("Saving {} to variable {}", (Object)value, (Object)this.var);
        this.pageContext.setAttribute(this.var, value);
        return 6;
    }

    protected ClassLoader getClassLoader() {
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        DynamicClassLoaderManager dynamicClassLoaderManager = scriptHelper.getService(DynamicClassLoaderManager.class);
        return dynamicClassLoaderManager.getDynamicClassLoader();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public String getReturnClass() {
        return this.returnClass;
    }

    public String getVar() {
        return this.var;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setProperties(ValueMap properties) {
        this.properties = properties;
    }

    public void setReturnClass(String returnClass) {
        this.returnClass = returnClass;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

