/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.scripting.jsp.taglib.SlingFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetResourceTag
extends TagSupport {
    private static final Logger log = LoggerFactory.getLogger(GetResourceTag.class);
    private static final long serialVersionUID = -1945089681840552408L;
    private transient Resource base;
    private String path;
    private String var;

    @Override
    public int doEndTag() {
        log.trace("doEndTag");
        ResourceResolver resolver = this.getResourceResolver();
        Resource resource = null;
        if (this.path.startsWith("/")) {
            log.debug("Retrieving resource at absolute path: {}", (Object)this.path);
            resource = resolver.getResource(this.path);
        } else if (this.base != null) {
            log.debug("Retrieving resource at relative path: {} to resource {}", (Object)this.path, (Object)this.base.getPath());
            resource = resolver.getResource(this.base, this.path);
        } else {
            log.warn("Unable to retrieve resource at relative path {}, no base resource specified", (Object)this.path);
        }
        log.debug("Saving {} to variable {}", (Object)resource, (Object)this.var);
        this.pageContext.setAttribute(this.var, resource);
        return 6;
    }

    protected ResourceResolver getResourceResolver() {
        return SlingFunctions.getResourceResolver(this.pageContext);
    }

    public Resource getBase() {
        return this.base;
    }

    public String getPath() {
        return this.path;
    }

    public String getVar() {
        return this.var;
    }

    public void setBase(Resource base) {
        this.base = base;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

