/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping;

import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapping
implements Comparable<Mapping> {
    public static String SERVICENAME = ".serviceName";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String serviceName;
    private final String subServiceName;
    private final String userName;
    private final Set<String> principalNames;
    private final String identity;

    public Mapping(String spec) {
        int colon = spec.indexOf(58);
        int equals = spec.indexOf(61);
        if (colon == 0 || equals <= 0) {
            throw new IllegalArgumentException("serviceName is required");
        }
        if (equals == spec.length() - 1) {
            throw new IllegalArgumentException("userName or principalNames is required");
        }
        if (colon + 1 == equals) {
            throw new IllegalArgumentException("serviceInfo must not be empty");
        }
        if (colon < 0 || colon > equals) {
            this.serviceName = spec.substring(0, equals);
            this.subServiceName = null;
            this.identity = this.serviceName;
        } else {
            this.serviceName = spec.substring(0, colon);
            this.subServiceName = spec.substring(colon + 1, equals);
            this.identity = this.serviceName + "-" + this.subServiceName;
        }
        String s = spec.substring(equals + 1);
        if (s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
            this.userName = null;
            this.principalNames = Mapping.extractPrincipalNames(s);
        } else {
            this.userName = s;
            this.principalNames = null;
            this.log.warn("Deprecated service mapping by userId, refactor to mapping by principal names (e.g. '{}{}=[{}]').", this.serviceName, this.subServiceName == null ? "" : ":" + this.subServiceName, s);
        }
    }

    public static Set<String> extractPrincipalNames(String s) {
        String[] sArr = s.substring(1, s.length() - 1).split(",");
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String name : sArr) {
            String n = name.trim();
            if (n.isEmpty()) continue;
            set.add(n);
        }
        return set;
    }

    public String map(String serviceName, String subServiceName) {
        if (this.serviceName.equals(serviceName) && this.equals(this.subServiceName, subServiceName)) {
            return this.userName;
        }
        return null;
    }

    public Iterable<String> mapPrincipals(String serviceName, String subServiceName) {
        if (this.serviceName.equals(serviceName) && this.equals(this.subServiceName, subServiceName)) {
            return this.principalNames;
        }
        return null;
    }

    private boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public String toString() {
        String name = this.userName != null ? "userName=" + this.userName : "principleNames" + this.principalNames.toString();
        return "Mapping [serviceName=" + this.serviceName + ", subServiceName=" + this.subServiceName + ", " + name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSubServiceName() {
        return this.subServiceName;
    }

    @Override
    public int compareTo(Mapping o) {
        if (o == null) {
            return -1;
        }
        return this.identity.compareTo(o.identity);
    }
}

