/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.apache.poi.xssf.usermodel.helpers.HeaderFooterHelper;
import org.apache.tika.exception.RuntimeSAXException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.TikaExcelDataFormatter;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLTikaBodyPartHandler;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShape;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTShapeNonVisual;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFExcelExtractorDecorator
extends AbstractOOXMLExtractor {
    protected static HeaderFooterHelper hfHelper = new HeaderFooterHelper();
    protected final DataFormatter formatter;
    protected final List<PackagePart> sheetParts = new ArrayList<PackagePart>();
    protected final Map<String, String> drawingHyperlinks = new HashMap<String, String>();
    protected Metadata metadata;
    protected ParseContext parseContext;

    public XSSFExcelExtractorDecorator(ParseContext context, POIXMLTextExtractor extractor, Locale locale) {
        super(context, extractor);
        this.parseContext = context;
        this.extractor = (XSSFEventBasedExcelExtractor)extractor;
        this.configureExtractor(this.extractor, locale);
        this.formatter = locale == null ? new TikaExcelDataFormatter() : new TikaExcelDataFormatter(locale);
        OfficeParserConfig officeParserConfig = context.get(OfficeParserConfig.class);
        if (officeParserConfig != null) {
            ((TikaExcelDataFormatter)this.formatter).setDateFormatOverride(officeParserConfig.getDateFormatOverride());
        }
    }

    protected void configureExtractor(POIXMLTextExtractor extractor, Locale locale) {
        ((XSSFEventBasedExcelExtractor)extractor).setIncludeTextBoxes(this.config.getIncludeShapeBasedContent());
        ((XSSFEventBasedExcelExtractor)extractor).setFormulasNotResults(false);
        ((XSSFEventBasedExcelExtractor)extractor).setLocale(locale);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        this.metadata = metadata;
        this.parseContext = context;
        metadata.set("protected", "false");
        super.getXHTML(handler, metadata, context);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        ReadOnlySharedStringsTable strings;
        XSSFReader.SheetIterator iter;
        StylesTable styles;
        XSSFReader xssfReader;
        OPCPackage container = this.extractor.getPackage();
        try {
            xssfReader = new XSSFReader(container);
            styles = xssfReader.getStylesTable();
            iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            strings = new ReadOnlySharedStringsTable(container, this.config.getConcatenatePhoneticRuns());
        }
        catch (InvalidFormatException e) {
            throw new XmlException(e);
        }
        catch (OpenXML4JException oe) {
            throw new XmlException(oe);
        }
        while (iter.hasNext()) {
            SheetTextAsHTML sheetExtractor = new SheetTextAsHTML(this.config, xhtml);
            PackagePart sheetPart = null;
            try (Iterator<String> stream = iter.next();){
                sheetPart = iter.getSheetPart();
                this.addDrawingHyperLinks(sheetPart);
                this.sheetParts.add(sheetPart);
                Comments comments = iter.getSheetComments();
                xhtml.startElement("div");
                xhtml.element("h1", iter.getSheetName());
                xhtml.startElement("table");
                xhtml.startElement("tbody");
                this.processSheet(sheetExtractor, comments, styles, strings, (InputStream)((Object)stream));
            }
            xhtml.endElement("tbody");
            xhtml.endElement("table");
            for (String header : sheetExtractor.headers) {
                this.extractHeaderFooter(header, xhtml);
            }
            for (String footer : sheetExtractor.footers) {
                this.extractHeaderFooter(footer, xhtml);
            }
            if (this.config.getIncludeShapeBasedContent()) {
                List<XSSFShape> shapes = iter.getShapes();
                this.processShapes(shapes, xhtml);
            }
            this.extractHyperLinks(sheetPart, xhtml);
            xhtml.endElement("div");
        }
        try (InputStream wbData = xssfReader.getWorkbookData();){
            XMLReaderUtils.parseSAX(wbData, new OfflineContentHandler(new AbsPathExtractorHandler()), this.parseContext);
        }
        catch (InvalidFormatException | TikaException exception) {
            // empty catch block
        }
    }

    protected void addDrawingHyperLinks(PackagePart sheetPart) {
        try {
            for (PackageRelationship rel : sheetPart.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation())) {
                if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                PackagePartName relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                PackagePart part = rel.getPackage().getPart(relName);
                if (part == null) continue;
                for (PackageRelationship drawRel : part.getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation())) {
                    this.drawingHyperlinks.put(drawRel.getId(), drawRel.getTargetURI().toString());
                }
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    protected void extractHyperLinks(PackagePart sheetPart, XHTMLContentHandler xhtml) throws SAXException {
        try {
            for (PackageRelationship rel : sheetPart.getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation())) {
                xhtml.startElement("a", "href", rel.getTargetURI().toString());
                xhtml.characters(rel.getTargetURI().toString());
                xhtml.endElement("a");
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    protected void extractHeaderFooter(String hf, XHTMLContentHandler xhtml) throws SAXException {
        String content = ExcelExtractor._extractHeaderFooter(new HeaderFooterFromString(hf));
        if (content.length() > 0) {
            xhtml.element("p", content);
        }
    }

    protected void processShapes(List<XSSFShape> shapes, XHTMLContentHandler xhtml) throws SAXException {
        if (shapes == null) {
            return;
        }
        HashSet<String> seenParentDrawings = new HashSet<String>();
        for (XSSFShape shape : shapes) {
            XSSFDrawing parentDrawing;
            if (shape instanceof XSSFSimpleShape) {
                String sText = ((XSSFSimpleShape)shape).getText();
                if (sText != null && sText.length() > 0) {
                    xhtml.element("p", sText);
                }
                this.extractHyperLinksFromShape(((XSSFSimpleShape)shape).getCTShape(), xhtml);
            }
            if ((parentDrawing = shape.getDrawing()) == null) continue;
            if (!seenParentDrawings.contains(parentDrawing.getPackagePart().getPartName().toString())) {
                this.handleGeneralTextContainingPart("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData", "diagram-data", parentDrawing.getPackagePart(), this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
                this.handleGeneralTextContainingPart(XSSFRelation.CHART.getRelation(), "chart", parentDrawing.getPackagePart(), this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
            }
            seenParentDrawings.add(parentDrawing.getPackagePart().getPartName().toString());
        }
    }

    private void extractHyperLinksFromShape(CTShape ctShape, XHTMLContentHandler xhtml) throws SAXException {
        CTHyperlink ctHoverHyperlink;
        if (ctShape == null) {
            return;
        }
        CTShapeNonVisual nvSpPR = ctShape.getNvSpPr();
        if (nvSpPR == null) {
            return;
        }
        CTNonVisualDrawingProps cNvPr = nvSpPR.getCNvPr();
        if (cNvPr == null) {
            return;
        }
        CTHyperlink ctHyperlink = cNvPr.getHlinkClick();
        if (ctHyperlink == null) {
            return;
        }
        String url = this.drawingHyperlinks.get(ctHyperlink.getId());
        if (url != null) {
            xhtml.startElement("a", "href", url);
            xhtml.characters(url);
            xhtml.endElement("a");
        }
        if ((ctHoverHyperlink = cNvPr.getHlinkHover()) == null) {
            return;
        }
        url = this.drawingHyperlinks.get(ctHoverHyperlink.getId());
        if (url != null) {
            xhtml.startElement("a", "href", url);
            xhtml.characters(url);
            xhtml.endElement("a");
        }
    }

    public void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, Comments comments, StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        try {
            XSSFSheetInterestingPartsCapturer handler = new XSSFSheetInterestingPartsCapturer(new XSSFSheetXMLHandler(styles, comments, strings, sheetContentsExtractor, this.formatter, false));
            XMLReaderUtils.parseSAX(sheetInputStream, handler, this.parseContext);
            sheetInputStream.close();
            if (handler.hasProtection) {
                this.metadata.set("protected", "true");
            }
        }
        catch (TikaException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        for (PackagePart part : this.sheetParts) {
            parts.add(part);
            try {
                PackagePartName relName;
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
                for (PackageRelationship rel : part.getRelationshipsByType(XSSFRelation.VML_DRAWINGS.getRelation())) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Broken OOXML file", e);
            }
        }
        for (PackagePart part : this.extractor.getPackage().getPartsByRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument")) {
            parts.add(part);
        }
        return parts;
    }

    private class AbsPathExtractorHandler
    extends DefaultHandler {
        private AbsPathExtractorHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("absPath".equals(localName)) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String n = atts.getLocalName(i);
                    if (!"url".equals(n)) continue;
                    String url = atts.getValue(i);
                    XSSFExcelExtractorDecorator.this.metadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, url);
                    return;
                }
            }
        }
    }

    protected static class XSSFSheetInterestingPartsCapturer
    extends DefaultHandler {
        private ContentHandler delegate;
        private boolean hasProtection = false;

        protected XSSFSheetInterestingPartsCapturer(ContentHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("sheetProtection".equals(qName)) {
                this.hasProtection = true;
            }
            this.delegate.startElement(uri, localName, qName, atts);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.delegate.characters(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            this.delegate.endDocument();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.delegate.endElement(uri, localName, qName);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.delegate.endPrefixMapping(prefix);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.delegate.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.delegate.processingInstruction(target, data);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.delegate.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.delegate.skippedEntity(name);
        }

        @Override
        public void startDocument() throws SAXException {
            this.delegate.startDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.delegate.startPrefixMapping(prefix, uri);
        }
    }

    protected static class HeaderFooterFromString
    implements HeaderFooter {
        private String text;

        protected HeaderFooterFromString(String text) {
            this.text = text;
        }

        @Override
        public String getCenter() {
            return hfHelper.getCenterSection(this.text);
        }

        @Override
        public void setCenter(String paramString) {
        }

        @Override
        public String getLeft() {
            return hfHelper.getLeftSection(this.text);
        }

        @Override
        public void setLeft(String paramString) {
        }

        @Override
        public String getRight() {
            return hfHelper.getRightSection(this.text);
        }

        @Override
        public void setRight(String paramString) {
        }
    }

    protected static class SheetTextAsHTML
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private XHTMLContentHandler xhtml;
        private final boolean includeHeadersFooters;
        private final boolean includeMissingRows;
        protected List<String> headers;
        protected List<String> footers;
        private int lastSeenRow = -1;
        private int lastSeenCol = -1;

        protected SheetTextAsHTML(OfficeParserConfig config, XHTMLContentHandler xhtml) {
            this.includeHeadersFooters = config.getIncludeHeadersAndFooters();
            this.includeMissingRows = config.getIncludeMissingRows();
            this.xhtml = xhtml;
            this.headers = new ArrayList<String>();
            this.footers = new ArrayList<String>();
        }

        @Override
        public void startRow(int rowNum) throws RuntimeSAXException {
            try {
                if (this.includeMissingRows && rowNum > this.lastSeenRow + 1) {
                    for (int rn = this.lastSeenRow + 1; rn < rowNum; ++rn) {
                        this.xhtml.startElement("tr");
                        this.xhtml.startElement("td");
                        this.xhtml.endElement("td");
                        this.xhtml.endElement("tr");
                    }
                }
                this.xhtml.startElement("tr");
                this.lastSeenCol = -1;
            }
            catch (SAXException e) {
                throw new RuntimeSAXException(e);
            }
        }

        @Override
        public void endRow(int rowNum) {
            try {
                this.xhtml.endElement("tr");
            }
            catch (SAXException e) {
                throw new RuntimeSAXException(e);
            }
        }

        @Override
        public void cell(String cellRef, String formattedValue, XSSFComment comment) {
            try {
                int colNum = cellRef == null ? this.lastSeenCol + 1 : (int)new CellReference(cellRef).getCol();
                for (int cn = this.lastSeenCol + 1; cn < colNum; ++cn) {
                    this.xhtml.startElement("td");
                    this.xhtml.endElement("td");
                }
                this.lastSeenCol = colNum;
                this.xhtml.startElement("td");
                if (formattedValue != null) {
                    this.xhtml.characters(formattedValue);
                }
                if (comment != null) {
                    this.xhtml.startElement("br");
                    this.xhtml.endElement("br");
                    this.xhtml.characters(comment.getAuthor());
                    this.xhtml.characters(": ");
                    this.xhtml.characters(comment.getString().getString());
                }
                this.xhtml.endElement("td");
            }
            catch (SAXException e) {
                throw new RuntimeSAXException(e);
            }
        }

        @Override
        public void headerFooter(String text, boolean isHeader, String tagName) {
            if (!this.includeHeadersFooters) {
                return;
            }
            if (isHeader) {
                this.headers.add(text);
            } else {
                this.footers.add(text);
            }
        }
    }
}

