/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.odf.FlatOpenDocumentMacroHandler;
import org.apache.tika.parser.odf.NSNormalizerContentHandler;
import org.apache.tika.parser.odf.OpenDocumentBodyHandler;
import org.apache.tika.parser.odf.OpenDocumentMetaParser;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FlatOpenDocumentParser
extends AbstractParser {
    private static final long serialVersionUID = -8739250869531737584L;
    static final MediaType FLAT_OD = MediaType.application("vnd.oasis.opendocument.tika.flat.document");
    static final MediaType FLAT_ODT = MediaType.application("vnd.oasis.opendocument.flat.text");
    static final MediaType FLAT_ODP = MediaType.application("vnd.oasis.opendocument.flat.presentation");
    static final MediaType FLAT_ODS = MediaType.application("vnd.oasis.opendocument.flat.spreadsheet");
    static final MediaType ODT = MediaType.application("vnd.oasis.opendocument.text");
    static final MediaType ODP = MediaType.application("vnd.oasis.opendocument.presentation");
    static final MediaType ODS = MediaType.application("vnd.oasis.opendocument.spreadsheet");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(FLAT_OD, FLAT_ODT, FLAT_ODP, FLAT_ODS)));
    private boolean extractMacros = false;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            ContentHandler fodHandler = this.getContentHandler(xhtml, metadata, context);
            XMLReaderUtils.parseSAX(new CloseShieldInputStream(stream), new OfflineContentHandler(new EmbeddedContentHandler(fodHandler)), context);
            MediaType detected = ((FlatOpenDocumentParserHandler)fodHandler).getDetectedType();
            if (detected != null) {
                metadata.set("Content-Type", detected.toString());
            }
        }
        finally {
            xhtml.endDocument();
        }
    }

    @Field
    public void setExtractMacros(boolean extractMacros) {
        this.extractMacros = extractMacros;
    }

    private ContentHandler getContentHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
        return new FlatOpenDocumentParserHandler(handler, metadata, context, this.extractMacros);
    }

    private static class FlatOpenDocumentParserHandler
    extends ContentHandlerDecorator {
        private static final String META = "meta";
        private static final String BODY = "body";
        private static final String SCRIPTS = "scripts";
        private static final String DOCUMENT = "document";
        private final ContentHandler defaultHandler;
        private final ContentHandler bodyHandler;
        private final ContentHandler metadataHandler;
        private final ContentHandler macroHandler;
        private ContentHandler currentHandler;
        private MediaType detectedType;
        private final boolean extractMacros;

        private FlatOpenDocumentParserHandler(ContentHandler baseHandler, Metadata metadata, ParseContext parseContext, boolean extractMacros) {
            this.currentHandler = this.defaultHandler = new DefaultHandler();
            this.detectedType = null;
            this.extractMacros = extractMacros;
            this.bodyHandler = new OfflineContentHandler(new OpenDocumentBodyHandler((ContentHandler)new NSNormalizerContentHandler(baseHandler), parseContext));
            this.metadataHandler = new OfflineContentHandler(new NSNormalizerContentHandler(OpenDocumentMetaParser.getContentHandler(metadata, parseContext, new ContentHandler[0])));
            this.macroHandler = extractMacros ? new OfflineContentHandler(new FlatOpenDocumentMacroHandler(baseHandler, parseContext)) : null;
        }

        MediaType getDetectedType() {
            return this.detectedType;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            String mime;
            if (META.equals(localName)) {
                this.currentHandler = this.metadataHandler;
            } else if (BODY.equals(localName)) {
                this.currentHandler = this.bodyHandler;
            } else if (this.extractMacros && SCRIPTS.equals(localName)) {
                this.currentHandler = this.macroHandler;
            }
            if (DOCUMENT.equals(localName) && (mime = XMLReaderUtils.getAttrValue("mimetype", attrs)) != null) {
                if (mime.equals(ODT.toString())) {
                    this.detectedType = FLAT_ODT;
                } else if (mime.equals(ODP.toString())) {
                    this.detectedType = FLAT_ODP;
                } else if (mime.equals(ODS.toString())) {
                    this.detectedType = FLAT_ODS;
                }
            }
            this.currentHandler.startElement(namespaceURI, localName, qName, attrs);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentHandler.characters(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (META.equals(localName)) {
                this.currentHandler = this.defaultHandler;
            } else if (BODY.equals(localName)) {
                this.currentHandler = this.defaultHandler;
            } else if (this.extractMacros && SCRIPTS.equals(localName)) {
                this.currentHandler = this.defaultHandler;
            }
            this.currentHandler.endElement(namespaceURI, localName, qName);
        }
    }
}

