/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.LeakDetector;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated(since="2021-05-27")
public class LeakTrackingConnectionPool
extends DuplexConnectionPool {
    private static final Logger LOG = Log.getLogger(LeakTrackingConnectionPool.class);
    private final LeakDetector<Connection> leakDetector = new LeakDetector<Connection>(){

        @Override
        protected void leaked(LeakDetector.LeakInfo leakInfo) {
            LeakTrackingConnectionPool.this.leaked(leakInfo);
        }
    };

    public LeakTrackingConnectionPool(Destination destination, int maxConnections, Callback requester) {
        super((HttpDestination)destination, maxConnections, requester);
        this.addBean(this.leakDetector);
    }

    @Override
    public void close() {
        LifeCycle.stop(this);
        super.close();
    }

    @Override
    protected void acquired(Connection connection) {
        if (!this.leakDetector.acquired(connection)) {
            LOG.info("Connection {}@{} not tracked", connection, this.leakDetector.id(connection));
        }
    }

    @Override
    protected void released(Connection connection) {
        if (!this.leakDetector.released(connection)) {
            LOG.info("Connection {}@{} released but not acquired", connection, this.leakDetector.id(connection));
        }
    }

    protected void leaked(LeakDetector.LeakInfo leakInfo) {
        LOG.info("Connection " + leakInfo.getResourceDescription() + " leaked at:", leakInfo.getStackFrames());
    }
}

