/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.rngom.rngparser.digested;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.kohsuke.rngom.rngparser.digested.DAnnotation;
import org.kohsuke.rngom.rngparser.digested.DAttributePattern;
import org.kohsuke.rngom.rngparser.digested.DChoicePattern;
import org.kohsuke.rngom.rngparser.digested.DDataPattern;
import org.kohsuke.rngom.rngparser.digested.DDefine;
import org.kohsuke.rngom.rngparser.digested.DElementPattern;
import org.kohsuke.rngom.rngparser.digested.DEmptyPattern;
import org.kohsuke.rngom.rngparser.digested.DGrammarPattern;
import org.kohsuke.rngom.rngparser.digested.DGroupPattern;
import org.kohsuke.rngom.rngparser.digested.DInterleavePattern;
import org.kohsuke.rngom.rngparser.digested.DListPattern;
import org.kohsuke.rngom.rngparser.digested.DMixedPattern;
import org.kohsuke.rngom.rngparser.digested.DNotAllowedPattern;
import org.kohsuke.rngom.rngparser.digested.DOMPrinter;
import org.kohsuke.rngom.rngparser.digested.DOneOrMorePattern;
import org.kohsuke.rngom.rngparser.digested.DOptionalPattern;
import org.kohsuke.rngom.rngparser.digested.DPattern;
import org.kohsuke.rngom.rngparser.digested.DPatternVisitor;
import org.kohsuke.rngom.rngparser.digested.DRefPattern;
import org.kohsuke.rngom.rngparser.digested.DTextPattern;
import org.kohsuke.rngom.rngparser.digested.DValuePattern;
import org.kohsuke.rngom.rngparser.digested.DZeroOrMorePattern;
import org.kohsuke.rngom.rngparser.nc.NameClass;
import org.kohsuke.rngom.rngparser.nc.NameClassVisitor;
import org.kohsuke.rngom.rngparser.nc.SimpleNameClass;
import org.w3c.dom.Node;

public class DXMLPrinter {
    protected XMLStreamWriter out;
    protected String indentStep = "\t";
    protected String newLine = System.getProperty("line.separator");
    protected int indent;
    protected boolean afterEnd = false;
    protected DXMLPrinterVisitor visitor;
    protected NameClassXMLPrinterVisitor ncVisitor;
    protected DOMPrinter domPrinter;

    public DXMLPrinter(XMLStreamWriter out) {
        this.out = out;
        this.visitor = new DXMLPrinterVisitor();
        this.ncVisitor = new NameClassXMLPrinterVisitor();
        this.domPrinter = new DOMPrinter(out);
    }

    public void printDocument(DGrammarPattern grammar) throws XMLStreamException {
        try {
            this.visitor.startDocument();
            this.visitor.on(grammar);
            this.visitor.endDocument();
        }
        catch (XMLWriterException e) {
            throw (XMLStreamException)e.getCause();
        }
    }

    public void print(DPattern pattern) throws XMLStreamException {
        try {
            pattern.accept(this.visitor);
        }
        catch (XMLWriterException e) {
            throw (XMLStreamException)e.getCause();
        }
    }

    public void print(NameClass nc) throws XMLStreamException {
        try {
            nc.accept(this.ncVisitor);
        }
        catch (XMLWriterException e) {
            throw (XMLStreamException)e.getCause();
        }
    }

    public void print(Node node) throws XMLStreamException {
        this.domPrinter.print(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NameClassXMLPrinterVisitor
    extends XMLWriter
    implements NameClassVisitor<Void> {
        protected NameClassXMLPrinterVisitor() {
        }

        @Override
        public Void visitChoice(NameClass nc1, NameClass nc2) {
            this.start("choice");
            nc1.accept(this);
            nc2.accept(this);
            this.end();
            return null;
        }

        @Override
        public Void visitNsName(String ns) {
            this.start("nsName");
            this.attr("ns", ns);
            this.end();
            return null;
        }

        @Override
        public Void visitNsNameExcept(String ns, NameClass nc) {
            this.start("nsName");
            this.attr("ns", ns);
            this.start("except");
            nc.accept(this);
            this.end();
            this.end();
            return null;
        }

        @Override
        public Void visitAnyName() {
            this.start("anyName");
            this.end();
            return null;
        }

        @Override
        public Void visitAnyNameExcept(NameClass nc) {
            this.start("anyName");
            this.start("except");
            nc.accept(this);
            this.end();
            this.end();
            return null;
        }

        @Override
        public Void visitName(QName name) {
            this.start("name");
            if (!name.getPrefix().equals("")) {
                this.body(name.getPrefix() + ":");
            }
            this.body(name.getLocalPart());
            this.end();
            return null;
        }

        @Override
        public Void visitNull() {
            throw new UnsupportedOperationException("visitNull");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DXMLPrinterVisitor
    extends XMLWriter
    implements DPatternVisitor<Void> {
        protected DXMLPrinterVisitor() {
        }

        protected void on(DPattern p) {
            p.accept(this);
        }

        protected void unwrapGroup(DPattern p) {
            if (p instanceof DGroupPattern && p.getAnnotation() == DAnnotation.EMPTY) {
                for (DPattern d : (DGroupPattern)p) {
                    this.on(d);
                }
            } else {
                this.on(p);
            }
        }

        protected void unwrapChoice(DPattern p) {
            if (p instanceof DChoicePattern && p.getAnnotation() == DAnnotation.EMPTY) {
                for (DPattern d : (DChoicePattern)p) {
                    this.on(d);
                }
            } else {
                this.on(p);
            }
        }

        protected void on(NameClass nc) {
            if (nc instanceof SimpleNameClass) {
                QName qname = ((SimpleNameClass)nc).name;
                String name = qname.getLocalPart();
                if (!qname.getPrefix().equals("")) {
                    name = qname.getPrefix() + ":";
                }
                this.attr("name", name);
            } else {
                nc.accept(DXMLPrinter.this.ncVisitor);
            }
        }

        protected void on(DAnnotation ann) {
        }

        @Override
        public Void onAttribute(DAttributePattern p) {
            this.start("attribute");
            this.on(p.getName());
            this.on(p.getAnnotation());
            DPattern child = p.getChild();
            if (!(child instanceof DTextPattern)) {
                this.on(p.getChild());
            }
            this.end();
            return null;
        }

        @Override
        public Void onChoice(DChoicePattern p) {
            this.start("choice");
            this.on(p.getAnnotation());
            for (DPattern d : p) {
                this.on(d);
            }
            this.end();
            return null;
        }

        @Override
        public Void onData(DDataPattern p) {
            List<DDataPattern.Param> params = p.getParams();
            DPattern except = p.getExcept();
            this.start("data");
            this.attr("datatypeLibrary", p.getDatatypeLibrary());
            this.attr("type", p.getType());
            this.on(p.getAnnotation());
            for (DDataPattern.Param param : params) {
                this.start("param");
                this.attr("ns", param.getNs());
                this.attr("name", param.getName());
                this.body(param.getValue());
                this.end();
            }
            if (except != null) {
                this.start("except");
                this.unwrapChoice(except);
                this.end();
            }
            this.end();
            return null;
        }

        @Override
        public Void onElement(DElementPattern p) {
            this.start("element");
            this.on(p.getName());
            this.on(p.getAnnotation());
            this.unwrapGroup(p.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onEmpty(DEmptyPattern p) {
            this.start("empty");
            this.on(p.getAnnotation());
            this.end();
            return null;
        }

        @Override
        public Void onGrammar(DGrammarPattern p) {
            this.start("grammar");
            this.ns(null, "http://relaxng.org/ns/structure/1.0");
            this.on(p.getAnnotation());
            this.start("start");
            this.on(p.getStart());
            this.end();
            for (DDefine d : p) {
                this.start("define");
                this.attr("name", d.getName());
                this.on(d.getAnnotation());
                this.unwrapGroup(d.getPattern());
                this.end();
            }
            this.end();
            return null;
        }

        @Override
        public Void onGroup(DGroupPattern p) {
            this.start("group");
            this.on(p.getAnnotation());
            for (DPattern d : p) {
                this.on(d);
            }
            this.end();
            return null;
        }

        @Override
        public Void onInterleave(DInterleavePattern p) {
            this.start("interleave");
            this.on(p.getAnnotation());
            for (DPattern d : p) {
                this.on(d);
            }
            this.end();
            return null;
        }

        @Override
        public Void onList(DListPattern p) {
            this.start("list");
            this.on(p.getAnnotation());
            this.unwrapGroup(p.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onMixed(DMixedPattern p) {
            this.start("mixed");
            this.on(p.getAnnotation());
            this.unwrapGroup(p.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onNotAllowed(DNotAllowedPattern p) {
            this.start("notAllowed");
            this.on(p.getAnnotation());
            this.end();
            return null;
        }

        @Override
        public Void onOneOrMore(DOneOrMorePattern p) {
            this.start("oneOrMore");
            this.on(p.getAnnotation());
            this.unwrapGroup(p.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onOptional(DOptionalPattern p) {
            this.start("optional");
            this.on(p.getAnnotation());
            this.unwrapGroup(p.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onRef(DRefPattern p) {
            this.start("ref");
            this.attr("name", p.getName());
            this.on(p.getAnnotation());
            this.end();
            return null;
        }

        @Override
        public Void onText(DTextPattern p) {
            this.start("text");
            this.on(p.getAnnotation());
            this.end();
            return null;
        }

        @Override
        public Void onValue(DValuePattern p) {
            this.start("value");
            if (!p.getNs().equals("")) {
                this.attr("ns", p.getNs());
            }
            this.attr("datatypeLibrary", p.getDatatypeLibrary());
            this.attr("type", p.getType());
            this.on(p.getAnnotation());
            this.body(p.getValue());
            this.end();
            return null;
        }

        @Override
        public Void onZeroOrMore(DZeroOrMorePattern p) {
            this.start("zeroOrMore");
            this.on(p.getAnnotation());
            this.unwrapGroup(p.getChild());
            this.end();
            return null;
        }
    }

    protected class XMLWriter {
        protected XMLWriter() {
        }

        protected void newLine() {
            try {
                DXMLPrinter.this.out.writeCharacters(DXMLPrinter.this.newLine);
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        protected void indent() {
            try {
                for (int i = 0; i < DXMLPrinter.this.indent; ++i) {
                    DXMLPrinter.this.out.writeCharacters(DXMLPrinter.this.indentStep);
                }
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        public void startDocument() {
            try {
                DXMLPrinter.this.out.writeStartDocument();
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        public void endDocument() {
            try {
                DXMLPrinter.this.out.writeEndDocument();
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        public final void start(String element) {
            try {
                this.newLine();
                this.indent();
                DXMLPrinter.this.out.writeStartElement(element);
                ++DXMLPrinter.this.indent;
                DXMLPrinter.this.afterEnd = false;
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        public void end() {
            try {
                --DXMLPrinter.this.indent;
                if (DXMLPrinter.this.afterEnd) {
                    this.newLine();
                    this.indent();
                }
                DXMLPrinter.this.out.writeEndElement();
                DXMLPrinter.this.afterEnd = true;
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        public void attr(String prefix, String ns, String name, String value) {
            try {
                DXMLPrinter.this.out.writeAttribute(prefix, ns, name, value);
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        public void attr(String name, String value) {
            try {
                DXMLPrinter.this.out.writeAttribute(name, value);
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        public void ns(String prefix, String uri) {
            try {
                DXMLPrinter.this.out.writeNamespace(prefix, uri);
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }

        public void body(String text) {
            try {
                DXMLPrinter.this.out.writeCharacters(text);
                DXMLPrinter.this.afterEnd = false;
            }
            catch (XMLStreamException e) {
                throw new XMLWriterException((Throwable)e);
            }
        }
    }

    protected class XMLWriterException
    extends RuntimeException {
        protected XMLWriterException(Throwable cause) {
            super(cause);
        }
    }
}

