/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.adobe.cq.xf.social;

import com.adobe.cq.xf.ExperienceFragmentVariation;

/**
 * Model object that represents a social media variation that can be pushed to or interact with social media networks.
 * Ex: Facebook, Pinterest, Twitter
 */
public interface ExperienceFragmentSocialVariation extends ExperienceFragmentVariation {

    /**
     * Get the defining text of the SM variation
     * @return Text
     */
    String getText();

    /**
     * Return defining image path of the SM variation
     * @return Image path
     */
    String getImagePath();

}