/*
*
*	File: SubsetSimpleType1.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2007 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/
package com.adobe.fontengine.font;

public class SubsetSimpleType1 {
	private final String[] mGlyphNames;	// Glyphname strings for the codepoint at index

	/**
	 * Prepare a subset object for a simple Type1 (CFF) font. This consists of
	 * an array of Java Strings for the subset glyph names. The length of the
	 * array is arbitrary and null entries are ignored.
	 */
	public SubsetSimpleType1(String[] glyphNames)
	{
		mGlyphNames = glyphNames;
	}

	public String[] getGlyphNames()
	{
		return mGlyphNames;
	}
}
