/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ProviderType;

/**
 * <code>MediaLink</code>...
 */
@ProviderType
public interface MediaLink extends JsonAdaptable {

    /**
     * The IRI of the media resource being linked. A media link MUST have a url property.
     */
    String getURL();

    /**
     * A hint to the consumer about the width, in pixels, of the media resource identified by the url property. A media
     * link MAY contain a width property when the target resource is a visual media item such as an image, video or
     * embeddable HTML page.
     */
    int getWidth();

    /**
     * A hint to the consumer about the height, in pixels, of the media resource identified by the url property. A media
     * link MAY contain a height property when the target resource is a visual media item such as an image,
     * video or embeddable HTML page.
     */
    int getHeight();

    /**
     * A hint to the consumer about the length, in seconds, of the media resource identified by the url property.
     * A media link MAY contain a "duration" property when the target resource is a time-based media item such as an audio or video.
     */
    int getDuration();

    /**
     * Returns a read-only value map of the raw properties underlying this media link.
     */
    ValueMap getProperties();

    /**
     * Returns a copy of this activity that is mutable. If this instance is already mutable <code>this</code> is returned.
     * @return a mutable copy of this activity.
     */
    MutableMediaLink getMutableMediaLink();
}