/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec;

import com.adobe.granite.workflow.HasMetaData;

/**
 * A <code>WorkflowData</code> instance "carries" the data pushed through the
 * {@link Workflow}.
 */
public interface WorkflowData extends HasMetaData {
	/**
	 * Getter for the payload of the <code>WorkflowData</code>.
	 * 
	 * @return The payload of the <code>WorkflowData</code>.
	 */
	Object getPayload();

	/**
	 * Getter for the type of payload of the <code>WorkflowData</code>.
	 * 
	 * @return The type of payload of the <code>WorkflowData</code>.
	 */
	String getPayloadType();
}
