/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * This class contains all the script functionality associated with the
 * NodeList class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class NodeListScript extends ListBaseScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ListBaseScript.moScriptTable,
		"nodeList",
		null,
		new ScriptFuncObj[] {
			new ScriptFuncObj(NodeListScript.class, "namedItem", "namedItem", Arg.OBJECT,
				new int[] { Arg.STRING /*, XFA_IS_TREELIST_NAMEDITEM_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TREELIST_NAMEDITEM_DESC, XFA_IS_TREELIST_NAMEDITEM_RET, null*/, 0)
		}
	);

	/**
	 * Static method for invoking functions in the script interface
	 */
	public static void namedItem(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		String aName = pArgs[0].getString();
		oRetVal.setObject(((NodeList) pObj).getNamedItem(aName));
	}

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}
}
