package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

abstract class FrameHelper extends FrameLineInfo {
	private static class FrameFinder extends FrameHelper {
		private final TextFrame mpoSearchFrame;

		FrameFinder (TextSparseStream poStream, TextFrame poSearchFrame) {
			super (poStream);
			mpoSearchFrame = poSearchFrame;
		}

		protected boolean processOneFrame (TextFrame poFrame) {
			return poFrame != mpoSearchFrame;
		}
	}

	static final int PROCESS_LOADED_FRAMES = 0;
	static final int PROCESS_NULL_FRAMES = 1;
	static final int PROCESS_FORCE_LOAD = 2;

	private final int meProcess;
	private TextFrame mpoFrame;
	private boolean mbFrameLocked;

	FrameHelper (TextSparseStream poStream, int eProcess) {
		super (poStream);
		meProcess = eProcess;
	}

	FrameHelper (TextSparseStream poStream) {
		this (poStream, PROCESS_LOADED_FRAMES);
	}

	boolean processFrames () {
		int nFrame;
		int nFrameLimit;

		if (mbFrameLocked) {
			nFrame = getFrameIndex();
			nFrameLimit = nFrame + 1;
		} else {
			nFrame = 0;
			nFrameLimit = getStream().getFrameCount();
		}

		for (; nFrame < nFrameLimit; nFrame++) {
			setFrameIndex (nFrame);
			int nAbsLineIndex = getAbsLineIndex(); // derived class may change

			mpoFrame = getStream().getFrame (nFrame);
			boolean bSkipFrame = false;
			if (mpoFrame == null) {
				switch (meProcess) {
					case PROCESS_LOADED_FRAMES:
						bSkipFrame = true;
						break;
					case PROCESS_FORCE_LOAD:
						if (getStream().isAutoLoadSuppressed()) {
							bSkipFrame = true;
						} else {
							mpoFrame = getStream().forceFrame (nFrame);
						}
						break;
				}
			}

			if (! bSkipFrame) {
				if (! processOneFrame (mpoFrame)) {
					return false;
				}
			}

			if (mpoFrame != null) {
				setAbsLineIndex (nAbsLineIndex + mpoFrame.getLineCount());
				setOffset (getOffset().add (mpoFrame.getBMax()));
			}
		}

		mpoFrame = null;
		return finish();
	}

	TextFrame getFrame () {
		return getStream().getFrame (getFrameIndex());
	}

	DispLineWrapped getLine () {
		TextFrame poFrame = getFrame();
		if (poFrame == null) {
			return null;
		}
		if (getLineIndex() >= poFrame.getLineCount()) {
			return null;
		}
		return poFrame.getLine (getLineIndex());
	}

	boolean isFrameLocked () {
		return mbFrameLocked;
	}

	void lockFrame (TextFrame poFrame) {
		FrameFinder oFinder = new FrameFinder (getStream(), poFrame);
		boolean bFound = ! oFinder.processFrames();
		assert (bFound);
		super.copyFrom (oFinder);
	}

	protected void setFrame (TextFrame poFrame) {
		mpoFrame = poFrame;
	}

	abstract protected boolean processOneFrame (TextFrame poFrame);

	protected boolean finish () {
		return true;
	}
}
