package com.adobe.xfa.text;


/**
 * @exclude from published api.
 */

class LoadText {
	private TextStream mpoSource;
	private int mnStartMajor;
	private int mnStartMinor;
	private int mnEndMajor;
	private int mnEndMinor;
	private final TextGfxSource moGfxSource;
	private TextAttr mpoInitAttr;

	LoadText (TextStream oSource, TextGfxSource oGfxSource) {
		moGfxSource = oGfxSource;
		mpoInitAttr = null;
		TextRange oRangeAll = new TextRange (oSource, 0, Integer.MAX_VALUE);
		initialize (oRangeAll.position (TextRange.POSN_START), oRangeAll.position (TextRange.POSN_END));
	}

	LoadText (TextPosn oStart, TextPosn oEnd, TextGfxSource oGfxSource) {
		moGfxSource = oGfxSource;
		mpoInitAttr = oStart.attributePtr();
		initialize (oStart, oEnd);
	}

	int size () {
		int nSize = mnEndMajor - mnStartMajor; // number of items
		if (mnEndMinor > 0) {
			nSize++; // using part of end item ?
		}
		if (mpoInitAttr != null) {
			nSize++; // force attr at start?
		}

		return nSize;
	}

	StrItem nextItem () {
		StrItem poCopy;

		if (mpoInitAttr != null) {
			poCopy = new StrAttr (mpoInitAttr, moGfxSource, Pkg.ATTR_STATE_NORMAL);
			mpoInitAttr = null; // only once
		} else {
			StrItem poSource = mpoSource.getItem (mnStartMajor);
			int nCloneSize;

			if (mnStartMajor == mnEndMajor) {
				nCloneSize = mnEndMinor - mnStartMinor;
			} else {
				nCloneSize = poSource.count() - mnStartMinor;
			}
			poCopy = poSource.clonePart (moGfxSource, mnStartMinor, nCloneSize);
			mnStartMajor++; // advance for next time
			mnStartMinor = 0; // use beginning of next item
		}

		return poCopy;
	}

	int maxSize () {
		return mpoSource.maxSize();
	}

	boolean allowNewLines () {
		return mpoSource.allowNewLines();
	}

	private void initialize (TextPosn oStart, TextPosn oEnd) {
		mpoSource = oStart.stream();

		mnStartMajor = oStart.major();
		mnStartMinor = oStart.minor();
		mnEndMajor = oEnd.major();
		mnEndMinor = oEnd.minor();
	}
}
