package com.adobe.xfa.text;

/**
 * <p>
 * Abstract class TextCharPropIterator is used in algorithms based on
 * character classification.  Semantically, it steps over an implied
 * array of character properties and returns character properties and
 * positions in that array where such properties exist.
 * </p>
 * <p>
 * This header file provides two common implementations:
 * TextCharPropDataIterator, which handles a real array of character
 * properties, and TextCharPropCharIterator, which processes an array of
 * Unicode characters and returns properties for those characters.
 * </p>
 * <p>
 * The term "implied array" in the introductory paragraph means that a
 * particular implementation need not store a real array.  The interface
 * does use somewhat abstract index values.  The implementation can
 * assign any meaning to those values, as long as it returns the same
 * property value for each call with a given index value, and returns
 * index values in the same sequence.  Index values are assigned by the
 * implementation and need not start at zero, need not be contiguous and
 * even need not be in ascending order.
 * </p>
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public interface TextCharPropIterator {
/**
 * Return the index value corresponding to the first element in the
 * logical array.
 * @return First element's index value.  Often zero, but doesn't have to
 * be.
 */
	public int first ();

/**
 * Obtain the character properties corresponding to the current index
 * value and advance the index.
 * @param nIndex - Current index value.  The call must update this
 * parameter to represent the logical next index value.  The caller
 * should treat this as an opaque variable and must not alter it (except
 * through this interface) or infer any meaning from its value.
 * @return True if there were character properties at the given index
 * value; false if past the logical end of the array (if the immediately
 * previous call had returned properties for the last logical position
 * in the array).
 */
	public int next (int nIndex);
	public int next ();
	public int getNextIndex ();
}
