/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 * 
 * Copyright 2024 Adobe
 * All Rights Reserved.
 * 
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.commons.predicates;

import java.util.function.Predicate;

import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Predicate used to filter payload resources.
 */
@Component(
        service = Predicate.class,
        property = {
                "service.vendor=Adobe Systems Incorporated",
                "predicate.name=nosystem"
        })
public class IsNoSystemNodePredicate implements NodePredicate {

    /**
     * default logger
     */
    private final Logger log = LoggerFactory.getLogger(IsNoSystemNodePredicate.class);

    /**
     * private list of excludes.
     */
    private static final Set<String> EXCLUDES = new HashSet<String>(
            Arrays.asList("jcr:system", "rep:policy"));

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if the node's name is not jcr:system or
     *         rep:policy
     */
    public boolean test(Node node) {
        try {
            return !EXCLUDES.contains(node.getName());
        } catch (RepositoryException e) {
            log.warn("RepositoryException in evaluate()", e);
        }
        return false;
    }
}
