/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/

package com.day.cq.dam.scene7.api.model;

import java.util.List;

import org.joda.time.Instant;

/**
 * @author Jeff Hutchins
 */
public class Scene7MetadataValue {
    private final String fieldHandle;
    private final String value;
    private final Boolean boolVal;
    private final Long longVal;
    private final Double doubleVal;
    private final Instant dateVal;
    private final List<String> addTagValueArray;
    private final List<String> setTagValueArray;
    private final List<String> deleteTagValueArray;

    public Scene7MetadataValue(
            String fieldHandle, String value, Boolean boolVal, Long longVal,
            Double doubleVal, Instant dateVal, List<String> addTagValueArray,
            List<String> setTagValueArray, List<String> deleteTagValueArray) {
        this.fieldHandle = fieldHandle;
        this.value = value;
        this.boolVal = boolVal;
        this.longVal = longVal;
        this.doubleVal = doubleVal;
        this.dateVal = dateVal;
        this.addTagValueArray = addTagValueArray;
        this.setTagValueArray = setTagValueArray;
        this.deleteTagValueArray = deleteTagValueArray;
    }

    public String getFieldHandle() {
        return fieldHandle;
    }

    public String getValue() {
        return value;
    }

    public Boolean getBoolVal() {
        return boolVal;
    }

    public Long getLongVal() {
        return longVal;
    }

    public Double getDoubleVal() {
        return doubleVal;
    }

    public Instant getDateVal() {
        return dateVal;
    }

    public List<String> getAddTagValueArray() {
        return addTagValueArray;
    }

    public List<String> getSetTagValueArray() {
        return setTagValueArray;
    }

    public List<String> getDeleteTagValueArray() {
        return deleteTagValueArray;
    }
}
