/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.references;

import java.util.Objects;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class Reference {
    private final Resource source;
    private final Resource target;
    private final String type;

    public Reference(Resource source, Resource target, String type) {
        this.source = source;
        this.target = target;
        this.type = type;
    }

    public Resource getSource() {
        return this.source;
    }

    public Resource getTarget() {
        return this.target;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        return this.equalsResource(this.source, reference.source) && this.equalsResource(this.target, reference.target) && Objects.equals(this.type, reference.type);
    }

    private boolean equalsResource(Resource resource, Resource otherResource) {
        if (resource == null) {
            return otherResource == null;
        }
        return otherResource != null && resource.getPath().equals(otherResource.getPath());
    }

    public int hashCode() {
        return Objects.hash(this.source != null ? this.source.getPath() : null, this.target != null ? this.target.getPath() : null, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reference => {\n");
        sb.append("\tsource: ").append(this.getSource() != null ? this.getSource().getPath() : null).append("\n");
        sb.append("\ttarget: ").append(this.getTarget() != null ? this.getTarget().getPath() : null).append("\n");
        sb.append("\ttype: ").append(this.getType()).append("\n");
        sb.append("\tclass: ").append(this.getClass().getCanonicalName()).append("\n");
        sb.append("}\n");
        return sb.toString();
    }
}

