/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Stack;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;

public class FormData {
    private static final String ATTR_STACK = FormData.class.getName();
    @Nonnull
    private ValueMap values;
    @Nonnull
    private NameNotFoundMode mode;

    @Nonnull
    public static FormData push(@Nonnull SlingHttpServletRequest request, @Nonnull ValueMap values, @Nonnull NameNotFoundMode nameNotFoundMode) {
        Stack<FormData> stack = FormData.getStack(request);
        if (stack == null) {
            stack = new Stack();
            request.setAttribute(ATTR_STACK, stack);
        }
        FormData formData = new FormData(values, nameNotFoundMode);
        stack.push(formData);
        return formData;
    }

    @Nonnull
    public static FormData pop(@Nonnull SlingHttpServletRequest request) throws IllegalStateException {
        Stack<FormData> stack = FormData.getStack(request);
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException("Pop is called before push");
        }
        return stack.pop();
    }

    @CheckForNull
    public static FormData from(@Nonnull SlingHttpServletRequest request) {
        Stack<FormData> stack = FormData.getStack(request);
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    @CheckForNull
    private static Stack<FormData> getStack(@Nonnull SlingHttpServletRequest request) {
        return (Stack)request.getAttribute(ATTR_STACK);
    }

    FormData(@Nonnull ValueMap values, @Nonnull NameNotFoundMode mode) {
        this.values = values;
        this.mode = mode;
    }

    @Nonnull
    public ValueMap getValueMap() {
        return this.values;
    }

    @Nonnull
    public NameNotFoundMode getMode() {
        return this.mode;
    }

    @CheckForNull
    public <T> T get(@Nonnull String name, @CheckForNull T fieldValue, @Nonnull Class<T> type) {
        if (this.mode.equals((Object)NameNotFoundMode.IGNORE_FRESHNESS)) {
            if (fieldValue == null) {
                return (T)this.values.get(name, type);
            }
            return this.values.get(name, fieldValue);
        }
        if (!this.values.containsKey(name) && this.isFresh()) {
            return fieldValue;
        }
        return (T)this.values.get(name, type);
    }

    @Nonnull
    public <T> T get(@Nonnull String name, @Nonnull T fieldValue, @Nonnull T defaultValue) {
        if (this.mode.equals((Object)NameNotFoundMode.IGNORE_FRESHNESS)) {
            return this.values.get(name, fieldValue);
        }
        if (!this.values.containsKey(name) && this.isFresh()) {
            return fieldValue;
        }
        return this.values.get(name, defaultValue);
    }

    public boolean isSelected(@Nonnull String name, @CheckForNull String value, boolean isFieldOptionSelected) {
        return this.isSelected(name, value, isFieldOptionSelected, false);
    }

    public boolean isSelected(@Nonnull String name, @CheckForNull String value, boolean isFieldOptionSelected, boolean forceIgnoreFreshness) {
        String[] formValues = (String[])this.values.get(name, String[].class);
        if (formValues != null) {
            if (value == null) {
                return false;
            }
            return Arrays.asList(formValues).contains(value);
        }
        if (this.mode.equals((Object)NameNotFoundMode.IGNORE_FRESHNESS) || forceIgnoreFreshness) {
            return isFieldOptionSelected;
        }
        boolean isFresh = this.isFresh();
        if (value != null && value.isEmpty() && !isFresh) {
            return true;
        }
        return isFresh ? isFieldOptionSelected : false;
    }

    private boolean isFresh() {
        Calendar created = (Calendar)((Object)this.values.get("jcr:created", Calendar.class));
        Calendar lastModified = (Calendar)((Object)this.values.get("jcr:lastModified", Calendar.class));
        if (lastModified == null) {
            lastModified = (Calendar)((Object)this.values.get("cq:lastModified", Calendar.class));
        }
        if (created == null && lastModified == null) {
            return true;
        }
        if (created == null || lastModified == null) {
            return false;
        }
        long diff = lastModified.getTimeInMillis() - created.getTimeInMillis();
        return diff >= 0L && diff <= 5L;
    }

    public static enum NameNotFoundMode {
        CHECK_FRESHNESS,
        IGNORE_FRESHNESS;

    }
}

