/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.ds;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class ValueMapResource
extends SyntheticResource {
    @Nonnull
    private ValueMap vm;
    private Collection<Resource> children;

    public ValueMapResource(ResourceResolver resourceResolver, String path, String resourceType) {
        this(resourceResolver, path, resourceType, (ValueMap)new ValueMapDecorator(new HashMap<String, Object>()));
    }

    public ValueMapResource(ResourceResolver resourceResolver, String path, String resourceType, @Nonnull ValueMap vm) {
        this(resourceResolver, path, resourceType, vm, null);
    }

    public ValueMapResource(ResourceResolver resourceResolver, String path, String resourceType, @Nonnull ValueMap vm, @CheckForNull Collection<Resource> children) {
        super(resourceResolver, path, resourceType);
        this.vm = vm;
        this.children = children;
    }

    public ValueMapResource(ResourceResolver resourceResolver, ResourceMetadata rm, String resourceType) {
        this(resourceResolver, rm, resourceType, (ValueMap)new ValueMapDecorator(new HashMap<String, Object>()));
    }

    public ValueMapResource(ResourceResolver resourceResolver, ResourceMetadata rm, String resourceType, @Nonnull ValueMap vm) {
        this(resourceResolver, rm, resourceType, vm, null);
    }

    public ValueMapResource(ResourceResolver resourceResolver, ResourceMetadata rm, String resourceType, @Nonnull ValueMap vm, @CheckForNull Collection<Resource> children) {
        super(resourceResolver, rm, resourceType);
        this.vm = vm;
        this.children = children;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (ValueMap.class.equals(type)) {
            return (Type)this.vm;
        }
        return super.adaptTo(type);
    }

    @Override
    public Resource getChild(String relPath) {
        if (this.children == null) {
            return super.getChild(relPath);
        }
        for (Resource child : this.children) {
            if (!child.getPath().equals(this.getPath() + "/" + relPath)) continue;
            return child;
        }
        return null;
    }

    @Override
    public Iterator<Resource> listChildren() {
        if (this.children == null) {
            return super.listChildren();
        }
        return this.children.iterator();
    }

    @Override
    public Iterable<Resource> getChildren() {
        return super.getChildren();
    }

    @Override
    public boolean hasChildren() {
        if (this.children == null) {
            return super.hasChildren();
        }
        return !this.children.isEmpty();
    }
}

