/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.gfx.GFXDecorationInfo;
import com.adobe.xfa.gfx.GFXTextAttr;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextBaselineShift;
import com.adobe.xfa.text.TextField;
import com.adobe.xfa.text.TextMeasurement;
import com.adobe.xfa.text.TextTab;
import com.adobe.xfa.text.TextTabList;
import com.adobe.xfa.text.markup.MarkupAttr;
import com.adobe.xfa.text.markup.MarkupEngineOut;
import com.adobe.xfa.text.markup.MarkupXHTMLAttr;
import com.adobe.xfa.ut.UnitSpan;
import com.adobe.xfa.ut.Version;

public class MarkupXHTMLOut
extends MarkupEngineOut {
    private final StringBuilder mpTranslation = new StringBuilder();
    private final int meDefaultUnits;
    private boolean mbNewPara;
    private boolean mbStarted;
    private boolean mbParaHasContent;
    private final boolean mbIncludeAmbientAttrs;
    private boolean mbNeedSpanEnd;
    private boolean mbSubordinate;
    private final boolean mbBreakupOutput;
    private boolean mbExpandEmbed;
    private final boolean mbRoundTextSize;
    private boolean mbRequiresReset;
    private boolean mbTrailingBreak;
    private TextAttr moParaAttr;
    private final TextAttr moSpanAttr = new TextAttr();
    private final TextAttr moAmbientAttr;
    private final TextAttr moCSSDefault = new TextAttr(true);
    private static final UnitSpan ROUND_SIZE = new UnitSpan(19, 50);
    private static final String gsDblSp = "  ";
    private static final String gsNBSP = "&#160;";
    private static final String gsTab = "\t";
    private static final String gsNL = "\n";
    private static final String gsBR = "<br/>";
    private static final String gsNineSpaces = "&#160; &#160; &#160; &#160; &#160;";
    private static final String gsBodyStart1 = "<body xfa:APIVersion=\"";
    private static final String gsBodyStart2 = "\" xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\">";
    private static final String gsBodyEnd = "</body>";
    private static final String gsParaOpenTag = "<p";
    private static final String gsParaEnd = "</p>";
    private static final String gsEmbedStartType = "<span xfa:embedType=\"";
    private static final String gsEmbedAddMode = "\" xfa:embedMode=\"";
    private static final String gsEmbedAddEmbed = "\" xfa:embed=\"";
    private static final String gsEmbedSom = "som";
    private static final String gsEmbedUri = "uri";
    private static final String gsEmbedRaw = "raw";
    private static final String gsEmbedFormatted = "formatted";
    private static final String gsSpaceRunStart = "<span style=\"xfa-spacerun:yes\">";
    private static final String gsSpaceRunSingle = "<span style=\"xfa-spacerun:yes\">&#160;</span>";
    private static final String gsTabCountStart = "<span style=\"xfa-tab-count:";
    private static final String gsSpanEnd = "</span>";
    private static final String gsSpanOpenTag = "<span";
    private static final String gsStyleStart = "<span style=\"";
    private static final String gsStyleAttr = "style=\"";
    private static final String gsStyleEnd = "\">";
    private static final String gsStyleEndTag = "\"/>";
    private static final String gsTagEnd = ">";
    private static final String gsTextDirectionStart = "dir=\"";
    private static final String gsTextDirectionEnd = "\"";

    public MarkupXHTMLOut(MarkupAttr pMarkupAttr, int eDefaultUnits, TextAttr poAmbientAttrs, boolean bIncludeAmbientAttrs, boolean bBreakupOutput, boolean bExpandEmbed, boolean bRoundTextSize) {
        super(pMarkupAttr == null ? MarkupXHTMLAttr.getDefault() : pMarkupAttr);
        this.mbIncludeAmbientAttrs = bIncludeAmbientAttrs;
        this.mbBreakupOutput = bBreakupOutput;
        this.mbExpandEmbed = bExpandEmbed;
        this.mbRoundTextSize = bRoundTextSize;
        this.mbRequiresReset = true;
        this.mbTrailingBreak = false;
        this.moCSSDefault.special(TextMeasurement.zero());
        this.moCSSDefault.justifyV(1);
        this.moCSSDefault.justifyH(5);
        this.moCSSDefault.tabs(new TextTabList());
        this.moCSSDefault.baselineShift(new TextBaselineShift());
        this.moCSSDefault.colour(GFXColour.black());
        this.moCSSDefault.underline(1);
        this.moCSSDefault.weight(400);
        this.moCSSDefault.italic(false);
        this.moCSSDefault.strikeout(1);
        this.moCSSDefault.marginL(TextMeasurement.zero());
        this.moCSSDefault.marginR(TextMeasurement.zero());
        this.moCSSDefault.hyphLevel(0);
        this.moCSSDefault.leaderAlign(0);
        this.moCSSDefault.leaderPattern(0);
        this.moCSSDefault.ruleStyle(1);
        this.moCSSDefault.ruleThickness(new TextMeasurement(new UnitSpan(19, 1000)));
        this.moCSSDefault.horizontalScale(1.0);
        this.moCSSDefault.verticalScale(1.0);
        this.moCSSDefault.spaceBeforeEnable(false);
        this.moCSSDefault.spaceAfterEnable(false);
        this.moCSSDefault.typefaceEnable(false);
        this.moCSSDefault.sizeEnable(false);
        this.moCSSDefault.spacingEnable(false);
        this.moParaAttr = new TextAttr(this.moCSSDefault);
        this.moAmbientAttr = poAmbientAttrs == null ? new TextAttr() : new TextAttr(poAmbientAttrs);
        this.moAmbientAttr.addDisabled(this.moCSSDefault);
        this.meDefaultUnits = eDefaultUnits;
        this.startDoc();
    }

    public MarkupXHTMLOut(MarkupAttr pMarkupAttr, int eDefaultUnits, TextAttr poAmbientAttrs, boolean bIncludeAmbientAttrs, boolean bBreakupOutput, boolean bExpandEmbed) {
        this(pMarkupAttr, eDefaultUnits, poAmbientAttrs, bIncludeAmbientAttrs, bBreakupOutput, bExpandEmbed, true);
    }

    public MarkupXHTMLOut(MarkupAttr pMarkupAttr, int eDefaultUnits, TextAttr poAmbientAttrs, boolean bIncludeAmbientAttrs, boolean bBreakupOutput) {
        this(pMarkupAttr, eDefaultUnits, poAmbientAttrs, bIncludeAmbientAttrs, bBreakupOutput, true, true);
    }

    public MarkupXHTMLOut(MarkupAttr pMarkupAttr, int eDefaultUnits, TextAttr poAmbientAttrs, boolean bIncludeAmbientAttrs) {
        this(pMarkupAttr, eDefaultUnits, poAmbientAttrs, bIncludeAmbientAttrs, true, true, true);
    }

    public MarkupXHTMLOut(MarkupAttr pMarkupAttr, int eDefaultUnits, TextAttr poAmbientAttrs) {
        this(pMarkupAttr, eDefaultUnits, poAmbientAttrs, false, true, true, true);
    }

    public MarkupXHTMLOut(MarkupAttr pMarkupAttr, int eDefaultUnits) {
        this(pMarkupAttr, eDefaultUnits, null, false, true, true, true);
    }

    public MarkupXHTMLOut(MarkupAttr pMarkupAttr) {
        this(pMarkupAttr, 3, null, false, true, true, true);
    }

    public MarkupXHTMLOut() {
        this(null, 3, null, false, true, true, true);
    }

    @Override
    public void reset() {
        if (this.mbRequiresReset) {
            super.reset();
            this.startDoc();
        }
    }

    @Override
    public String translation() {
        if (!this.mbSubordinate) {
            this.endPara();
            this.mpTranslation.append(gsBodyEnd);
        }
        return this.mpTranslation.toString();
    }

    @Override
    public void text(String oStrText) {
        String sSpanStyle;
        if (oStrText.length() == 0) {
            return;
        }
        this.mbTrailingBreak = false;
        StringBuilder sText = new StringBuilder(oStrText);
        int nOffset = 0;
        int nFoundAt = sText.indexOf(gsDblSp);
        boolean bNewRun = true;
        while (nFoundAt > 0) {
            if (bNewRun) {
                sText.insert(nFoundAt, gsSpaceRunStart);
                nFoundAt = sText.indexOf(gsDblSp);
                bNewRun = false;
            }
            sText.replace(nFoundAt, 1, gsNBSP);
            nOffset = nFoundAt + gsNBSP.length();
            if (sText.charAt(nOffset) != ' ' || sText.charAt(nOffset + 1) != ' ') {
                sText.insert(nOffset + 1, gsSpanEnd);
                bNewRun = true;
            }
            nFoundAt = sText.indexOf(gsDblSp, nOffset);
        }
        if ((this.mbNewPara || sText.length() == 1) && sText.length() > 0 && sText.charAt(0) == ' ') {
            boolean bFoundNonWhiteSpace = false;
            for (int i = 1; i < sText.length(); ++i) {
                if (sText.charAt(i) == ' ') continue;
                bFoundNonWhiteSpace = true;
                break;
            }
            if (bFoundNonWhiteSpace) {
                sText.replace(0, 1, gsSpaceRunSingle);
            }
        }
        if (sText.charAt(sText.length() - 1) == ' ') {
            sText.replace(sText.length() - 1, 1, gsSpaceRunSingle);
        }
        nOffset = 0;
        nFoundAt = sText.indexOf(gsNL);
        while (nFoundAt >= 0) {
            if (nFoundAt == sText.length() - 1) {
                this.mbTrailingBreak = true;
            }
            sText.replace(nFoundAt, 1, gsBR);
            nOffset = nFoundAt + gsBR.length();
            nFoundAt = sText.indexOf(gsNL, nOffset);
        }
        nOffset = 0;
        nFoundAt = sText.indexOf(gsTab);
        while (nFoundAt >= 0) {
            int nTabCount = 1;
            int nTabPos = nFoundAt;
            while (sText.charAt(++nTabPos) == '\t') {
                ++nTabCount;
            }
            StringBuilder sTabReplace = new StringBuilder(gsTabCountStart);
            sTabReplace.append(Integer.toString(nTabCount));
            sTabReplace.append(gsStyleEnd);
            if (this.moSpanAttr.leaderPatternEnable() && this.moSpanAttr.leaderPattern() == 3 && this.moSpanAttr.leaderContentEnable()) {
                MarkupXHTMLOut oMarkup = new MarkupXHTMLOut(this.markupAttr(), this.meDefaultUnits, this.moSpanAttr);
                oMarkup.mbSubordinate = true;
                this.moSpanAttr.leaderContent().markup(oMarkup, this.moSpanAttr, true);
                sTabReplace.append(oMarkup.translation());
            } else {
                for (int i = 0; i < nTabCount; ++i) {
                    sTabReplace.append(gsNineSpaces);
                }
            }
            sTabReplace.append(gsSpanEnd);
            sText.replace(nFoundAt, nTabCount, sTabReplace.toString());
            nOffset = nTabPos + sTabReplace.length();
            nFoundAt = sText.indexOf(gsTab, nOffset);
        }
        this.mbStarted = true;
        this.startPara();
        boolean bSpan = false;
        StringBuilder sMarkup = new StringBuilder();
        String sTextDirection = this.getTextDirection(false);
        if (sTextDirection.length() > 0) {
            bSpan = true;
            sMarkup.append(gsSpanOpenTag);
            sMarkup.append(' ');
            sMarkup.append(gsTextDirectionStart);
            sMarkup.append(sTextDirection);
            sMarkup.append('\"');
        }
        if ((sSpanStyle = this.getSpanStyle(false)).length() > 0) {
            if (bSpan) {
                sMarkup.append(' ');
                sMarkup.append(gsStyleAttr);
            } else {
                sMarkup.append(gsStyleStart);
            }
            bSpan = true;
            sMarkup.append(sSpanStyle);
            sMarkup.append('\"');
        }
        if (bSpan) {
            sMarkup.append(gsTagEnd);
        }
        sMarkup.append((CharSequence)sText);
        if (this.mbNeedSpanEnd) {
            sMarkup.append(gsSpanEnd);
        }
        if (bSpan) {
            sMarkup.append(gsSpanEnd);
        }
        this.mpTranslation.append((CharSequence)sMarkup);
        this.mbNeedSpanEnd = false;
    }

    @Override
    public void attr(TextAttr oAttr) {
        if (!this.mbStarted) {
            this.mbStarted = true;
            this.moParaAttr = oAttr;
            this.pruneParaAttrs();
            this.moSpanAttr.copyFrom(this.moParaAttr);
        } else if (this.mbParaHasContent) {
            this.moSpanAttr.override(oAttr);
        } else {
            this.moParaAttr.override(oAttr);
            this.pruneParaAttrs();
            this.moSpanAttr.copyFrom(this.moParaAttr);
        }
    }

    @Override
    public void para() {
        this.endPara();
        this.mbNewPara = true;
        this.mbParaHasContent = false;
    }

    @Override
    public void field(TextField poField) {
        if (this.mbExpandEmbed) {
            this.mbRequiresReset = false;
            poField.markup(this, null, false, true);
            this.mbRequiresReset = true;
        } else {
            this.startPara();
            boolean bSpan = false;
            StringBuilder sMarkup = new StringBuilder();
            String sSpanStyle = this.getSpanStyle(false);
            if (sSpanStyle.length() > 0) {
                if (bSpan) {
                    sMarkup.append(' ');
                    sMarkup.append(gsStyleAttr);
                } else {
                    sMarkup.append(gsStyleStart);
                }
                bSpan = true;
                sMarkup.append(sSpanStyle);
                sMarkup.append(gsStyleEnd);
            }
            this.mpTranslation.append((CharSequence)sMarkup);
            this.mpTranslation.append(gsEmbedStartType);
            switch (poField.getEmbedType()) {
                case 0: {
                    this.mpTranslation.append(gsEmbedSom);
                    break;
                }
                case 1: {
                    this.mpTranslation.append(gsEmbedUri);
                }
            }
            this.mpTranslation.append(gsEmbedAddMode);
            switch (poField.getEmbedMode()) {
                case 0: {
                    this.mpTranslation.append(gsEmbedRaw);
                    break;
                }
                case 1: {
                    this.mpTranslation.append(gsEmbedFormatted);
                }
            }
            this.mpTranslation.append(gsEmbedAddEmbed);
            this.mpTranslation.append(poField.getExpression());
            this.mpTranslation.append(gsStyleEndTag);
            if (bSpan) {
                this.mpTranslation.append(gsSpanEnd);
            }
        }
    }

    @Override
    public boolean issueFirstPara() {
        return true;
    }

    public void expandEmbed(boolean bExpand) {
        this.mbExpandEmbed = bExpand;
    }

    private void startDoc() {
        this.mbNewPara = !this.mbSubordinate;
        this.mbStarted = false;
        this.mbParaHasContent = false;
        this.mpTranslation.setLength(0);
        if (!this.mbSubordinate) {
            this.mpTranslation.append(gsBodyStart1);
            this.mpTranslation.append(Version.getImplementation());
            this.mpTranslation.append(gsBodyStart2);
        }
    }

    private void addAttr(StringBuilder sStyle, int eCommand, int eParameter) {
        if (sStyle.length() > 0 && sStyle.charAt(sStyle.length() - 1) != ';') {
            sStyle.append(';');
        }
        sStyle.append(this.getAttr(eCommand));
        if (eParameter != 0) {
            sStyle.append(this.getAttr(eParameter));
        }
    }

    private void addAttr(StringBuilder sStyle, int eCommand) {
        this.addAttr(sStyle, eCommand, 0);
    }

    private String getSpanStyle(boolean bIncludeAll) {
        StringBuilder sStyle = new StringBuilder();
        TextAttr oAttr = new TextAttr(this.moSpanAttr);
        if (bIncludeAll) {
            if (this.mbIncludeAmbientAttrs) {
                TextAttr oAmbient = new TextAttr(this.moAmbientAttr);
                oAmbient.dropSame(this.moCSSDefault);
                oAttr.addDisabled(oAmbient);
            } else {
                MarkupXHTMLOut.reconcileAttrs(this.moAmbientAttr, oAttr);
            }
        } else {
            TextAttr oParaAttr = new TextAttr(this.moParaAttr);
            if (!this.mbIncludeAmbientAttrs) {
                oParaAttr.addDisabled(this.moAmbientAttr);
            }
            MarkupXHTMLOut.reconcileAttrs(oParaAttr, oAttr);
        }
        if (oAttr.baselineShiftEnable()) {
            this.addAttr(sStyle, 132);
            sStyle.append(oAttr.baselineShift().getString(false));
        }
        if (oAttr.typefaceEnable()) {
            boolean bWhitespace = false;
            this.addAttr(sStyle, 65);
            if (oAttr.typeface().indexOf(32) > 0) {
                bWhitespace = true;
            }
            if (bWhitespace) {
                sStyle.append('\'');
            }
            sStyle.append(oAttr.typeface());
            if (bWhitespace) {
                sStyle.append('\'');
            }
        }
        if (oAttr.sizeEnable()) {
            UnitSpan oCompareSize;
            UnitSpan oSize = oAttr.size();
            if (this.mbRoundTextSize) {
                oSize = oSize.round(ROUND_SIZE);
            }
            UnitSpan unitSpan = oCompareSize = bIncludeAll ? this.moAmbientAttr.size() : this.moParaAttr.size();
            if (this.mbRoundTextSize) {
                oCompareSize = oCompareSize.round(ROUND_SIZE);
            }
            if (oSize.value() != 0 && (bIncludeAll || !oSize.equals(oCompareSize))) {
                this.addAttr(sStyle, 66);
                this.addUnitSpan(oSize, sStyle, false, true);
            }
        }
        if (oAttr.horizontalScaleEnable()) {
            this.addAttr(sStyle, 72);
            sStyle.append(TextAttr.formatPercent(oAttr.horizontalScale()));
        }
        if (oAttr.verticalScaleEnable()) {
            this.addAttr(sStyle, 73);
            sStyle.append(TextAttr.formatPercent(oAttr.verticalScale()));
        }
        if (oAttr.colourEnable()) {
            GFXColour oColour = oAttr.colour();
            oColour = oColour.scale(255);
            this.addAttr(sStyle, 75);
            sStyle.append('#');
            this.addColour(oColour.r(), sStyle);
            this.addColour(oColour.g(), sStyle);
            this.addColour(oColour.b(), sStyle);
        }
        if (oAttr.weightEnable()) {
            this.addAttr(sStyle, 67);
            if (oAttr.weight() >= 700) {
                sStyle.append(this.getAttr(70));
            } else {
                sStyle.append(this.getAttr(5));
            }
        }
        if (oAttr.italicEnable()) {
            this.addAttr(sStyle, 68);
            if (oAttr.italic()) {
                sStyle.append(this.getAttr(71));
            } else {
                sStyle.append(this.getAttr(5));
            }
        }
        if (oAttr.underlineEnable() || oAttr.strikeoutEnable()) {
            this.addAttr(sStyle, 110);
            GFXDecorationInfo underline = GFXTextAttr.extractDecoration(oAttr.underline());
            GFXDecorationInfo lineThrough = GFXTextAttr.extractDecoration(oAttr.strikeout());
            if (underline == null && lineThrough == null) {
                sStyle.append(this.getAttr(4));
            } else {
                if (underline != null) {
                    if (underline.mCount == 1) {
                        if (underline.mType == 3) {
                            sStyle.append(this.getAttr(87));
                        } else {
                            sStyle.append(this.getAttr(85));
                        }
                    } else if (underline.mType == 3) {
                        sStyle.append(this.getAttr(86));
                        sStyle.append(' ');
                        sStyle.append(this.getAttr(87));
                    } else {
                        sStyle.append(this.getAttr(86));
                    }
                }
                if (lineThrough != null) {
                    if (underline != null) {
                        sStyle.append(' ');
                    }
                    sStyle.append(this.getAttr(81));
                }
            }
        }
        if (oAttr.digits() != 0) {
            int eDigits = oAttr.digits() == 2 ? 162 : 161;
            this.addAttr(sStyle, 159, eDigits);
        }
        if (oAttr.kerningEnable()) {
            this.addAttr(sStyle, 169, oAttr.kerning() ? 4 : 170);
        }
        if (oAttr.charSpacingEnable() && oAttr.charSpacing().getLengthValue() != 0) {
            this.addAttr(sStyle, 54);
            this.addMeasurement(oAttr, oAttr.charSpacing(), sStyle, false, true);
        }
        if (oAttr.wordSpacingEnable() && oAttr.wordSpacing().getLengthValue() != 0) {
            this.addAttr(sStyle, 55);
            this.addMeasurement(oAttr, oAttr.wordSpacing(), sStyle, false, true);
        }
        if (oAttr.hyphLevel() == 0) {
            this.addAttr(sStyle, 171, 4);
        } else {
            this.addAttr(sStyle, 171, 3);
            switch (oAttr.hyphLevel()) {
                case 1: {
                    this.addAttr(sStyle, 172, 173);
                    break;
                }
                case 3: {
                    this.addAttr(sStyle, 172, 2);
                }
            }
        }
        if (oAttr.hyphMinWordEnable() || oAttr.hyphMinPrefixEnable() || oAttr.hyphMinSuffixEnable()) {
            StringBuilder values = new StringBuilder();
            values.append('\'');
            values.append(oAttr.hyphMinWord());
            values.append(' ');
            values.append(oAttr.hyphMinPrefix());
            values.append(' ');
            values.append(oAttr.hyphMinSuffix());
            values.append('\'');
            this.addAttr(sStyle, 174);
            sStyle.append((CharSequence)values);
        }
        if (oAttr.hyphSuppressAcronymsEnable()) {
            this.addAttr(sStyle, 175, oAttr.hyphSuppressAcronyms() ? 4 : 3);
        }
        if (oAttr.hyphSuppressNamesEnable()) {
            this.addAttr(sStyle, 176, oAttr.hyphSuppressNames() ? 4 : 3);
        }
        if (oAttr.leaderAlignEnable()) {
            this.addAttr(sStyle, 177, oAttr.leaderAlign() == 1 ? 178 : 4);
        }
        if (oAttr.leaderPatternEnable()) {
            int ePattern = 180;
            switch (oAttr.leaderPattern()) {
                case 1: {
                    ePattern = 181;
                    break;
                }
                case 2: {
                    ePattern = 182;
                    break;
                }
                case 3: {
                    ePattern = 183;
                }
            }
            this.addAttr(sStyle, 179, ePattern);
        }
        if (oAttr.leaderPatternWidthEnable() && !oAttr.leaderPatternWidth().isZero()) {
            this.addAttr(sStyle, 185);
            this.addMeasurement(oAttr, oAttr.leaderPatternWidth(), sStyle);
        }
        if (oAttr.ruleStyleEnable()) {
            int eStyle = 6;
            switch (oAttr.ruleStyle()) {
                case 0: {
                    eStyle = 4;
                    break;
                }
                case 2: {
                    eStyle = 187;
                    break;
                }
                case 3: {
                    eStyle = 188;
                }
            }
            this.addAttr(sStyle, 186, eStyle);
        }
        if (oAttr.ruleThicknessEnable() && !oAttr.ruleThickness().isZero()) {
            this.addAttr(sStyle, 186);
            this.addMeasurement(oAttr, oAttr.ruleThickness(), sStyle);
        }
        return sStyle.toString();
    }

    private String getParaStyle() {
        StringBuilder sMarkup = new StringBuilder();
        TextAttr oAttr = new TextAttr(this.moParaAttr);
        TextAttr oAmbient = new TextAttr();
        if (this.mbIncludeAmbientAttrs) {
            oAmbient.copyFrom(this.moAmbientAttr);
            oAmbient.dropSame(this.moCSSDefault);
            oAttr.addDisabled(oAmbient);
        } else {
            MarkupXHTMLOut.reconcileAttrs(this.moAmbientAttr, oAttr);
        }
        boolean bWriteMarginL = oAttr.marginLEnable();
        boolean bWriteMarginR = oAttr.marginREnable();
        boolean bWriteMarginT = oAttr.spaceBeforeEnable();
        boolean bWriteMarginB = oAttr.spaceAfterEnable();
        if (bWriteMarginL && bWriteMarginR && bWriteMarginT && bWriteMarginB && oAttr.spaceBefore().equals(oAttr.marginR()) && oAttr.spaceBefore().equals(oAttr.spaceAfter()) && oAttr.spaceBefore().equals(oAttr.marginL())) {
            this.addAttr(sMarkup, 64);
            this.addMeasurement(oAttr, oAttr.spaceBefore(), sMarkup);
        } else {
            if (bWriteMarginT) {
                this.addAttr(sMarkup, 61);
                this.addMeasurement(oAttr, oAttr.spaceBefore(), sMarkup);
            }
            if (bWriteMarginR) {
                this.addAttr(sMarkup, 59);
                this.addMeasurement(oAttr, oAttr.marginR(), sMarkup);
            }
            if (bWriteMarginB) {
                this.addAttr(sMarkup, 62);
                this.addMeasurement(oAttr, oAttr.spaceAfter(), sMarkup);
            }
            if (bWriteMarginL) {
                this.addAttr(sMarkup, 58);
                this.addMeasurement(oAttr, oAttr.marginL(), sMarkup);
            }
        }
        if (oAttr.specialEnable()) {
            this.addAttr(sMarkup, 57);
            this.addMeasurement(oAttr, oAttr.special(), sMarkup);
        }
        if (oAttr.spacingEnable() && oAttr.spacing().getLengthValue() != 0) {
            this.addAttr(sMarkup, 53);
            this.addMeasurement(oAttr, oAttr.spacing(), sMarkup, false, true);
        }
        if (oAttr.justifyVEnable()) {
            switch (oAttr.justifyV()) {
                case 1: {
                    this.addAttr(sMarkup, 128, 129);
                    break;
                }
                case 2: {
                    this.addAttr(sMarkup, 128, 130);
                    break;
                }
                case 3: {
                    this.addAttr(sMarkup, 128, 131);
                }
            }
        }
        if (oAttr.justifyHEnable()) {
            switch (oAttr.justifyH()) {
                case 5: {
                    this.addAttr(sMarkup, 119, 156);
                    break;
                }
                case 6: {
                    this.addAttr(sMarkup, 119, 157);
                    break;
                }
                case 7: {
                    this.addAttr(sMarkup, 119, 158);
                    break;
                }
                case 8: {
                    this.addAttr(sMarkup, 119, 120);
                    break;
                }
                case 9: {
                    this.addAttr(sMarkup, 119, 121);
                    break;
                }
                case 11: {
                    this.addAttr(sMarkup, 119, 125);
                    break;
                }
                case 12: {
                    this.addAttr(sMarkup, 119, 126);
                    break;
                }
                case 13: {
                    this.addAttr(sMarkup, 119, 127);
                }
            }
        }
        if (oAttr.tabsEnable()) {
            this.addAttr(sMarkup, 137);
            this.addUnitSpan(oAttr.tabs().noUniform() ? UnitSpan.ZERO : oAttr.tabs().uniform().tabStop(), sMarkup, false);
            if (oAttr.tabs().size() > 0) {
                this.addAttr(sMarkup, 138);
            }
            block21: for (int i = 1; i <= oAttr.tabs().size(); ++i) {
                if (i != 1) {
                    sMarkup.append(' ');
                }
                TextTab oTab = oAttr.tabs().tabAt(i);
                UnitSpan oStop = oTab.tabStop();
                String sAlign = "";
                switch (oTab.tabType()) {
                    case 0: 
                    case 4: {
                        sAlign = this.getAttr(156);
                        continue block21;
                    }
                    case 1: {
                        sAlign = this.getAttr(157);
                        continue block21;
                    }
                    case 2: 
                    case 5: {
                        sAlign = this.getAttr(158);
                        continue block21;
                    }
                    case 3: {
                        sAlign = this.getAttr(142);
                        sMarkup.append(sAlign);
                        sMarkup.append(' ');
                        this.addUnitSpan(oStop, sMarkup, false);
                    }
                }
            }
        }
        if (oAttr.ligatureEnable()) {
            this.addAttr(sMarkup, 167, oAttr.ligature() == 1 ? 169 : 168);
        }
        return sMarkup.toString();
    }

    private String getTextDirection(boolean bIsPara) {
        int eAttrDirection = 0;
        if (bIsPara) {
            eAttrDirection = this.moSpanAttr.paraDirection();
        }
        if (eAttrDirection == 0) {
            eAttrDirection = this.moSpanAttr.direction();
        }
        if (eAttrDirection == 0) {
            return "";
        }
        int eMkDirection = eAttrDirection == 2 ? 166 : 165;
        return this.getAttr(eMkDirection);
    }

    private void addColour(int lCol, StringBuilder sColour) {
        String s = Integer.toHexString(lCol + 256);
        sColour.append(s, 1, s.length());
    }

    private String getAttr(int eTag) {
        return this.markupAttr().lookup(eTag);
    }

    private void addUnitSpan(UnitSpan oUnits, StringBuilder sAttrs, boolean bUseDefaultUnits) {
        this.addUnitSpan(oUnits, sAttrs, bUseDefaultUnits, false);
    }

    private void addUnitSpan(UnitSpan oUnits, StringBuilder sAttrs, boolean bUseDefaultUnits, boolean bUsePTs) {
        int eUnits = oUnits.units();
        if (bUseDefaultUnits && eUnits != this.meDefaultUnits) {
            oUnits = new UnitSpan(this.meDefaultUnits, UnitSpan.convertUnit(this.meDefaultUnits, eUnits, oUnits.value()));
        } else if (bUseDefaultUnits && eUnits != 19) {
            oUnits = new UnitSpan(19, UnitSpan.convertUnit(19, eUnits, oUnits.value()));
        }
        sAttrs.append(oUnits.text(3, true, false));
    }

    private void addMeasurement(TextAttr oAttr, TextMeasurement oMeasurement, StringBuilder sAttrs, boolean bUseDefaultUnits, boolean bUsePTs) {
        if (bUseDefaultUnits || bUsePTs) {
            this.addUnitSpan(oAttr.flattenMeasurement(oMeasurement), sAttrs, bUseDefaultUnits, bUsePTs);
        } else {
            sAttrs.append(oMeasurement.toString(3));
        }
    }

    private void addMeasurement(TextAttr oAttr, TextMeasurement oMeasurement, StringBuilder sAttrs, boolean bUseDefaultUnits) {
        this.addMeasurement(oAttr, oMeasurement, sAttrs, bUseDefaultUnits, false);
    }

    private void addMeasurement(TextAttr oAttr, TextMeasurement oMeasurement, StringBuilder sAttrs) {
        this.addMeasurement(oAttr, oMeasurement, sAttrs, true);
    }

    private void pruneParaAttrs() {
        MarkupXHTMLOut.reconcileAttrs(this.moAmbientAttr, this.moParaAttr);
    }

    private void startPara() {
        if (!this.mbNewPara) {
            return;
        }
        StringBuilder sMarkup = new StringBuilder();
        sMarkup.append(gsParaOpenTag);
        String sTextDirection = this.getTextDirection(true);
        if (sTextDirection.length() > 0) {
            sMarkup.append(' ');
            sMarkup.append(gsTextDirectionStart);
            sMarkup.append(sTextDirection);
            sMarkup.append(gsTextDirectionEnd);
        }
        StringBuilder sStyle = new StringBuilder();
        sStyle.append(this.getParaStyle());
        sStyle.append(this.getSpanStyle(true));
        if (sStyle.length() == 0) {
            sMarkup.append(gsTagEnd);
        } else {
            if (this.mbBreakupOutput) {
                sMarkup.append('\n');
            } else {
                sMarkup.append(' ');
            }
            sMarkup.append(gsStyleAttr);
            sMarkup.append((CharSequence)sStyle);
            sMarkup.append(gsStyleEnd);
        }
        this.mpTranslation.append((CharSequence)sMarkup);
        this.mbNewPara = false;
        this.mbParaHasContent = true;
    }

    private void endPara() {
        if (!this.mbParaHasContent) {
            this.startPara();
            this.mpTranslation.append(gsSpaceRunSingle);
        }
        if (this.mbTrailingBreak) {
            this.mpTranslation.append(gsBR);
        }
        this.mbTrailingBreak = false;
        this.mpTranslation.append(gsParaEnd);
        this.moParaAttr.override(this.moSpanAttr);
        this.moSpanAttr.copyFrom(this.moParaAttr);
    }

    private static void reconcileAttrs(TextAttr oDrop, TextAttr oAttr) {
        boolean bRestoreDecoration = false;
        int eUnderline = 1;
        int eStrikeout = 1;
        if (oDrop.underlineEnable()) {
            if (oAttr.underlineEnable()) {
                eUnderline = oAttr.underline();
                if (eUnderline != oDrop.underline()) {
                    bRestoreDecoration = true;
                }
            } else {
                eUnderline = oDrop.underline();
            }
        }
        if (oDrop.strikeoutEnable()) {
            if (oAttr.strikeoutEnable()) {
                eStrikeout = oAttr.strikeout();
                if (eStrikeout != oDrop.strikeout()) {
                    bRestoreDecoration = true;
                }
            } else {
                eStrikeout = oDrop.strikeout();
            }
        }
        oAttr.dropSame(oDrop);
        if (bRestoreDecoration) {
            oAttr.underline(eUnderline);
            oAttr.strikeout(eStrikeout);
        }
    }
}

