/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.cq.dam.commons.util.AssetCache;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import com.day.cq.dam.commons.util.UIHelper;
import com.day.cq.dam.commons.util.impl.AssetCacheImpl;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationQueue;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.security.Privilege;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.resource.collection.ResourceCollection;
import org.apache.sling.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamUtil {
    private static final String DEFAULT_PUBLIC_GROUP = "dam-users";
    private static final Logger log = LoggerFactory.getLogger(DamUtil.class);
    private static final String[] IMG_MIME_TYPES = new String[]{"image/png", "image/jpeg", "image/tiff", "image/png", "image/bmp", "image/gif", "image/pjpeg", "image/x-portable-anymap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/x-rgb", "image/x-xbitmap", "image/x-xpixmap", "image/x-icon", "image/photoshop", "image/x-photoshop", "image/psd", "application/photoshop", "application/psd", "image/vnd.adobe.photoshop"};
    private static final String[] VID_MIME_TYPES = new String[]{"video/m4v", "video/flv", "video/avi", "video/mov", "video/3gpp", "application/x-troff-msvideo", "video/vnd", "model/vnd.mts", "video/ts", "video/vnd", "video/dvd", "video/x-ms-wmv", "video/msvideo", "video/x-msvideo", "video/x-flv", "video/mpeg", "video/x-mpeg", "video/x-m4v", "video/mpg", "video/x-mpg", "video/mpeg2", "video/x-mpeg2a", "video/mts", "video/x-ms-asf", "video/3gpp2", "video/x-f4v", "video/f4v", "video/m2p", "video/mp2t", "video/avchd-stream", "video/m2ts", "video/mp2t", "video/vnd.dlna.mpeg-tts", "video/m2v", "video/quicktime", "video/x-quicktime", "video/mp4", "video/ogg", "video/x-mxf", "application/mxf", "video/x-matroska", "video/mj2", "video/vnd.rn-realvideo", "application/vnd.rn-realmedia", "video/webm", "video/x-ms-vob"};
    private static final List<String> IMG_MIME_TYPE = Arrays.asList(IMG_MIME_TYPES);
    private static final List<String> VID_MIME_TYPE = Arrays.asList(VID_MIME_TYPES);
    private static final int MAGIC_SIZE = 1024;
    private static final String DM_OOTB_VIDEO_PROFILE_DIR = "/libs/settings/dam/dm/presets/video";
    private static final String DM_CUSTOM_VIDEO_PROFILE_DIR = "/conf/global/settings/dam/dm/presets/video";
    private static final String MIME_TYPE_ZIP = "application/zip";
    private static final String FILE_EXT_ZIP = ".zip";
    public static final String LIVEFYRE_ID = "livefyreId";
    public static final String LIVEFYRE_THUMBNAIL = "livefyreThumbnail";
    public static final String AGENT_ID_PREVIEW = "preview";

    public static String assetToBinaryPath(String path) {
        String binaryPath = null;
        if (StringUtils.startsWith(path, "/content/dam")) {
            binaryPath = StringUtils.replaceOnce(path, "/content/dam", "/var/dam");
        }
        return binaryPath;
    }

    public static String binaryToAssetPath(String path) {
        String assetPath = null;
        if (StringUtils.startsWith(path, "/var/dam")) {
            assetPath = StringUtils.replaceOnce(path, "/var/dam", "/content/dam");
        }
        return assetPath;
    }

    public static boolean isThumbnail(Node file) {
        try {
            return file.isNodeType("nt:file") && file.getName().startsWith("cq5dam.thumbnail");
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public static Map<String, Pair<String, Integer>> buildEntryDepthMap(SlingScriptHelper sling) {
        return DamUtil.computeEntryDepthMap(sling, null);
    }

    public static Map<String, Pair<String, Integer>> buildEntryDepthMapPreview(SlingScriptHelper sling) {
        return DamUtil.computeEntryDepthMap(sling, AGENT_ID_PREVIEW);
    }

    private static Map<String, Pair<String, Integer>> computeEntryDepthMap(SlingScriptHelper sling, String agentId) {
        HashMap<String, Pair<String, Integer>> entryDepth = new HashMap<String, Pair<String, Integer>>();
        try {
            long startTime = new Date().getTime();
            int assetsTraversed = 0;
            AgentManager agentManager = sling.getService(AgentManager.class);
            for (Agent agent : agentManager.getAgents().values()) {
                if (agent.isInMaintenanceMode()) continue;
                if (StringUtils.isEmpty(agentId) && !agent.getId().equals(AGENT_ID_PREVIEW)) {
                    assetsTraversed += DamUtil.computeAgentPendingEntryMap(entryDepth, agent);
                    continue;
                }
                if (!StringUtils.equals(agentId, agent.getId())) continue;
                assetsTraversed += DamUtil.computeAgentPendingEntryMap(entryDepth, agent);
                break;
            }
            long endTime = new Date().getTime();
            log.debug("Time Elapsed \t" + (endTime - startTime));
            log.debug("assetsTraversed \t" + assetsTraversed);
        }
        catch (Exception e) {
            log.warn("Cannot build entryDepthMap" + (StringUtils.isEmpty(agentId) ? "" : "_" + agentId), e);
        }
        return entryDepth;
    }

    private static int computeAgentPendingEntryMap(Map<String, Pair<String, Integer>> entryDepth, Agent agent) {
        ReplicationQueue queue = agent.getQueue();
        int assetsTraversed = 0;
        if (queue != null) {
            for (ReplicationQueue.Entry entry : queue.entries()) {
                ++assetsTraversed;
                ReplicationAction action = entry.getAction();
                String path = action.getPath();
                String actionType = action.getType().getName();
                int currentItemPosition = entry.getQueuePosition();
                if (entryDepth.containsKey(path) && entryDepth.get(path).getValue() >= currentItemPosition) continue;
                entryDepth.put(path, new MutablePair<String, Integer>(actionType, currentItemPosition));
            }
        }
        return assetsTraversed;
    }

    @Deprecated
    public static String getValidFolderName(String name) {
        log.warn("Deprecated DamUtil.getValidFolderName is used");
        name = name.replaceAll("[\\\\%#{}/^;+:*?.|&\\t\\[\\] ]", "_");
        return name;
    }

    public static String getSanitizedFolderName(String name) {
        return DamUtil.getSanitizedFolderName(name, true);
    }

    public static String getSanitizedFolderName(String name, boolean useLowerCase) {
        String sanitizedFolderName = name.replaceAll("[\\\\%#{}/^;+:*?.|&\\t\\[\\] \"]", "-");
        if (useLowerCase) {
            return sanitizedFolderName.toLowerCase();
        }
        return sanitizedFolderName;
    }

    public static String getValidFileName(String name) {
        name = name.replaceAll("[*/:\\[\\]\\\\|#%{}?&]", "_");
        return name;
    }

    public static boolean isZipTypeAsset(Asset asset) {
        return asset != null && asset.getName().endsWith(FILE_EXT_ZIP) && MIME_TYPE_ZIP.equals(asset.getMimeType());
    }

    public static String getThumbnailName(int width, int height) {
        return DamUtil.getThumbnailName(width, height, null);
    }

    public static String getThumbnailName(ThumbnailConfig config) {
        String[] stringArray;
        if (config.doCenter()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "margin";
        } else {
            stringArray = null;
        }
        String[] selectors = stringArray;
        return DamUtil.getThumbnailName(config.getWidth(), config.getHeight(), selectors);
    }

    public static Node validateFolderNode(String path, Session serviceSession) throws RepositoryException {
        Node node = null;
        node = !serviceSession.nodeExists(path) ? JcrUtils.getOrCreateByPath(path, "nt:unstructured", "nt:unstructured", serviceSession, false) : serviceSession.getNode(path);
        return node;
    }

    @Deprecated
    public static Node createEmptyArchiveNode(Resource configResource, String name, Session serviceSession) throws RepositoryException {
        throw new UnsupportedOperationException("The support was reverted - The method was designed specifically for a caller that has been reverted.");
    }

    public static String getThumbnailName(int width, int height, String[] selectors) {
        String selectorString = StringUtils.join((Object[])(selectors = null != selectors ? selectors : new String[]{}), '.');
        if (!"".equals(selectorString)) {
            selectorString = "." + selectorString;
        }
        return "cq5dam.thumbnail." + String.valueOf(width) + "." + String.valueOf(height) + selectorString + ".png";
    }

    public static boolean isRendition(Resource resource) {
        if (null == resource) {
            return false;
        }
        Resource parent = ResourceUtil.getParent(resource);
        if (null == parent) {
            return false;
        }
        Resource content = ResourceUtil.getParent(parent);
        if (null == content) {
            return false;
        }
        Resource asset = ResourceUtil.getParent(content);
        if (null == asset) {
            return false;
        }
        return "renditions".equals(ResourceUtil.getName(parent)) && (DamUtil.isAsset(asset) || DamUtil.isFrozenNode(asset));
    }

    public static boolean isMetadataRes(Resource resource) {
        if (null == resource || !"metadata".equals(ResourceUtil.getName(resource))) {
            return false;
        }
        Resource content = ResourceUtil.getParent(resource);
        if (null == content) {
            return false;
        }
        Resource asset = ResourceUtil.getParent(content);
        if (null == asset) {
            return false;
        }
        return DamUtil.isAsset(asset) || DamUtil.isFrozenNode(asset);
    }

    public static Asset getAssetFromMetaRes(Resource resource) {
        if (null == resource || !"metadata".equals(ResourceUtil.getName(resource))) {
            return null;
        }
        Resource content = ResourceUtil.getParent(resource);
        if (null == content) {
            return null;
        }
        Resource asset = ResourceUtil.getParent(content);
        if (null == asset) {
            return null;
        }
        if (DamUtil.isAsset(asset) || DamUtil.isFrozenNode(asset)) {
            return asset.adaptTo(Asset.class);
        }
        return null;
    }

    public static boolean isAsset(Resource resource) {
        return null != resource && "dam:Asset".equals(resource.getResourceType());
    }

    public static boolean isFrozenNode(Resource resource) {
        return null != resource && "nt:frozenNode".equals(resource.getResourceType());
    }

    public static boolean isSubAsset(Resource resource) {
        return DamUtil.isAsset(resource) && "subassets".equals(ResourceUtil.getName(ResourceUtil.getParent(resource)));
    }

    public static Asset resolveToAsset(Resource resource) {
        if (null != resource && DamUtil.isAsset(resource)) {
            return resource.adaptTo(Asset.class);
        }
        Resource parent = ResourceUtil.getParent(resource);
        if (null != parent) {
            return DamUtil.resolveToAsset(parent);
        }
        return null;
    }

    public static void setModified(Asset asset, String user, Calendar date) {
        try {
            Node contentNode = asset.adaptTo(Node.class).getNode("jcr:content");
            contentNode.setProperty("jcr:lastModifiedBy", user);
            contentNode.setProperty("jcr:lastModified", date);
            contentNode.getSession().save();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public static List<String> findExpiringAssets(Session session, Calendar lowerBound, Calendar upperBound) throws RepositoryException {
        ArrayList<String> results = null;
        Query qom = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            QueryObjectModelFactory qomf = queryManager.getQOMFactory();
            Selector damAsset = qomf.selector("dam:Asset", "selector_0");
            Source assetContent = qomf.selector("dam:AssetContent", "selector_1");
            ValueFactory vf = session.getValueFactory();
            PropertyValue expiryDateOprnd = qomf.propertyValue("selector_1", "offTime");
            Constraint expiryDateConstrnt = null;
            Comparison upperBndConstrnt = null;
            if (upperBound != null) {
                Literal upperBndOprnd = qomf.literal(vf.createValue(upperBound));
                expiryDateConstrnt = upperBndConstrnt = qomf.comparison(expiryDateOprnd, "jcr.operator.less.than", upperBndOprnd);
            }
            if (lowerBound != null) {
                Literal lowerBndOprnd = qomf.literal(vf.createValue(lowerBound));
                Comparison lowerBndConstrnt = qomf.comparison(expiryDateOprnd, "jcr.operator.greater.than.or.equal.to", lowerBndOprnd);
                expiryDateConstrnt = upperBndConstrnt != null ? qomf.and(upperBndConstrnt, lowerBndConstrnt) : lowerBndConstrnt;
            }
            SameNodeJoinCondition joinAssetToJcrContent = qomf.sameNodeJoinCondition("selector_1", "selector_0", "jcr:content");
            assetContent = qomf.join(damAsset, assetContent, "jcr.join.type.inner", joinAssetToJcrContent);
            qom = qomf.createQuery(assetContent, expiryDateConstrnt, null, null);
            if (log.isDebugEnabled()) {
                log.debug("Expiring assets query [{}].", (Object)qom.getStatement());
            }
            long startTime = 0L;
            if (log.isTraceEnabled()) {
                startTime = System.currentTimeMillis();
            }
            QueryResult result = qom.execute();
            if (log.isTraceEnabled()) {
                long endTime = System.currentTimeMillis();
                log.trace("Time taken to execute query [{}] ms", (Object)new Long(endTime - startTime));
            }
            RowIterator rowIter = result.getRows();
            long resultSize = rowIter.getSize();
            results = new ArrayList<String>(new Long(resultSize).intValue());
            if (log.isDebugEnabled()) {
                log.debug("ResultSet size [{}].", (Object)resultSize);
            }
            if (log.isTraceEnabled()) {
                log.trace("Logging search result set");
            }
            while (rowIter.hasNext()) {
                Row row = rowIter.nextRow();
                Node node = row.getNode("selector_0");
                String path = node.getPath();
                if (log.isTraceEnabled()) {
                    log.trace("path  [{}]", (Object)path);
                }
                results.add(path);
            }
        }
        catch (RepositoryException e) {
            if (qom != null) {
                log.error("Expired assets query [{}].", (Object)qom.getStatement());
            }
            log.error("Error in finding expired assets", e);
            throw e;
        }
        return results;
    }

    public static boolean isExpiredAsset(Asset asset) {
        boolean isAssetExpired = false;
        if (null != asset) {
            Calendar now = Calendar.getInstance();
            Calendar assetExpiryTime = DamUtil.getExpiryTime(asset);
            if (null != assetExpiryTime) {
                isAssetExpired = assetExpiryTime.getTimeInMillis() - now.getTimeInMillis() < 0L;
            }
        }
        return isAssetExpired;
    }

    public static boolean isExpiredAsset(Resource resource) {
        return DamUtil.isExpiredAsset(resource.adaptTo(Asset.class));
    }

    public static boolean isExpiredSubAsset(Resource resource) {
        boolean isSubAssetExpired;
        block2: {
            Calendar subAssetExpiryTime;
            Asset each;
            Resource subRes;
            Node subNode;
            boolean isAssetExpired = false;
            isSubAssetExpired = false;
            Asset asset = resource.adaptTo(Asset.class);
            if (null == asset || (isAssetExpired = DamUtil.isExpiredAsset(asset))) break block2;
            Calendar now = Calendar.getInstance();
            Collection<Asset> subAssets = asset.getSubAssets();
            List<Asset> refSubAssets = DamUtil.getReferencedSubAssets(resource);
            if (null != refSubAssets) {
                subAssets.addAll(refSubAssets);
            }
            ResourceResolver resolver = resource.getResourceResolver();
            Iterator<Asset> iterator = subAssets.iterator();
            while (iterator.hasNext() && (null == (subNode = (subRes = resolver.getResource((each = iterator.next()).getPath())).adaptTo(Node.class)) || null == (subAssetExpiryTime = DamUtil.getExpiryTime(each)) || !(isSubAssetExpired = subAssetExpiryTime.getTimeInMillis() - now.getTimeInMillis() < 0L))) {
            }
        }
        return isSubAssetExpired;
    }

    public static String getValue(Node n, String name, String defaultValue) throws RepositoryException {
        if (n == null) {
            return defaultValue;
        }
        try {
            if (n.hasProperty(name)) {
                Property p = n.getProperty(name);
                if (!p.isMultiple()) {
                    return p.getString();
                }
                Value[] values = p.getValues();
                String val = "";
                boolean first = true;
                for (Value a : values) {
                    if (!first) {
                        val = val + ", ";
                    } else {
                        first = false;
                    }
                    val = val + a.getString();
                }
                return val;
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static boolean isImage(Asset asset) {
        return IMG_MIME_TYPE.contains(asset.getMimeType());
    }

    public static boolean isImage(String mimeType) {
        return IMG_MIME_TYPE.contains(mimeType);
    }

    public static boolean isThreeD(Asset asset) {
        return Boolean.parseBoolean(asset.getMetadataValue("dam:interactive3DAsset"));
    }

    public static boolean isVideo(Asset asset) {
        String[] errantTypes = new String[]{"mpv", "m2ts", "m2t", "m2p", "vob", "ts", "webm", "mkv"};
        List<String> errantList = Arrays.asList(errantTypes);
        return VID_MIME_TYPE.contains(asset.getMimeType()) || asset.getMimeType() == null && errantList.contains(StringUtils.substringAfterLast(asset.getName(), ".").toLowerCase());
    }

    public static boolean isSmartCollection(Resource resource) {
        return resource.isResourceType("dam/smartcollection");
    }

    public static boolean isCollection(Resource resource) {
        return resource != null && (resource.adaptTo(ResourceCollection.class) != null || resource.isResourceType("dam/collection") || resource.isResourceType("dam/smartcollection"));
    }

    public static boolean isPublic(Resource resource) throws RepositoryException {
        ResourceResolver resolver = resource.getResourceResolver();
        String publicGroup = DamUtil.getPublicGroup(resolver);
        Set<Principal> principals = DamUtil.getPrincipalsForGroups(resolver, publicGroup, "everyone");
        JackrabbitAccessControlManager acm = DamUtil.getAccessControlManager(resolver);
        return acm.hasPrivileges(resource.getPath(), principals, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
    }

    private static String getPublicGroup(ResourceResolver resolver) {
        Tenant tenant = resolver.adaptTo(Tenant.class);
        String tenantPublicGroup = tenant == null ? null : (String)tenant.getProperty("dam:allUsersGroupId");
        return StringUtils.defaultIfEmpty(tenantPublicGroup, DEFAULT_PUBLIC_GROUP);
    }

    private static Set<Principal> getPrincipalsForGroups(ResourceResolver resolver, String ... groups) throws RepositoryException {
        HashSet<Principal> principals = new HashSet<Principal>();
        UserManager userManager = resolver.adaptTo(UserManager.class);
        for (String group : groups) {
            Authorizable authorizable = userManager.getAuthorizable(group);
            if (authorizable == null) continue;
            principals.add(authorizable.getPrincipal());
        }
        return principals;
    }

    private static JackrabbitAccessControlManager getAccessControlManager(ResourceResolver resolver) throws RepositoryException {
        Session session = resolver.adaptTo(Session.class);
        return (JackrabbitAccessControlManager)session.getAccessControlManager();
    }

    public static Node getApplicableProfile(Asset asset, String profileType, Session session) {
        Resource resource = asset.adaptTo(Resource.class);
        return DamUtil.getApplicableProfile(resource, profileType, session);
    }

    public static Node getApplicableProfile(Resource resource, String profileType, Session session) {
        try {
            Node assetNode = resource.adaptTo(Node.class);
            String path = "";
            SlingHttpServletRequest req = resource.adaptTo(SlingHttpServletRequest.class);
            if (null != assetNode) {
                Node parentNode = assetNode;
                while (!parentNode.getPath().equals("/content/dam")) {
                    if (!parentNode.isNodeType("dam:Asset") && parentNode.hasProperty("jcr:content/" + profileType) && (path = parentNode.getProperty("jcr:content/" + profileType).getString()).startsWith("/")) {
                        if (session.nodeExists(path)) {
                            return session.getNode(path);
                        }
                        if ("videoProfile".equals(profileType) && !session.nodeExists(path)) {
                            String name = path.substring(path.lastIndexOf("/"));
                            name = name.replaceAll(" ", "_");
                            String ootbVideoProfile = DM_OOTB_VIDEO_PROFILE_DIR + name;
                            String customVideoProfile = DM_CUSTOM_VIDEO_PROFILE_DIR + name;
                            if (session.nodeExists(ootbVideoProfile)) {
                                return session.getNode(ootbVideoProfile);
                            }
                            if (session.nodeExists(customVideoProfile)) {
                                return session.getNode(customVideoProfile);
                            }
                        }
                    }
                    parentNode = parentNode.getParent();
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Unable to retrieve applicable profile", e);
        }
        return null;
    }

    @Deprecated
    public static String getAppliedProcessingProfilePath(Asset asset) {
        return null;
    }

    public static Iterator<Asset> getAssets(Resource res) {
        Asset asset = res.adaptTo(Asset.class);
        if (asset == null) {
            return new FolderAssetIterator(res);
        }
        return Collections.singletonList(asset).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean checkforAIFile(Asset asset) {
        block8: {
            int len;
            byte[] data;
            PushbackInputStream pin;
            InputStream in;
            block9: {
                in = null;
                if (asset == null || asset.getOriginal() == null) break block8;
                in = asset.getOriginal().getStream();
                pin = new PushbackInputStream(in, 1024);
                data = new byte[1024];
                len = pin.read(data);
                if (len > 0) break block9;
                boolean bl = false;
                IOUtils.closeQuietly(in);
                return bl;
            }
            pin.unread(data, 0, len);
            byte[] pdfMarker = new byte[]{37, 80, 68, 70, 45};
            int size = 1024;
            if (size > len) {
                size = len;
            }
            byte[] header = new byte[size];
            System.arraycopy(data, 0, header, 0, size);
            long result = Utility.KMPFindFirst(pdfMarker, Utility.ComputeKMPNextArray(pdfMarker), header);
            boolean bl = result >= 0L;
            IOUtils.closeQuietly(in);
            return bl;
            {
                catch (IOException e) {
                    log.warn("I/O error while getting metadata.", e);
                    break block8;
                }
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        return false;
    }

    public static Rendition getBestFitRendition(int width, List<Rendition> renditions) {
        PrefixRenditionPicker prefixPicker = new PrefixRenditionPicker("cq5dam.thumbnail." + width);
        Rendition bestFitRendition = prefixPicker.getRendition(renditions.iterator());
        if (bestFitRendition == null) {
            prefixPicker = new PrefixRenditionPicker("cq5dam.web." + width);
            bestFitRendition = prefixPicker.getRendition(renditions.iterator());
        }
        if (bestFitRendition != null) {
            return bestFitRendition;
        }
        WidthBasedRenditionComparator comp = new WidthBasedRenditionComparator();
        Collections.sort(renditions, comp);
        Iterator<Rendition> itr = renditions.iterator();
        Rendition bestFit = null;
        Rendition highResRend = null;
        long bestFitRenditionSize = Long.MAX_VALUE;
        int renditionMaxWidth = Integer.MIN_VALUE;
        while (itr.hasNext()) {
            Rendition rend = itr.next();
            if (!UIHelper.canRenderOnWeb(rend.getMimeType()) || rend.getName().equals("original")) continue;
            int currentRenditionWidth = UIHelper.getWidth(rend);
            long currentRenditionSize = rend.getSize();
            if (currentRenditionWidth > renditionMaxWidth) {
                renditionMaxWidth = currentRenditionWidth;
                highResRend = rend;
            }
            if (currentRenditionWidth < width || bestFitRenditionSize <= currentRenditionSize) continue;
            bestFit = rend;
            bestFitRenditionSize = currentRenditionSize;
        }
        if (width > renditionMaxWidth) {
            bestFit = highResRend;
        }
        return bestFit;
    }

    public static Rendition getBestFitFPORendition(Asset asset, String[] renditionPreferenceList) {
        String rendition;
        PrefixRenditionPicker prefixRenditionPicker;
        Rendition bestFitFPO = null;
        if (asset == null || renditionPreferenceList == null) {
            log.debug("Invalid arguments for getBestFitFPORendition");
            return null;
        }
        log.debug("FPO Rendition Preference List : {}", (Object)Arrays.toString(renditionPreferenceList));
        String[] stringArray = renditionPreferenceList;
        int n = stringArray.length;
        for (int i = 0; i < n && (bestFitFPO = (prefixRenditionPicker = new PrefixRenditionPicker(rendition = stringArray[i])).getRendition(asset.listRenditions())) == null; ++i) {
        }
        log.debug("Best Fit FPO: {}", (Object)(bestFitFPO != null ? bestFitFPO.getPath() : "null"));
        return bestFitFPO;
    }

    public static Dimension getImageDimension(InputStream is, String filename) {
        Dimension imageDimension = new Dimension(0, 0);
        try {
            imageDimension = Imaging.getImageSize(is, filename);
        }
        catch (ImageReadException ex) {
            log.error("Error in getting image dimension for rendition : " + filename, ex);
            return imageDimension;
        }
        catch (IOException ex) {
            log.error("Error in getting image dimension for rendition : " + filename, ex);
            return imageDimension;
        }
        return imageDimension;
    }

    public static Dimension getImageDimension(Rendition rendition) {
        Dimension imageDimension = null;
        ValueMap props = rendition.getProperties();
        if (props.containsKey("width") && props.containsKey("height")) {
            int wid = Integer.parseInt(props.get("width").toString());
            int hei = Integer.parseInt(props.get("height").toString());
            imageDimension = new Dimension(wid, hei);
        }
        if (imageDimension == null) {
            imageDimension = DamUtil.getDimensionsFromRenditionName(rendition.getName());
        }
        if (imageDimension == null && rendition.getName().equals("original")) {
            Asset asset = rendition.getAsset();
            String widthProp = "";
            String heightProp = "";
            widthProp = asset.getMetadataValue("tiff:ImageWidth");
            heightProp = asset.getMetadataValue("tiff:ImageLength");
            if (StringUtils.isBlank(widthProp) || StringUtils.isBlank(heightProp)) {
                widthProp = asset.getMetadataValue("dam:ExifImageWidth");
                heightProp = asset.getMetadataValue("dam:ExifImageHeight");
            }
            if (StringUtils.isBlank(widthProp) || StringUtils.isBlank(heightProp)) {
                widthProp = asset.getMetadataValue("exif:PixelXDimension");
                heightProp = asset.getMetadataValue("exif:PixelYDimension");
            }
            if (StringUtils.isBlank(widthProp) || StringUtils.isBlank(heightProp)) {
                widthProp = "0";
                heightProp = "0";
            }
            imageDimension = new Dimension(Integer.parseInt(widthProp), Integer.parseInt(heightProp));
        }
        return imageDimension;
    }

    public static boolean expiryStatus(Asset asset) {
        return false;
    }

    public static List<Asset> getReferencedSubAssets(Resource resource) {
        return DamUtil.getReferencedResources(resource, "links", Asset.class);
    }

    public static List<ResourceCollection> getReferencedCollections(Resource resource) {
        return DamUtil.getReferencedResources(resource, "collection-links", ResourceCollection.class);
    }

    private static <X> List<X> getReferencedResources(Resource resource, String relatedName, Class<X> type) {
        ArrayList<X> references = new ArrayList<X>();
        Node node = resource.adaptTo(Node.class);
        try {
            Value[] referencePaths;
            String propertyPath = String.format("jcr:content/related/%s/sling:members/sling:resources", JcrUtil.escapeIllegalJcrChars(relatedName));
            if (node == null || !node.hasProperty(propertyPath)) {
                return references;
            }
            for (Value resPath : referencePaths = node.getProperty(propertyPath).getValues()) {
                Resource reference = resource.getResourceResolver().getResource(resPath.getString());
                if (reference == null || reference.adaptTo(type) == null) continue;
                references.add(reference.adaptTo(type));
            }
        }
        catch (RepositoryException ex) {
            log.warn("Error getting referenced resources", ex);
        }
        return references;
    }

    public static Collection<Asset> getSubAssets(Resource resource) {
        Asset asset;
        Collection<Asset> assets = new LinkedList<Asset>();
        if (null != resource && null != (asset = resource.adaptTo(Asset.class))) {
            assets = asset.getSubAssets();
        }
        return assets;
    }

    public static Collection<Asset> getRefererAssets(ResourceResolver resolver, String path) {
        String sub = "select a.[jcr:path] as [jcr:path], a.[jcr:score] as [jcr:score], a.* from [dam:Asset] as a inner join [nt:base] as jc on ischildnode(jc, a) inner join [nt:base] as related on ischildnode(related, jc) inner join [nt:base] as links on ischildnode(links, related) inner join [nt:base] as members on ischildnode(members, links) inner join [nt:base] as e on ischildnode(e, members) where isdescendantnode(a, '%s') and name(jc) = 'jcr:content' and name(related) = 'related' and name(links) = 'links' and name(members) = 'sling:members' and e.[dam:resolvedPath] = '%s'";
        String query = String.format(sub, "/content/dam", path.replaceAll("'", "''"));
        log.debug("Find Referer Query: " + query);
        Iterator<Resource> iter = resolver.findResources(query, "JCR-SQL2");
        ArrayList<Asset> assets = new ArrayList<Asset>();
        while (iter.hasNext()) {
            Resource res = iter.next();
            Asset asset = null;
            if (null != res) {
                asset = res.adaptTo(Asset.class);
            }
            if (null == asset) continue;
            assets.add(asset);
        }
        return assets;
    }

    public static Calendar getExpiryTime(Asset asset) {
        if (asset == null) {
            return null;
        }
        Resource assetRes = asset.adaptTo(Resource.class);
        Calendar assetExpiryTime = (Calendar)((Object)assetRes.adaptTo(ValueMap.class).get("jcr:content/metadata/prism:expirationDate", Calendar.class));
        return assetExpiryTime;
    }

    public static Asset getParentAsset(Resource resource) {
        if (null != resource && DamUtil.isSubAsset(resource)) {
            return resource.getParent().getParent().adaptTo(Asset.class);
        }
        if (null == resource) {
            log.error("Resource NULL.");
        } else {
            log.debug("Resource {} is not a sub-asset", (Object)resource.getPath());
        }
        return null;
    }

    public static boolean isValid(Asset asset) throws RepositoryException {
        return DamUtil.isValid(asset.adaptTo(Node.class));
    }

    public static String getTenantAssetsRoot(ResourceResolver resolver) {
        Tenant tenant;
        User user = resolver.adaptTo(User.class);
        String mountPoint = "/content/dam";
        if (user != null && !user.isSystemUser() && (tenant = resolver.adaptTo(Tenant.class)) != null) {
            mountPoint = (String)tenant.getProperty("dam:assetsRoot");
        }
        return mountPoint;
    }

    public static String getTenantAssetsRoot(ResourceResolver resolver, String assetPath) {
        Resource assetResource = resolver.getResource(assetPath);
        if (assetResource == null) {
            return "/content/dam";
        }
        Tenant tenant = assetResource.adaptTo(Tenant.class);
        if (tenant == null) {
            return "/content/dam";
        }
        return (String)tenant.getProperty("dam:assetsRoot");
    }

    public static String getTenantAssetsRoot(Resource resource) {
        if (resource == null) {
            return "/content/dam";
        }
        Tenant tenant = resource.adaptTo(Tenant.class);
        if (tenant == null) {
            return "/content/dam";
        }
        return (String)tenant.getProperty("dam:assetsRoot");
    }

    public static String getUserCollectionsPath(ResourceResolver resolver) {
        String collectionHome = DamUtil.getTenantProperty(resolver, "dam:collectionHome", "/content/dam/collections");
        try {
            String userHome = resolver.adaptTo(User.class).getPath();
            String tenantUserHome = DamUtil.getTenantProperty(resolver, "dam:tenantUserHome", "/home/users");
            userHome = StringUtils.substringAfter(userHome, tenantUserHome);
            return collectionHome + userHome;
        }
        catch (RepositoryException ex) {
            log.warn("Can't retrieve user path. Will return tenant collections path", ex);
            return collectionHome;
        }
    }

    private static String getTenantProperty(ResourceResolver resolver, String property, String defaultValue) {
        if (resolver == null) {
            return defaultValue;
        }
        Tenant tenant = resolver.adaptTo(Tenant.class);
        if (tenant == null) {
            return defaultValue;
        }
        String value = (String)tenant.getProperty(property);
        return StringUtils.defaultIfEmpty(value, defaultValue);
    }

    public static Asset getAssetFromID(ResourceResolver resolver, String id) throws RepositoryException {
        try {
            Node assetNode = resolver.adaptTo(Session.class).getNodeByIdentifier(id);
            return resolver.getResource(assetNode.getPath()).adaptTo(Asset.class);
        }
        catch (ItemNotFoundException ign) {
            return null;
        }
        catch (RepositoryException ignoreOrRethrow) {
            if (ignoreOrRethrow.getCause() instanceof IllegalArgumentException) {
                return null;
            }
            throw ignoreOrRethrow;
        }
    }

    public static String findRelativePathOfAssetNode(Node assetNode, String assetsRoot) throws RepositoryException {
        String assetAbsPath = assetNode.getPath();
        int idx = -1;
        idx = assetAbsPath.indexOf(assetsRoot);
        if (0 <= idx) {
            idx += assetsRoot.length();
        }
        return assetAbsPath.substring(idx + 1);
    }

    private static boolean isValid(Node assetNode) throws RepositoryException {
        return DamUtil.timeUntilValid(assetNode) == 0L;
    }

    private static long timeUntilValid(Node assetNode) throws RepositoryException {
        long timeUntilOff;
        long timeUntilOn;
        if (!DamUtil.hasContent(assetNode)) {
            return Long.MIN_VALUE;
        }
        Calendar onTime = DamUtil.getOnTime(assetNode);
        Calendar offTime = DamUtil.getOffTime(assetNode);
        if (onTime == null && offTime == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long l = timeUntilOn = onTime == null ? 0L : onTime.getTimeInMillis() - now;
        if (timeUntilOn > 0L) {
            return timeUntilOn;
        }
        long l2 = timeUntilOff = offTime == null ? 0L : offTime.getTimeInMillis() - now;
        if (timeUntilOff < 0L) {
            return timeUntilOff;
        }
        return 0L;
    }

    private static boolean hasContent(Node assetNode) throws RepositoryException {
        return assetNode.hasNode("jcr:content");
    }

    private static Calendar getOnTime(Node assetNode) throws RepositoryException {
        if (DamUtil.hasContent(assetNode) && assetNode.getNode("jcr:content").hasProperty("onTime")) {
            return assetNode.getNode("jcr:content").getProperty("onTime").getDate();
        }
        return null;
    }

    private static Calendar getOffTime(Node assetNode) throws RepositoryException {
        if (DamUtil.hasContent(assetNode) && assetNode.getNode("jcr:content").hasProperty("offTime")) {
            return assetNode.getNode("jcr:content").getProperty("offTime").getDate();
        }
        return null;
    }

    private static <T> T getInheritedProperty(String property, Resource resource, Class<T> type) {
        if (null == type) {
            log.debug("type argument can't be null");
            return null;
        }
        if (StringUtils.isBlank(property)) {
            log.debug("property name can't be empty");
            return null;
        }
        if (null == resource) {
            log.debug("content resource could not be null");
            return null;
        }
        Class<T> value = null;
        while (null != resource) {
            ValueMap propertiesMap = resource.adaptTo(ValueMap.class);
            if (null != propertiesMap && propertiesMap.containsKey(property)) {
                value = propertiesMap.get(property, type);
                break;
            }
            resource = resource.getParent();
        }
        if (null == value) {
            if (null == resource) {
                log.debug("property {} not found on the content path", (Object)property);
            } else {
                log.debug("property value retrived could not be converted to {}", (Object)type.getName());
            }
            return null;
        }
        return (T)value;
    }

    public static <T> T getInheritedProperty(String property, Resource resource, T defaultValue) {
        if (null == defaultValue) {
            log.debug("defaultValue argument cant be null");
            return null;
        }
        Class<?> value = DamUtil.getInheritedProperty(property, resource, defaultValue.getClass());
        if (null != value) {
            return (T)value;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean isInRunningWorkflow(Resource resource) {
        boolean retVal = false;
        try {
            Resource jcrContent = resource.getResourceResolver().getResource(resource.getPath() + "/" + "jcr:content");
            ValueMap properties = jcrContent.getValueMap();
            if (properties.containsKey("dam:assetState")) {
                if (properties.get("dam:assetState").equals("processing")) {
                    retVal = true;
                    return retVal;
                }
            }
        }
        catch (Exception exception) {}
        finally {
            return retVal;
        }
    }

    public static AssetCache getAssetCache() {
        return AssetCacheImpl.getCache();
    }

    private static Dimension getDimensionsFromRenditionName(String name) {
        Pattern pattern = Pattern.compile(".*?(\\d+)\\.(\\d+).+");
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            int wid = Integer.parseInt(matcher.group(1));
            int hei = Integer.parseInt(matcher.group(2));
            if (wid > 0 && hei > 0) {
                return new Dimension(wid, hei);
            }
        }
        return null;
    }

    public static boolean isLivefyreFragment(Resource resource) {
        ValueMap properties;
        boolean flag = false;
        Resource livefyreMetadata = resource.getChild("jcr:content/metadata");
        if (null != livefyreMetadata && (properties = livefyreMetadata.getValueMap()).get(LIVEFYRE_ID, String.class) != null) {
            flag = true;
        }
        return flag;
    }

    public static <T> T getInheritedContentProperty(String property, Resource resource, T defaultValue) {
        if (null == defaultValue) {
            log.debug("defaultValue argument cant be null");
            return null;
        }
        Object value = DamUtil.getInheritedContentProperty(property, resource, defaultValue.getClass());
        if (null != value) {
            return (T)value;
        }
        return defaultValue;
    }

    private static <T> T getInheritedContentProperty(String property, Resource resource, Class<T> type) {
        if (null == type) {
            log.debug("type argument can't be null");
            return null;
        }
        if (StringUtils.isBlank(property)) {
            log.debug("property name can't be empty");
            return null;
        }
        if (null == resource) {
            log.debug("content resource could not be null");
            return null;
        }
        ResourceResolver resolver = resource.getResourceResolver();
        Class<T> value = null;
        while (null != resource && !"/content/dam".equals(resource.getPath())) {
            Resource contentResource = resolver.getResource(resource.getPath() + "/" + "jcr:content");
            if (null == contentResource) {
                log.debug("resource content for resrouce {} could not be null", (Object)resource.getPath());
                return null;
            }
            ValueMap propertiesMap = contentResource.adaptTo(ValueMap.class);
            if (null != propertiesMap && propertiesMap.containsKey(property)) {
                value = propertiesMap.get(property, type);
                break;
            }
            resource = resource.getParent();
        }
        if (null == value) {
            if (null == resource) {
                log.debug("property {} not found on the content path", (Object)property);
            } else {
                log.debug("property value retrived could not be converted to {}", (Object)type.getName());
            }
            return null;
        }
        return (T)value;
    }

    public static void skipBOM(InputStream stream, String encodingFormat) throws IOException {
        if (encodingFormat != null) {
            if (encodingFormat.contains("UTF-16")) {
                stream.skip(2L);
            } else if (encodingFormat.contains("UTF-32")) {
                stream.skip(4L);
            }
        }
    }

    public static String getTitle(@Nonnull Resource resource) {
        String title = "";
        Asset asset = resource.adaptTo(Asset.class);
        if (asset != null && resource.adaptTo(ContentFragment.class) == null) {
            title = asset.getMetadataValueFromJcr("dc:title");
        } else {
            Resource content = resource.getChild("jcr:content");
            if (content == null) {
                content = resource;
            }
            ValueMap vm = content.adaptTo(ValueMap.class);
            title = vm.get("jcr:title", "");
        }
        return title;
    }

    public static boolean isAudio(Asset asset) {
        if (asset == null) {
            return false;
        }
        String mimeType = asset.getMimeType();
        return StringUtils.isBlank(mimeType) ? false : mimeType.startsWith("audio/");
    }

    public static boolean isVtt(Asset asset) {
        if (asset == null) {
            return false;
        }
        String mimeType = asset.getMimeType();
        return StringUtils.isBlank(mimeType) ? false : mimeType.equalsIgnoreCase("text/vtt");
    }

    public static boolean isVideoSubAsset(Asset asset) {
        boolean isAudioOrVtt;
        boolean bl = isAudioOrVtt = DamUtil.isAudio(asset) || DamUtil.isVtt(asset);
        if (!isAudioOrVtt || !asset.isSubAsset()) {
            return false;
        }
        Asset parentAsset = DamUtil.getParentAsset(asset.adaptTo(Resource.class));
        return parentAsset != null && DamUtil.isVideo(parentAsset);
    }

    private static class FolderAssetIterator
    implements Iterator<Asset> {
        private Resource parentResource;
        private Iterator<Resource> it = null;
        private List<Resource> parentNodes = new ArrayList<Resource>();
        private Asset next = null;

        private Iterator<Resource> getChildren(Resource res) {
            ResourceCollection rc = res.adaptTo(ResourceCollection.class);
            if (rc != null) {
                return rc.getResources();
            }
            return res.listChildren();
        }

        public FolderAssetIterator(Resource resource) {
            this.parentResource = resource;
            this.it = this.getChildren(this.parentResource);
            this.next = this.getNext();
        }

        private Asset getNext() {
            while (!this.it.hasNext() && !this.parentNodes.isEmpty()) {
                this.it = this.getChildren(this.parentNodes.remove(0));
            }
            while (this.it.hasNext()) {
                Resource member = this.it.next();
                Node n = member.adaptTo(Node.class);
                try {
                    if (n.isNodeType("dam:Asset")) {
                        return member.adaptTo(Asset.class);
                    }
                    if (!n.isNodeType("nt:folder") && member.adaptTo(ResourceCollection.class) == null) continue;
                    this.parentNodes.add(member);
                }
                catch (RepositoryException e) {
                    log.error("unexpected exception ", e);
                }
            }
            if (!this.parentNodes.isEmpty()) {
                return this.getNext();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Asset next() {
            Asset toReturn = this.next;
            this.next = this.getNext();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not allowed for asset iterator on folder listing");
        }
    }

    private static class WidthBasedRenditionComparator
    implements Comparator<Rendition> {
        private WidthBasedRenditionComparator() {
        }

        @Override
        public int compare(Rendition r1, Rendition r2) {
            int w2;
            int w1 = UIHelper.getWidth(r1);
            if (w1 < (w2 = UIHelper.getWidth(r2))) {
                return -1;
            }
            if (w1 == w2) {
                return 0;
            }
            return 1;
        }
    }
}

