/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api;

import com.day.cq.commons.predicates.NodePredicate;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Predicate.class}, property={"service.vendor=Adobe Systems Incorporated", "predicate.name=page"})
public class PageNodePredicate
implements NodePredicate {
    private final Logger log = LoggerFactory.getLogger(PageNodePredicate.class);

    @Override
    public boolean test(Node node) {
        try {
            String primaryName = node.getPrimaryNodeType().getName();
            if (primaryName.equals("cq:Page")) {
                return true;
            }
            if (primaryName.equals("nt:folder") || primaryName.equals("sling:Folder") || primaryName.equals("sling:OrderedFolder")) {
                return node.hasNodes();
            }
        }
        catch (RepositoryException e) {
            this.log.warn("RepositoryException in PageNodePredicate.test()", e);
        }
        return false;
    }
}

