/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Predicates;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.Cursors;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePattern;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePatternUtil;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.query.SQL2Parser;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIndexPlan {
    static final Logger LOG = LoggerFactory.getLogger(PropertyIndexPlan.class);
    public static final double COST_OVERHEAD = 2.0;
    static final int MAX_COST = 100;
    private final NodeState definition;
    private final String name;
    private final Set<String> properties;
    private final Set<IndexStoreStrategy> strategies;
    private final Filter filter;
    private boolean matchesAllTypes;
    private boolean matchesNodeTypes;
    private final double cost;
    private final Set<String> values;
    private final int depth;
    private final PathFilter pathFilter;
    private final boolean unique;
    private final boolean deprecated;

    PropertyIndexPlan(String name, NodeState root, NodeState definition, Filter filter) {
        this(name, root, definition, filter, Mounts.defaultMountInfoProvider());
    }

    PropertyIndexPlan(String name, NodeState root, NodeState definition, Filter filter, MountInfoProvider mountInfoProvider) {
        this.name = name;
        this.unique = definition.getBoolean("unique");
        this.definition = definition;
        this.properties = Sets.newHashSet(definition.getNames("propertyNames"));
        this.pathFilter = PathFilter.from(definition.builder());
        this.strategies = this.getStrategies(definition, mountInfoProvider);
        this.filter = filter;
        Iterable<String> types = definition.getNames("declaringNodeTypes");
        this.matchesAllTypes = !definition.hasProperty("declaringNodeTypes");
        this.deprecated = definition.getBoolean("deprecated");
        this.matchesNodeTypes = this.matchesAllTypes || Iterables.any(types, (Predicate)Predicates.in(filter.getSupertypes()));
        ValuePattern valuePattern = new ValuePattern(definition);
        double bestCost = Double.POSITIVE_INFINITY;
        Set<Object> bestValues = Collections.emptySet();
        int bestDepth = 1;
        if (this.matchesNodeTypes && this.pathFilter.areAllDescendantsIncluded(filter.getPath())) {
            for (String property : this.properties) {
                String prefix;
                Filter.PropertyRestriction restriction = filter.getPropertyRestriction(property);
                int depth = 1;
                if (restriction == null) {
                    String suffix = "/" + property;
                    for (Filter.PropertyRestriction relative : filter.getPropertyRestrictions()) {
                        if (!relative.propertyName.endsWith(suffix)) continue;
                        restriction = relative;
                        depth = PathUtils.getDepth(relative.propertyName);
                    }
                }
                if (restriction == null || restriction.isNullRestriction() || depth != 1 && !this.matchesAllTypes) continue;
                Set<String> values = ValuePatternUtil.getValues(restriction, new ValuePattern());
                if (!valuePattern.matchesAll() && (values == null ? !valuePattern.matchesPrefix(prefix = ValuePatternUtil.getLongestPrefix(filter, property)) : !valuePattern.matchesAll(values))) continue;
                values = PropertyIndexUtil.encode(values);
                double cost = this.strategies.isEmpty() ? 100.0 : 0.0;
                for (IndexStoreStrategy strategy : this.strategies) {
                    cost += (double)strategy.count(filter, root, definition, values, 100);
                }
                if (this.unique && cost <= 1.0) {
                    cost = 0.0;
                }
                if (!(cost < bestCost)) continue;
                bestDepth = depth;
                bestValues = values;
                bestCost = cost;
                if (bestCost != 0.0) continue;
                break;
            }
        }
        this.depth = bestDepth;
        this.values = bestValues;
        this.cost = 2.0 + bestCost;
    }

    String getName() {
        return this.name;
    }

    double getCost() {
        return this.cost;
    }

    Cursor execute() {
        QueryLimits settings = this.filter.getQueryLimits();
        if (this.deprecated) {
            String caller = IndexUtils.getCaller(settings.getIgnoredClassNamesInCallTrace());
            LOG.warn("This index is deprecated: {}; it is used for query {} called by {}. Please change the query or the index definitions.", this.name, this.filter, caller);
        }
        ArrayList iterables = Lists.newArrayList();
        for (IndexStoreStrategy s : this.strategies) {
            iterables.add(s.query(this.filter, this.name, this.definition, this.values));
        }
        Cursor cursor = Cursors.newPathCursor((Iterable)Iterables.concat((Iterable)iterables), (QueryLimits)settings);
        if (this.depth > 1) {
            cursor = Cursors.newAncestorCursor((Cursor)cursor, (int)(this.depth - 1), (QueryLimits)settings);
        }
        return cursor;
    }

    Filter getFilter() {
        return this.filter;
    }

    Set<IndexStoreStrategy> getStrategies(NodeState definition, MountInfoProvider mountInfoProvider) {
        return Multiplexers.getStrategies(this.unique, mountInfoProvider, definition, ":index");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("property ").append(this.name).append("\n");
        buffer.append("    indexDefinition: /");
        buffer.append("oak:index");
        buffer.append("/").append(this.name).append("\n");
        buffer.append("    values: ");
        if (this.values == null) {
            buffer.append("all values in the index (warning: may be slow)");
        } else if (this.values.isEmpty()) {
            buffer.append("not applicable");
        } else if (this.values.size() == 1) {
            buffer.append(SQL2Parser.escapeStringLiteral((String)this.values.iterator().next()));
        } else {
            boolean comma = false;
            for (String value : this.values) {
                if (comma) {
                    buffer.append(", ");
                }
                buffer.append(SQL2Parser.escapeStringLiteral((String)value));
                comma = true;
            }
        }
        buffer.append("\n");
        buffer.append("    estimatedCost: ").append(this.cost).append("\n");
        return buffer.toString();
    }
}

