/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.AggregationAware;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositeRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestrictionProvider
implements RestrictionProvider,
AggregationAware,
AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestrictionProvider.class);
    private final Map<String, RestrictionDefinition> supported;
    private CompositeRestrictionProvider composite = null;

    public AbstractRestrictionProvider(@NotNull Map<String, ? extends RestrictionDefinition> definitions) {
        this.supported = ImmutableMap.copyOf(definitions);
    }

    @Override
    public void setComposite(@NotNull CompositeRestrictionProvider composite) {
        this.composite = composite;
    }

    @Override
    @NotNull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
        if (this.isUnsupportedPath(oakPath)) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(this.supported.values());
    }

    @Override
    @NotNull
    public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, @NotNull Value value) throws RepositoryException {
        RestrictionDefinition definition = this.getDefinition(oakPath, oakName);
        Type<?> requiredType = definition.getRequiredType();
        int tag = requiredType.tag();
        if (tag != 0 && tag != value.getType()) {
            throw new AccessControlException("Unsupported restriction: Expected value of type " + requiredType + " for " + oakName);
        }
        PropertyState propertyState = requiredType.isArray() ? PropertyStates.createProperty(oakName, (Iterable<Value>)ImmutableList.of((Object)value), tag) : PropertyStates.createProperty(oakName, value);
        return AbstractRestrictionProvider.createRestriction(propertyState, definition);
    }

    @Override
    @NotNull
    public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, Value ... values) throws RepositoryException {
        PropertyState propertyState;
        RestrictionDefinition definition = this.getDefinition(oakPath, oakName);
        Type<?> requiredType = definition.getRequiredType();
        for (Value v : values) {
            if (requiredType.tag() == 0 || requiredType.tag() == v.getType()) continue;
            throw new AccessControlException("Unsupported restriction: Expected value of type " + requiredType + " for " + oakName);
        }
        if (requiredType.isArray()) {
            propertyState = PropertyStates.createProperty(oakName, Arrays.asList(values), requiredType.tag());
        } else {
            if (values.length != 1) {
                throw new AccessControlException("Unsupported restriction: Expected single value for " + oakName);
            }
            propertyState = PropertyStates.createProperty(oakName, values[0]);
        }
        return AbstractRestrictionProvider.createRestriction(propertyState, definition);
    }

    @Override
    @NotNull
    public Set<Restriction> readRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) {
        if (this.isUnsupportedPath(oakPath)) {
            return Collections.emptySet();
        }
        HashSet<Restriction> restrictions = new HashSet<Restriction>();
        for (PropertyState propertyState : this.getRestrictionsTree(aceTree).getProperties()) {
            String propName = propertyState.getName();
            if (!AbstractRestrictionProvider.isRestrictionProperty(propName)) continue;
            RestrictionDefinition def = this.supported.get(propName);
            if (def != null) {
                if (def.getRequiredType() == propertyState.getType()) {
                    restrictions.add(AbstractRestrictionProvider.createRestriction(propertyState, def));
                    continue;
                }
                log.warn("Found restriction '{}' with type mismatch: expected '{}', found '{}'. It will be ignored.", propName, def.getRequiredType(), propertyState.getType());
                continue;
            }
            if (this.isSupportedByAnotherProvider(oakPath, propName)) continue;
            log.warn("Unsupported restriction '{}' detected at {}. It will be ignored.", (Object)propName, (Object)oakPath);
        }
        return restrictions;
    }

    @Override
    public void writeRestrictions(@Nullable String oakPath, @NotNull Tree aceTree, @NotNull Set<Restriction> restrictions) throws RepositoryException {
        if (!restrictions.isEmpty()) {
            Tree rTree = TreeUtil.getOrAddChild(aceTree, "rep:restrictions", "rep:Restrictions");
            for (Restriction restriction : restrictions) {
                rTree.setProperty(restriction.getProperty());
            }
        }
    }

    @Override
    public void validateRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) throws AccessControlException {
        Map<String, PropertyState> restrictionProperties = this.getRestrictionProperties(aceTree);
        if (this.isUnsupportedPath(oakPath)) {
            Set unsupportedNames = restrictionProperties.keySet().stream().filter(name -> !this.isSupportedByAnotherProvider(oakPath, (String)name)).collect(Collectors.toSet());
            if (!unsupportedNames.isEmpty()) {
                throw new AccessControlException("Restrictions '" + unsupportedNames + "' not supported with path '" + oakPath + "'.");
            }
        } else {
            for (Map.Entry<String, PropertyState> entry : restrictionProperties.entrySet()) {
                String restrName = entry.getKey();
                RestrictionDefinition def = this.supported.get(restrName);
                if (def != null) {
                    Type<?> type = entry.getValue().getType();
                    if (type == def.getRequiredType()) continue;
                    throw new AccessControlException("Invalid restriction type '" + type + "' for " + restrName + ". Expected " + def.getRequiredType());
                }
                if (this.isSupportedByAnotherProvider(oakPath, restrName)) continue;
                throw new AccessControlException("Unsupported restriction: " + restrName);
            }
            for (RestrictionDefinition def : this.supported.values()) {
                if (!def.isMandatory() || restrictionProperties.containsKey(def.getName())) continue;
                throw new AccessControlException("Mandatory restriction " + def.getName() + " is missing.");
            }
        }
    }

    protected boolean isUnsupportedPath(@Nullable String oakPath) {
        return oakPath == null;
    }

    @NotNull
    protected Tree getRestrictionsTree(@NotNull Tree aceTree) {
        Tree restrictions = aceTree.getChild("rep:restrictions");
        if (!restrictions.exists()) {
            restrictions = aceTree;
        }
        return restrictions;
    }

    @NotNull
    private RestrictionDefinition getDefinition(@Nullable String oakPath, @NotNull String oakName) throws AccessControlException {
        if (this.isUnsupportedPath(oakPath)) {
            throw new AccessControlException("Unsupported restriction at " + oakPath);
        }
        RestrictionDefinition definition = this.supported.get(oakName);
        if (definition == null) {
            throw new AccessControlException("Unsupported restriction: " + oakName);
        }
        return definition;
    }

    private boolean isSupportedByAnotherProvider(@Nullable String oakPath, @NotNull String oakName) {
        if (this.composite != null) {
            return this.composite.getSupportedRestrictions(oakPath).stream().anyMatch(restrictionDefinition -> restrictionDefinition.getName().equals(oakName));
        }
        return false;
    }

    @NotNull
    private static Restriction createRestriction(@NotNull PropertyState propertyState, @NotNull RestrictionDefinition definition) {
        return new RestrictionImpl(propertyState, definition);
    }

    @NotNull
    private Map<String, PropertyState> getRestrictionProperties(@NotNull Tree aceTree) {
        Tree rTree = this.getRestrictionsTree(aceTree);
        HashMap<String, PropertyState> restrictionProperties = new HashMap<String, PropertyState>();
        for (PropertyState propertyState : rTree.getProperties()) {
            String name = propertyState.getName();
            if (!AbstractRestrictionProvider.isRestrictionProperty(name)) continue;
            restrictionProperties.put(name, propertyState);
        }
        return restrictionProperties;
    }

    private static boolean isRestrictionProperty(@NotNull String propertyName) {
        return !AccessControlConstants.ACE_PROPERTY_NAMES.contains(propertyName) && !"jcr".equals(Text.getNamespacePrefix(propertyName));
    }
}

