/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.xml;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.xml.AbstractXML2003Parser;
import org.apache.tika.sax.TeeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SpreadsheetMLParser
extends AbstractXML2003Parser {
    static final String CELL = "cell";
    static final String DATA = "data";
    static final String ROW = "row";
    static final String WORKSHEET = "worksheet";
    private static final MediaType MEDIA_TYPE = MediaType.application("vnd.ms-spreadsheetml");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    protected ContentHandler getContentHandler(ContentHandler ch, Metadata metadata, ParseContext context) {
        return new TeeContentHandler(super.getContentHandler(ch, metadata, context), new ExcelMLHandler(ch));
    }

    @Override
    public void setContentType(Metadata metadata) {
        metadata.set("Content-Type", MEDIA_TYPE.toString());
    }

    private class ExcelMLHandler
    extends DefaultHandler {
        final ContentHandler handler;
        StringBuilder buffer = new StringBuilder();
        String href = null;
        boolean inData = false;
        private boolean inBody = false;

        public ExcelMLHandler(ContentHandler handler) {
            this.handler = handler;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            localName = localName.toLowerCase(Locale.US);
            if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri)) {
                if ("body".equals(localName)) {
                    this.inBody = true;
                } else if ("table".equals(localName)) {
                    this.handler.startElement("http://www.w3.org/1999/xhtml", "table", "table", AbstractXML2003Parser.EMPTY_ATTRS);
                    this.handler.startElement("http://www.w3.org/1999/xhtml", "tbody", "tbody", AbstractXML2003Parser.EMPTY_ATTRS);
                } else if (SpreadsheetMLParser.WORKSHEET.equals(localName)) {
                    String worksheetName = attrs.getValue("urn:schemas-microsoft-com:office:spreadsheet", "Name");
                    AttributesImpl xhtmlAttrs = new AttributesImpl();
                    if (worksheetName != null) {
                        xhtmlAttrs.addAttribute("http://www.w3.org/1999/xhtml", "name", "name", "cdata", worksheetName);
                    }
                    this.handler.startElement("http://www.w3.org/1999/xhtml", "div", "div", xhtmlAttrs);
                } else if (SpreadsheetMLParser.ROW.equals(localName)) {
                    this.handler.startElement("http://www.w3.org/1999/xhtml", "tr", "tr", AbstractXML2003Parser.EMPTY_ATTRS);
                } else if (SpreadsheetMLParser.CELL.equals(localName)) {
                    this.href = attrs.getValue("urn:schemas-microsoft-com:office:spreadsheet", "HRef");
                    this.handler.startElement("http://www.w3.org/1999/xhtml", "td", "td", AbstractXML2003Parser.EMPTY_ATTRS);
                } else if (SpreadsheetMLParser.DATA.equals(localName)) {
                    this.inData = true;
                }
            }
        }

        @Override
        public void characters(char[] str, int offset, int len) throws SAXException {
            if (this.inData) {
                this.buffer.append(str, offset, len);
            } else if (this.inBody) {
                this.handler.characters(str, offset, len);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            localName = localName.toLowerCase(Locale.US);
            if ("urn:schemas-microsoft-com:office:spreadsheet".equals(uri)) {
                if ("table".equals(localName)) {
                    this.handler.endElement("http://www.w3.org/1999/xhtml", "tbody", "tbody");
                    this.handler.endElement("http://www.w3.org/1999/xhtml", "table", "table");
                } else if (SpreadsheetMLParser.WORKSHEET.equals(localName)) {
                    this.handler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
                } else if (SpreadsheetMLParser.ROW.equals(localName)) {
                    this.handler.endElement("http://www.w3.org/1999/xhtml", "tr", "tr");
                } else if (SpreadsheetMLParser.CELL.equals(localName)) {
                    this.handler.endElement("http://www.w3.org/1999/xhtml", "td", "td");
                } else if (SpreadsheetMLParser.DATA.equals(localName)) {
                    String b;
                    if (this.href != null) {
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addAttribute("http://www.w3.org/1999/xhtml", "href", "href", "cdata", this.href);
                        this.handler.startElement("http://www.w3.org/1999/xhtml", "a", "a", attrs);
                    }
                    if ((b = this.buffer.toString()) == null) {
                        b = "";
                    }
                    char[] chars = b.trim().toCharArray();
                    this.handler.characters(chars, 0, chars.length);
                    if (this.href != null) {
                        this.handler.endElement("http://www.w3.org/1999/xhtml", "a", "a");
                    }
                    this.buffer.setLength(0);
                    this.inData = false;
                    this.href = null;
                }
            }
        }
    }
}

