/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.projects.api;

import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;

import java.io.InputStream;

/**
 * Defines the interface for a CQ Project Link.
 * Note that all changes are transient and need to be committed by the caller, see {@link ProjectManager} for details.
 */
public interface ProjectLink extends Adaptable {
    /**
     * Returns the project that this link is associated with.
     * @return the project that this link is associated with.
     */
    Project getProject();

    /**
     * Returns the target path or url of this link.
      * @return the target path or url of this link.
     */
    String getTarget();

    /**
     * Set the target path or url for this link.
     * @param target the target path or url for this link
     */
    void setTarget(String target);

    /**
     * Returns the title of the link.
     * @return the title of the link.
     */
    String getTitle();

    /**
     * Set a new title for the link.
     * @param title the new name for the link
     * @throws ProjectException if the operation fails
     */
    void setTitle(String title);

    /**
     * Returns the title of the target of this link if no title was set on this link.
     * If a title was set on this link with {@link #setTitle} then that title will be returned,
     * otherwise the title of the target resource will be returned.
     * E.g. If the link points to a cq:Page the page's title will be returned,
     * similarly if the link points to an Asset the asset's title will be returned.
     * @return the resolved title for this link.
     */
    String getResolvedTitle();

    /**
     * Returns the description of the link.
     * @return the description of the link.
     */
    String getDescription();

    /**
     * Set a new description for the link.
     * @param description the new description for the link
     * @throws ProjectException if the operation fails
     */
    void setDescription(String description);

    /**
     * Associate a new image to this link's cover.
     * This call will replace the exist cover image asset and add it to the
     * asset resource collection.
     * @param mimeType the mime type of the provided input stream
     * @param stream a stream of image data.
     * @throws ProjectException if updating the cover image fails.
     */
    void setCoverImage(String mimeType, InputStream stream);

    /**
     * Returns the resource representing the project's cover image.
     * @return a image asset resource, or null if there is no cover image specified.
     */
    Resource getCoverImage();
}
