/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * This interface defines the services that handle href related actions in an XFA based form.
 */
public interface HrefHandler {

   /**
     * Resolves the <code>usehref</code> attribute in the given <code>ProtoableNode</code> and
     * loads the referenced document into a new <code>AppModel</code>.
	 * Any fragment identifier in the URL is ignored.
     * @param protoableNode a <code>ProtoableNode</code> with a <code>usehref</code> attribute.
     * @return the newly created <code>AppModel</code> containing the document loaded
     * from the referenced location, or <code>null</code> upon error.
     */
	public AppModel loadFragment(ProtoableNode protoableNode);
	
	/**
     * Resolves a URL and loads the reference XFA document into a new <code>AppModel</code>.
	 * Any fragment identifier in the URL is ignored.
     * @param appModel the <code>AppModel</code> containing the URL.
     * @param sUrl the URL that references the external XFA document
     * @return the newly created <code>AppModel</code> containing the document loaded
     * from the referenced location.
     */
	public AppModel loadFragment(AppModel appModel, String sUrl);

	/**
     * Gets the <code>TemplateModel</code> associated with the
	 * given <code>AppModel</code>.
     * @param appModel an <code>AppModel</code>
     * @return the <code>TemplateModel</code> from <code>appModel</code> 
     * or <code>null</code> if there is no <code>TemplateModel</code>.
     */
	public Model getDocument(AppModel appModel);
}
