/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

/**
 * A superclass to represent a list of nodes.
 */
public abstract class NodeList extends ListBase {

	/**
	 * Instantiates a node list.
	 */
	public NodeList() {
	}

	/**
	 * Creates a copy of this node list.
	 * <p>
	 * This method does not make copies of the underlying object
	 * implementations, it just place them in a new storage.
	 * 
	 * @return a new node list.
	 */
	abstract public Object clone();

	/**
	 * Gets the first child of this node list with the given name.
	 * 
	 * @param name the name of the child node.
	 * @return the first child of this node with the given name.
	 */
	abstract public Node getNamedItem(String name);

	/**
     *  Get the first child of this node with the given <code>name</code>
     *
     *  @param aName the name of the node to search for.
     *  @param aClassName the class of node to search for, ignored if null. If non-null, this String must be interned.
     *  @param nOccurrence the occurrence to search for.
     *  @return the first child of this node with the given <code>name</code> and classname.
	 *
	 * @exclude from published api.
     */
	abstract public Node getNamedItem(String aName, String aClassName /* = null */, int nOccurrence /* = 0 */);
	
    /**
     *  Return the occurrence of this node in its collection of
     *  like-named, liked-classed,  nodes.
     *  @param oNode - the node to search for
     *  @param nOccurrence - the occurrence to populate
     *  @return Null if not found, Integer occurence if found.
     */
	abstract Integer getOccurrence(Node oNode);

	/**
	 * @exclude from published api.
	 */
	public ScriptTable getScriptTable() {
		return NodeListScript.getScriptTable();
	}

}
