/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * This class contains all the script functionality associated with the
 * Packet class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class PacketScript extends ElementScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ElementScript.moScriptTable,
		"packet",
		new ScriptPropObj[] {
			new ScriptPropObj(PacketScript.class, "content", "getContent", "setContent", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_CONTENT_DESC, 0*/, 0)
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(PacketScript.class, "setAttribute", "setAttribute", Arg.EMPTY,
				new int[] { Arg.STRING, Arg.STRING /*, XFA_IS_SETATTRIBUTE_PARAM1, XFA_IS_SETATTRIBUTE_PARAM2 */ }, 2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_SETATTRIBUTE_DESC, 0*/, "setAttributePermsCheck", 0),
			new ScriptFuncObj(PacketScript.class, "getAttribute", "getAttribute", Arg.STRING,
				new int[] { Arg.STRING /*, XFA_IS_GETATTRIBUTE_PARAM1 */ },1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETATTRIBUTE_DESC, XFA_IS_GETATTRIBUTE_RET, null*/, 0),
			new ScriptFuncObj(PacketScript.class, "removeAttribute", "removeAttribute", Arg.EMPTY,
				new int[] { Arg.STRING /*, XFA_IS_REMOVEATTRIBUTE_PARAM1 */ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_REMOVEATTRIBUTE_DESC, 0*/, "removeAttributePermsCheck", 0)
		}
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getAttribute(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setString(((Packet) pObj).getAttribute(pArgs[0].getString()));
	}

	public static void getContent(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Packet) pObj).getContent());
	}

	public static void removeAttribute(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Packet) pObj).removeAttribute(pArgs[0].getString());
	}

	public static void setAttribute(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Packet) pObj).setAttribute(pArgs[0].getString(), pArgs[1].getString());
	}

	public static void setContent(Obj pObj, Arg oArg) {
		((Packet) pObj).setContent(oArg.getString());
	}

	public static boolean removeAttributePermsCheck(Obj obj, Arg[] args) {
		//	Check permissions on the parent node and all its ancestors.
		//	Check permissions on the node to remove and all its decendents.

		if (obj instanceof Element) {
			Element element = (Element)obj;
			if (!element.checkAncestorPerms())
				return false;
		}
		
		// Javaport: The C++ doesn't make sense since the parameter to 
		// removeAttribute is a String, and not an Obj. If we ever hit
		// this code it would throw ExFull(ResId.ArgumentMismatchException).
		// watson 1908009
		//
		// The same comments for setAttributePermsCheck apply here:
		// an Attribute can't be locked in the Java implementation, and
		// MDP/MDP+ will never lock it in the C++ implementation.
		
//		Obj oObject = pArgs[0].getObject();
//		if (oObject instanceof Node) {
//			Node poTree = (Node)oObject;
//			if (! poTree.checkDescendentPerms())
//				return false;
//		}
		return true;
	}

	public static boolean setAttributePermsCheck(Obj pObj, Arg[] pArgs) {
		//	Check permissions on the parent node and all its ancestors.
		//	Check permissions on attribute if it already exists.

		if (pObj instanceof Element) {
			Element poTree = (Element)pObj;
			if (! poTree.checkAncestorPerms())
				return false;
			
			// Javaport: The following section doesn't make sense in XFA4J
			// since the the XFA DOM object that represents the attribute
			// will never be derived from XFATreeImpl, and therefore cannot
			// be locked. However, MDP/MDP+ never applies a permissions lock
			// at the attribute level, so this is not an issue.
			
//			jfAtom aAttrName = jfAtomTable.peekAtom(pArgs[1].getString());
//			jfDomNode oAttr = ((Packet) pObj).getAttributeNode(aAttrName);
//			if (! oAttr.isNull()) {
//				jfObjImpl* poUserObject = oAttr.getImpl().getUserObject();
//				if (poUserObject && poUserObject.IsDerivedFrom(JF_CLS_XFATREE)) {
//					// check perms on the old attribute
//					XFATreeImpl* poAttr = (XFATreeImpl*)poUserObject;
//					if (! poAttr.checkPerms())
//						return false;
//				}
//			}
		}
		
		return true;
	}
}
